/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.algo.BytesStoreHash;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.bytes.internal.ReleasedBytesStore;
import net.openhft.chronicle.bytes.util.DecoratedBufferOverflowException;
import net.openhft.chronicle.bytes.util.DecoratedBufferUnderflowException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.UnsafeText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBytes<Underlying>
extends AbstractReferenceCounted
implements Bytes<Underlying> {
    private static final boolean BYTES_BOUNDS_UNCHECKED = Jvm.getBoolean("bytes.bounds.unchecked", false);
    @UsedViaReflection
    private final String name;
    @NotNull
    protected BytesStore<Bytes<Underlying>, Underlying> bytesStore;
    protected long readPosition;
    protected long writePosition;
    protected long writeLimit;
    protected boolean isPresent;
    private int lastDecimalPlaces = 0;
    private boolean lenient = false;
    private boolean lastNumberHadDigits = false;

    AbstractBytes(@NotNull BytesStore<Bytes<Underlying>, Underlying> bytesStore, long writePosition, long writeLimit) throws IllegalStateException {
        this(bytesStore, writePosition, writeLimit, "");
    }

    AbstractBytes(@NotNull BytesStore<Bytes<Underlying>, Underlying> bytesStore, long writePosition, long writeLimit, String name) throws IllegalStateException {
        super(bytesStore.isDirectMemory());
        this.bytesStore(bytesStore);
        bytesStore.reserve(this);
        this.readPosition = bytesStore.readPosition();
        this.uncheckedWritePosition(writePosition);
        this.writeLimit = writeLimit;
        this.name = name;
    }

    @Override
    public boolean isDirectMemory() {
        return this.bytesStore.isDirectMemory();
    }

    @Override
    public boolean canReadDirect(long length) {
        long remaining = this.writePosition() - this.readPosition;
        return this.bytesStore.isDirectMemory() && remaining >= length;
    }

    @Override
    public void move(long from, long to, long length) throws BufferUnderflowException, IllegalStateException, ArithmeticException {
        long start = this.start();
        this.bytesStore.move(from - start, to - start, length);
    }

    @Override
    @NotNull
    public Bytes<Underlying> compact() throws IllegalStateException {
        long start = this.start();
        long readRemaining = this.readRemaining();
        try {
            if (readRemaining > 0L && start < this.readPosition) {
                this.bytesStore.move(this.readPosition, start, readRemaining);
                this.readPosition = start;
                this.uncheckedWritePosition(this.readPosition + readRemaining);
            }
            return this;
        }
        catch (ArithmeticException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @NotNull
    public Bytes<Underlying> clear() throws IllegalStateException {
        long start;
        this.readPosition = start = this.start();
        this.uncheckedWritePosition(start);
        this.writeLimit = this.capacity();
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> clearAndPad(long length) throws BufferOverflowException {
        long l;
        if (this.start() + length > this.capacity()) {
            throw this.newBOERange(this.start(), length, "clearAndPad failed. Start: %d + length: %d > capacity: %d", this.capacity());
        }
        this.readPosition = l = this.start() + length;
        this.uncheckedWritePosition(l);
        this.writeLimit = this.capacity();
        return this;
    }

    @Override
    public long readLimit() {
        return this.writePosition();
    }

    @Override
    public long writeLimit() {
        return this.writeLimit;
    }

    @Override
    public long realCapacity() {
        return this.bytesStore.capacity();
    }

    @Override
    @Deprecated
    public long realWriteRemaining() {
        return Math.min(this.realCapacity(), this.writeLimit()) - this.writePosition();
    }

    @Override
    public boolean canWriteDirect(long count) {
        return this.isDirectMemory() && Math.min(this.writeLimit, this.bytesStore.realCapacity()) >= count + this.writePosition();
    }

    @Override
    public long capacity() {
        return this.bytesStore.capacity();
    }

    @Override
    @Nullable
    public Underlying underlyingObject() {
        return this.bytesStore.underlyingObject();
    }

    @Override
    public long start() {
        return this.bytesStore.start();
    }

    @Override
    public long readPosition() {
        return this.readPosition;
    }

    @Override
    public long writePosition() {
        return this.writePosition;
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int value) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 4L);
        return this.bytesStore.compareAndSwapInt(offset, expected, value);
    }

    @Override
    public void testAndSetInt(long offset, int expected, int value) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.testAndSetInt(offset, expected, value);
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long value) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 8L);
        return this.bytesStore.compareAndSwapLong(offset, expected, value);
    }

    @Override
    @NotNull
    public AbstractBytes append(double d) throws BufferOverflowException, IllegalStateException {
        boolean fits = this.canWriteDirect(380L);
        double ad = Math.abs(d);
        if (ad < 1.0E-18) {
            this.append(Double.toString(d));
            return this;
        }
        if (!fits) {
            boolean bl = fits = 1.0E-6 <= ad && ad < 1.0E20 && this.canWriteDirect(24L);
        }
        if (fits) {
            long address = this.addressForWrite(this.writePosition());
            long address2 = UnsafeText.appendDouble(address, d);
            this.writeSkip(address2 - address);
            return this;
        }
        BytesInternal.append(this, d);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> readPosition(long position) throws BufferUnderflowException, IllegalStateException {
        if (position < this.start()) {
            throw new DecoratedBufferUnderflowException(String.format("readPosition failed. Position: %d < start: %d", position, this.start()));
        }
        if (position > this.readLimit()) {
            throw new DecoratedBufferUnderflowException(String.format("readPosition failed. Position: %d > readLimit: %d", position, this.readLimit()));
        }
        this.readPosition = position;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> readLimit(long limit) throws BufferUnderflowException {
        if (limit < this.start()) {
            throw this.limitLessThanStart(limit);
        }
        if (limit > this.writeLimit()) {
            throw this.limitGreaterThanWriteLimit(limit);
        }
        this.uncheckedWritePosition(limit);
        return this;
    }

    private DecoratedBufferUnderflowException limitGreaterThanWriteLimit(long limit) {
        return new DecoratedBufferUnderflowException(String.format("readLimit failed. Limit: %d > writeLimit: %d", limit, this.writeLimit()));
    }

    private DecoratedBufferUnderflowException limitLessThanStart(long limit) {
        return new DecoratedBufferUnderflowException(String.format("readLimit failed. Limit: %d < start: %d", limit, this.start()));
    }

    @Override
    @NotNull
    public Bytes<Underlying> writePosition(long position) throws BufferOverflowException {
        if (position > this.writeLimit()) {
            throw this.writePositionTooLarge(position);
        }
        if (position < this.start()) {
            throw this.writePositionTooSmall(position);
        }
        if (position < this.readPosition()) {
            this.readPosition = position;
        }
        this.uncheckedWritePosition(position);
        return this;
    }

    @NotNull
    private DecoratedBufferOverflowException writePositionTooSmall(long position) {
        return new DecoratedBufferOverflowException(String.format("writePosition failed. Position: %d < start: %d", position, this.start()));
    }

    private DecoratedBufferOverflowException writePositionTooLarge(long position) {
        return new DecoratedBufferOverflowException(String.format("writePosition failed. Position: %d > writeLimit: %d", position, this.writeLimit()));
    }

    @Override
    @NotNull
    public Bytes<Underlying> readSkip(long bytesToSkip) throws BufferUnderflowException, IllegalStateException {
        if (this.lenient) {
            bytesToSkip = Math.min(bytesToSkip, this.readRemaining());
        }
        this.readOffsetPositionMoved(bytesToSkip);
        return this;
    }

    @Override
    public void uncheckedReadSkipOne() {
        ++this.readPosition;
    }

    @Override
    public void uncheckedReadSkipBackOne() {
        --this.readPosition;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeSkip(long bytesToSkip) throws BufferOverflowException, IllegalStateException {
        long writePosition = this.writePosition();
        this.writeCheckOffset(writePosition, bytesToSkip);
        this.uncheckedWritePosition(writePosition + bytesToSkip);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeLimit(long limit) throws BufferOverflowException {
        if (limit < this.start()) {
            throw this.writeLimitTooSmall(limit);
        }
        long capacity = this.capacity();
        if (limit > capacity) {
            throw this.writeLimitTooBig(limit, capacity);
        }
        this.writeLimit = limit;
        return this;
    }

    @NotNull
    private DecoratedBufferOverflowException writeLimitTooBig(long limit, long capacity) {
        return new DecoratedBufferOverflowException(String.format("writeLimit failed. Limit: %d > capacity: %d", limit, capacity));
    }

    @NotNull
    private DecoratedBufferOverflowException writeLimitTooSmall(long limit) {
        return new DecoratedBufferOverflowException(String.format("writeLimit failed. Limit: %d < start: %d", limit, this.start()));
    }

    @Override
    protected void performRelease() {
        try {
            this.bytesStore.release(this);
        }
        catch (IllegalStateException e) {
            Jvm.warn().on(this.getClass(), e);
        }
        finally {
            this.bytesStore(ReleasedBytesStore.releasedBytesStore());
        }
    }

    @Override
    public int readUnsignedByte() throws IllegalStateException {
        try {
            long offset = this.readOffsetPositionMoved(1L);
            return this.bytesStore.readUnsignedByte(offset);
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    @Override
    public int readUnsignedByte(long offset) throws BufferUnderflowException, IllegalStateException {
        return this.readByte(offset) & 0xFF;
    }

    @Override
    public int uncheckedReadUnsignedByte() {
        try {
            int unsignedByte = this.bytesStore.readUnsignedByte(this.readPosition);
            ++this.readPosition;
            return unsignedByte;
        }
        catch (IllegalStateException | BufferUnderflowException e) {
            return -1;
        }
    }

    @Override
    public byte readByte() throws IllegalStateException {
        try {
            long offset = this.readOffsetPositionMoved(1L);
            return this.bytesStore.readByte(offset);
        }
        catch (BufferUnderflowException e) {
            return 0;
        }
    }

    @Override
    public int peekUnsignedByte() throws IllegalStateException {
        try {
            return this.readPosition >= this.writePosition() ? -1 : this.bytesStore.readUnsignedByte(this.readPosition);
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    @Override
    public short readShort() throws BufferUnderflowException, IllegalStateException {
        try {
            long offset = this.readOffsetPositionMoved(2L);
            return this.bytesStore.readShort(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0;
            }
            throw e;
        }
    }

    @Override
    public int readInt() throws BufferUnderflowException, IllegalStateException {
        try {
            long offset = this.readOffsetPositionMoved(4L);
            return this.bytesStore.readInt(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0;
            }
            throw e;
        }
    }

    @Override
    public byte readVolatileByte(long offset) throws BufferUnderflowException, IllegalStateException {
        this.readCheckOffset(offset, 1L, true);
        return this.bytesStore.readVolatileByte(offset);
    }

    @Override
    public short readVolatileShort(long offset) throws BufferUnderflowException, IllegalStateException {
        this.readCheckOffset(offset, 2L, true);
        return this.bytesStore.readVolatileShort(offset);
    }

    @Override
    public int readVolatileInt(long offset) throws BufferUnderflowException, IllegalStateException {
        this.readCheckOffset(offset, 4L, true);
        return this.bytesStore.readVolatileInt(offset);
    }

    @Override
    public long readVolatileLong(long offset) throws BufferUnderflowException, IllegalStateException {
        this.readCheckOffset(offset, 8L, true);
        return this.bytesStore.readVolatileLong(offset);
    }

    @Override
    public long readLong() throws BufferUnderflowException, IllegalStateException {
        try {
            long offset = this.readOffsetPositionMoved(8L);
            return this.bytesStore.readLong(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0L;
            }
            throw e;
        }
    }

    @Override
    public float readFloat() throws BufferUnderflowException, IllegalStateException {
        try {
            long offset = this.readOffsetPositionMoved(4L);
            return this.bytesStore.readFloat(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0.0f;
            }
            throw e;
        }
    }

    @Override
    public double readDouble() throws BufferUnderflowException, IllegalStateException {
        try {
            long offset = this.readOffsetPositionMoved(8L);
            return this.bytesStore.readDouble(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0.0;
            }
            throw e;
        }
    }

    @Override
    public int readVolatileInt() throws BufferUnderflowException, IllegalStateException {
        try {
            long offset = this.readOffsetPositionMoved(4L);
            return this.bytesStore.readVolatileInt(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0;
            }
            throw e;
        }
    }

    @Override
    public long readVolatileLong() throws BufferUnderflowException, IllegalStateException {
        try {
            long offset = this.readOffsetPositionMoved(8L);
            return this.bytesStore.readVolatileLong(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0L;
            }
            throw e;
        }
    }

    protected long readOffsetPositionMoved(long adding) throws BufferUnderflowException, IllegalStateException {
        long offset = this.readPosition;
        this.readCheckOffset(this.readPosition, Math.toIntExact(adding), false);
        this.readPosition += adding;
        assert (this.readPosition <= this.readLimit());
        return offset;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeByte(long offset, byte i2) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 1L);
        this.bytesStore.writeByte(offset, i2);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeShort(long offset, short i2) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 2L);
        this.bytesStore.writeShort(offset, i2);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeInt(long offset, int i2) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeInt(offset, i2);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeOrderedInt(long offset, int i2) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeOrderedInt(offset, i2);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeLong(long offset, long i2) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeLong(offset, i2);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeOrderedLong(long offset, long i2) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeOrderedLong(offset, i2);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeFloat(long offset, float d) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeFloat(offset, d);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeDouble(long offset, double d) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeDouble(offset, d);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeVolatileByte(long offset, byte i8) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 1L);
        this.bytesStore.writeVolatileByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeVolatileShort(long offset, short i16) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 2L);
        this.bytesStore.writeVolatileShort(offset, i16);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeVolatileInt(long offset, int i32) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeVolatileInt(offset, i32);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeVolatileLong(long offset, long i64) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeVolatileLong(offset, i64);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(@NotNull RandomDataInput bytes) throws IllegalStateException, BufferOverflowException {
        assert (bytes != this) : "you should not write to yourself !";
        try {
            return (Bytes)this.write(bytes, bytes.readPosition(), Math.min(this.writeLimit() - this.writePosition(), bytes.readRemaining()));
        }
        catch (IllegalArgumentException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(long offsetInRDO, byte[] bytes, int offset, int length) throws BufferOverflowException, IllegalStateException {
        int copy;
        for (long remaining = (long)length; remaining > 0L; remaining -= (long)copy) {
            copy = (int)Math.min(remaining, (long)this.safeCopySize());
            this.writeCheckOffset(offsetInRDO, copy);
            this.bytesStore.write(offsetInRDO, bytes, offset, copy);
            offsetInRDO += (long)copy;
            offset += copy;
        }
        return this;
    }

    @Override
    public void write(long offsetInRDO, ByteBuffer bytes, int offset, int length) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(long writeOffset, RandomDataInput bytes, long readOffset, long length) throws BufferOverflowException, BufferUnderflowException, IllegalStateException {
        int copy;
        for (long remaining = length; remaining > 0L; remaining -= (long)copy) {
            copy = (int)Math.min(remaining, (long)this.safeCopySize());
            this.writeCheckOffset(writeOffset, copy);
            this.bytesStore.write(writeOffset, bytes, readOffset, (long)copy);
            writeOffset += (long)copy;
            readOffset += (long)copy;
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> write8bit(@NotNull String s, int start, int length) throws BufferOverflowException, IndexOutOfBoundsException, ArithmeticException, IllegalStateException, BufferUnderflowException {
        long toWriteLength = UnsafeMemory.INSTANCE.stopBitLength(length) + length;
        long position = this.writeOffsetPositionMoved(toWriteLength, 0L);
        this.bytesStore.write8bit(position, s, start, length);
        this.uncheckedWritePosition(this.writePosition() + toWriteLength);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> write8bit(@Nullable BytesStore bs) throws BufferOverflowException, IllegalStateException, BufferUnderflowException {
        if (bs == null) {
            BytesInternal.writeStopBitNeg1(this);
            return this;
        }
        long readRemaining = bs.readRemaining();
        long toWriteLength = (long)UnsafeMemory.INSTANCE.stopBitLength(readRemaining) + readRemaining;
        long position = this.writeOffsetPositionMoved(toWriteLength, 0L);
        this.bytesStore.write8bit(position, bs);
        this.uncheckedWritePosition(this.writePosition() + toWriteLength);
        return this;
    }

    @Override
    public long write8bit(long position, BytesStore bs) {
        return this.bytesStore.write8bit(position, bs);
    }

    @Override
    public long write8bit(long position, String s, int start, int length) {
        return this.bytesStore.write8bit(position, s, start, length);
    }

    void writeCheckOffset(long offset, long adding) throws BufferOverflowException, IllegalStateException {
        if (BYTES_BOUNDS_UNCHECKED) {
            return;
        }
        this.writeCheckOffset0(offset, adding);
    }

    private void writeCheckOffset0(long offset, long adding) throws DecoratedBufferOverflowException {
        if (offset < this.start() || offset + adding < this.start()) {
            throw this.newBOELower(offset);
        }
        if (offset + adding > this.writeLimit()) {
            throw this.newBOERange(offset, adding, "writeCheckOffset failed. Offset: %d + adding %d> writeLimit: %d", this.writeLimit());
        }
    }

    @NotNull
    private DecoratedBufferOverflowException newBOERange(long offset, long adding, String msg, long limit) {
        return new DecoratedBufferOverflowException(String.format(msg, offset, adding, limit));
    }

    @NotNull
    private DecoratedBufferOverflowException newBOELower(long offset) {
        return new DecoratedBufferOverflowException(String.format("writeCheckOffset failed. Offset: %d < start: %d", offset, this.start()));
    }

    @Override
    public byte readByte(long offset) throws BufferUnderflowException, IllegalStateException {
        this.readCheckOffset(offset, 1L, true);
        return this.bytesStore.readByte(offset);
    }

    @Override
    public int peekUnsignedByte(long offset) throws BufferUnderflowException, IllegalStateException {
        return offset >= this.readLimit() ? -1 : this.bytesStore.peekUnsignedByte(offset);
    }

    @Override
    public short readShort(long offset) throws BufferUnderflowException, IllegalStateException {
        this.readCheckOffset(offset, 2L, true);
        return this.bytesStore.readShort(offset);
    }

    @Override
    public int readInt(long offset) throws BufferUnderflowException, IllegalStateException {
        this.readCheckOffset(offset, 4L, true);
        return this.bytesStore.readInt(offset);
    }

    @Override
    public long readLong(long offset) throws BufferUnderflowException, IllegalStateException {
        this.readCheckOffset(offset, 8L, true);
        return this.bytesStore.readLong(offset);
    }

    @Override
    public float readFloat(long offset) throws BufferUnderflowException, IllegalStateException {
        this.readCheckOffset(offset, 4L, true);
        return this.bytesStore.readFloat(offset);
    }

    @Override
    public double readDouble(long offset) throws BufferUnderflowException, IllegalStateException {
        this.readCheckOffset(offset, 8L, true);
        return this.bytesStore.readDouble(offset);
    }

    void readCheckOffset(long offset, long adding, boolean given) throws BufferUnderflowException, IllegalStateException {
        if (BYTES_BOUNDS_UNCHECKED) {
            return;
        }
        this.readCheckOffset0(offset, adding, given);
    }

    private void readCheckOffset0(long offset, long adding, boolean given) throws DecoratedBufferUnderflowException {
        long limit0;
        if (offset < this.start()) {
            throw this.newBOEReadLower(offset);
        }
        long l = limit0 = given ? this.writeLimit() : this.readLimit();
        if (offset + adding > limit0) {
            throw this.newBOEReadUpper(offset, adding, given);
        }
    }

    @NotNull
    private DecoratedBufferUnderflowException newBOEReadUpper(long offset, long adding, boolean given) {
        long limit2 = given ? this.writeLimit() : this.readLimit();
        DecoratedBufferUnderflowException e = new DecoratedBufferUnderflowException(String.format("readCheckOffset0 failed. Offset: %d + adding: %d > limit: %d (given: %s)", offset, adding, limit2, given));
        return e;
    }

    @NotNull
    private DecoratedBufferUnderflowException newBOEReadLower(long offset) {
        return new DecoratedBufferUnderflowException(String.format("readCheckOffset0 failed. Offset: %d < start: %d", offset, this.start()));
    }

    void prewriteCheckOffset(long offset, long subtracting) throws BufferOverflowException, IllegalStateException {
        if (BYTES_BOUNDS_UNCHECKED) {
            return;
        }
        this.prewriteCheckOffset0(offset, subtracting);
    }

    private void prewriteCheckOffset0(long offset, long subtracting) throws BufferOverflowException {
        if (offset - subtracting < this.start()) {
            throw this.newBOERange(offset, subtracting, "prewriteCheckOffset0 failed. Offset: %d - subtracting: %d < start: %d", this.start());
        }
        long limit0 = this.readLimit();
        if (offset > limit0) {
            throw new DecoratedBufferOverflowException(String.format("prewriteCheckOffset0 failed. Offset: %d > readLimit: %d", offset, limit0));
        }
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeByte(byte i8) throws BufferOverflowException, IllegalStateException {
        long offset = this.writeOffsetPositionMoved(1L, 1L);
        this.bytesStore.writeByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> prewrite(@NotNull byte[] bytes) throws BufferOverflowException, IllegalStateException {
        long offset = this.prewriteOffsetPositionMoved(bytes.length);
        this.bytesStore.write(offset, bytes);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> prewrite(@NotNull BytesStore bytes) throws BufferOverflowException, IllegalStateException {
        long offset = this.prewriteOffsetPositionMoved(bytes.readRemaining());
        this.bytesStore.write(offset, bytes);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> prewriteByte(byte i8) throws BufferOverflowException, IllegalStateException {
        long offset = this.prewriteOffsetPositionMoved(1L);
        this.bytesStore.writeByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> prewriteInt(int i2) throws BufferOverflowException, IllegalStateException {
        long offset = this.prewriteOffsetPositionMoved(4L);
        this.bytesStore.writeInt(offset, i2);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> prewriteShort(short i2) throws BufferOverflowException, IllegalStateException {
        long offset = this.prewriteOffsetPositionMoved(2L);
        this.bytesStore.writeShort(offset, i2);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> prewriteLong(long l) throws BufferOverflowException, IllegalStateException {
        long offset = this.prewriteOffsetPositionMoved(8L);
        this.bytesStore.writeLong(offset, l);
        return this;
    }

    protected final long writeOffsetPositionMoved(long adding) throws BufferOverflowException, IllegalStateException {
        return this.writeOffsetPositionMoved(adding, adding);
    }

    protected long writeOffsetPositionMoved(long adding, long advance) throws BufferOverflowException, IllegalStateException {
        long oldPosition = this.writePosition();
        this.writeCheckOffset(oldPosition, adding);
        this.uncheckedWritePosition(this.writePosition() + advance);
        return oldPosition;
    }

    protected void uncheckedWritePosition(long writePosition) {
        this.writePosition = writePosition;
    }

    protected long prewriteOffsetPositionMoved(long subtracting) throws BufferOverflowException, IllegalStateException {
        this.prewriteCheckOffset(this.readPosition, subtracting);
        return this.readPosition -= subtracting;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeShort(short i16) throws BufferOverflowException, IllegalStateException {
        long offset = this.writeOffsetPositionMoved(2L);
        this.bytesStore.writeShort(offset, i16);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeInt(int i2) throws BufferOverflowException, IllegalStateException {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeInt(offset, i2);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeIntAdv(int i2, int advance) throws BufferOverflowException, IllegalStateException {
        long offset = this.writeOffsetPositionMoved(4L, advance);
        this.bytesStore.writeInt(offset, i2);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeLong(long i64) throws BufferOverflowException, IllegalStateException {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeLong(offset, i64);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeLongAdv(long i64, int advance) throws BufferOverflowException, IllegalStateException {
        long offset = this.writeOffsetPositionMoved(8L, advance);
        this.bytesStore.writeLong(offset, i64);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeFloat(float f) throws BufferOverflowException, IllegalStateException {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeFloat(offset, f);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeDouble(double d) throws BufferOverflowException, IllegalStateException {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeDouble(offset, d);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeDoubleAndInt(double d, int i2) throws BufferOverflowException, IllegalStateException {
        long offset = this.writeOffsetPositionMoved(12L);
        this.bytesStore.writeDouble(offset, d);
        this.bytesStore.writeInt(offset + 8L, i2);
        return this;
    }

    @Override
    public int read(@NotNull byte[] bytes, int off, int len) throws BufferUnderflowException, IllegalStateException {
        int totalToCopy;
        int currentBatchSize;
        long remaining = this.readRemaining();
        if (remaining <= 0L) {
            return -1;
        }
        int currentOffset = off;
        for (int remainingToCopy = totalToCopy = (int)Math.min((long)len, remaining); remainingToCopy > 0; remainingToCopy -= currentBatchSize) {
            currentBatchSize = Math.min(remainingToCopy, this.safeCopySize());
            long offsetInRDO = this.readOffsetPositionMoved(currentBatchSize);
            this.bytesStore.read(offsetInRDO, bytes, currentOffset, currentBatchSize);
            currentOffset += currentBatchSize;
        }
        return totalToCopy;
    }

    @Override
    public long read(long offsetInRDI, byte[] bytes, int offset, int length) throws IllegalStateException {
        return this.bytesStore.read(offsetInRDI, bytes, offset, length);
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(@NotNull byte[] bytes, int offset, int length) throws BufferOverflowException, IllegalStateException, IllegalArgumentException {
        int copy;
        if (length + offset > bytes.length) {
            throw new DecoratedBufferOverflowException("bytes.length=" + bytes.length + ", length=" + length + ", offset=" + offset);
        }
        if ((long)length > this.writeRemaining()) {
            throw new DecoratedBufferOverflowException(String.format("write failed. Length: %d > writeRemaining: %d", length, this.writeRemaining()));
        }
        this.ensureCapacity(this.writePosition() + (long)length);
        for (int remaining = length; remaining > 0; remaining -= copy) {
            copy = Math.min(remaining, this.safeCopySize());
            long offsetInRDO = this.writeOffsetPositionMoved(copy);
            this.bytesStore.write(offsetInRDO, bytes, offset, copy);
            offset += copy;
        }
        return this;
    }

    protected int safeCopySize() {
        return 65536;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeSome(@NotNull ByteBuffer buffer) throws BufferOverflowException, IllegalStateException, BufferUnderflowException {
        int length = (int)Math.min((long)buffer.remaining(), this.writeRemaining());
        try {
            this.ensureCapacity(this.writePosition() + (long)length);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        this.bytesStore.write(this.writePosition(), buffer, buffer.position(), length);
        this.uncheckedWritePosition(this.writePosition() + (long)length);
        buffer.position(buffer.position() + length);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeOrderedInt(int i2) throws BufferOverflowException, IllegalStateException {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeOrderedInt(offset, i2);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeOrderedLong(long i2) throws BufferOverflowException, IllegalStateException {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeOrderedLong(offset, i2);
        return this;
    }

    @Override
    public long addressForRead(long offset) throws BufferUnderflowException, IllegalStateException {
        return this.bytesStore.addressForRead(offset);
    }

    @Override
    public long addressForWrite(long offset) throws BufferOverflowException, IllegalStateException {
        return this.bytesStore.addressForWrite(offset);
    }

    @Override
    public long addressForWritePosition() throws BufferOverflowException, IllegalStateException {
        return this.bytesStore.addressForWrite(this.writePosition());
    }

    public int hashCode() {
        return BytesStoreHash.hash32(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BytesStore)) {
            return false;
        }
        @NotNull BytesStore bs = (BytesStore)obj;
        long remaining = this.readRemaining();
        try {
            return bs.readRemaining() == remaining && BytesInternal.contentEqual(this, bs);
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    @Override
    @NotNull
    public String toString() {
        try {
            return BytesInternal.toString(this);
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    @Override
    public void nativeRead(long position, long address, long size) throws BufferUnderflowException, IllegalStateException {
        this.bytesStore.nativeRead(position, address, size);
    }

    @Override
    public void nativeWrite(long address, long position, long size) throws BufferOverflowException, IllegalStateException {
        this.bytesStore.nativeWrite(address, position, size);
    }

    @Override
    @NotNull
    public BytesStore bytesStore() {
        return this.bytesStore;
    }

    protected void bytesStore(BytesStore<Bytes<Underlying>, Underlying> bytesStore) {
        this.bytesStore = bytesStore;
    }

    @Override
    public int lastDecimalPlaces() {
        return this.lastDecimalPlaces;
    }

    @Override
    public void lastDecimalPlaces(int lastDecimalPlaces) {
        this.lastDecimalPlaces = Math.max(0, lastDecimalPlaces);
    }

    @Override
    public boolean lastNumberHadDigits() {
        return this.lastNumberHadDigits;
    }

    @Override
    public void lastNumberHadDigits(boolean lastNumberHadDigits) {
        this.lastNumberHadDigits = lastNumberHadDigits;
    }

    @Override
    public BytesStore<Bytes<Underlying>, Underlying> copy() throws IllegalStateException {
        return null;
    }

    @Override
    public boolean isElastic() {
        return false;
    }

    @Override
    public void lenient(boolean lenient) {
        this.lenient = lenient;
    }

    @Override
    public boolean lenient() {
        return this.lenient;
    }

    @Override
    public int byteCheckSum() throws IORuntimeException, BufferUnderflowException, IllegalStateException {
        return this.byteCheckSum(this.readPosition(), this.readLimit());
    }

    @Override
    public int byteCheckSum(long start, long end) throws BufferUnderflowException, IllegalStateException {
        if (end < Integer.MAX_VALUE && this.isDirectMemory()) {
            return this.byteCheckSum((int)start, (int)end);
        }
        return Bytes.super.byteCheckSum(start, end);
    }

    public int byteCheckSum(int start, int end) throws BufferUnderflowException, IllegalStateException {
        int sum = 0;
        for (int i2 = start; i2 < end; ++i2) {
            sum += this.readByte(i2);
        }
        return sum & 0xFF;
    }

    static class ReportUnoptimised {
        ReportUnoptimised() {
        }

        static void reportOnce() {
        }

        static {
            Jvm.reportUnoptimised();
        }
    }
}

