/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomCommon;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RandomDataInput
extends RandomCommon {
    public static final String[] charToString = RandomDataInput.createCharToString();

    @NotNull
    public static String[] createCharToString() {
        int i2;
        @NotNull String[] charToString = new String[256];
        charToString[0] = "\u0660";
        for (i2 = 1; i2 < 21; ++i2) {
            charToString[i2] = Character.toString((char)(i2 + 9351));
        }
        for (i2 = 32; i2 < 256; ++i2) {
            charToString[i2] = Character.toString((char)i2);
        }
        for (i2 = 21; i2 < 32; ++i2) {
            charToString[i2] = "\\u00" + Integer.toHexString(i2).toUpperCase();
        }
        for (i2 = 128; i2 < 160; ++i2) {
            charToString[i2] = "\\u00" + Integer.toHexString(i2).toUpperCase();
        }
        return charToString;
    }

    default public int peekVolatileInt() throws BufferUnderflowException, IllegalStateException {
        return this.readVolatileInt(this.readPosition());
    }

    default public boolean readBoolean(long offset) throws BufferUnderflowException, IllegalStateException {
        return BytesUtil.byteToBoolean(this.readByte(offset));
    }

    public byte readByte(long var1) throws BufferUnderflowException, IllegalStateException;

    default public int readUnsignedByte(long offset) throws BufferUnderflowException, IllegalStateException {
        return this.readByte(offset) & 0xFF;
    }

    public int peekUnsignedByte(long var1) throws BufferUnderflowException, IllegalStateException;

    public short readShort(long var1) throws BufferUnderflowException, IllegalStateException;

    default public int readUnsignedShort(long offset) throws BufferUnderflowException, IllegalStateException {
        return this.readShort(offset) & 0xFFFF;
    }

    default public int readUnsignedInt24(long offset) throws BufferUnderflowException, IllegalStateException {
        return this.readUnsignedShort(offset) | this.readUnsignedByte(offset) << 16;
    }

    public int readInt(long var1) throws BufferUnderflowException, IllegalStateException;

    default public long readUnsignedInt(long offset) throws BufferUnderflowException, IllegalStateException {
        return (long)this.readInt(offset) & 0xFFFFFFFFL;
    }

    public long readLong(long var1) throws BufferUnderflowException, IllegalStateException;

    public float readFloat(long var1) throws BufferUnderflowException, IllegalStateException;

    public double readDouble(long var1) throws BufferUnderflowException, IllegalStateException;

    default public String printable(long offset) throws BufferUnderflowException, IllegalStateException {
        return charToString[this.readUnsignedByte(offset)];
    }

    public byte readVolatileByte(long var1) throws BufferUnderflowException, IllegalStateException;

    public short readVolatileShort(long var1) throws BufferUnderflowException, IllegalStateException;

    public int readVolatileInt(long var1) throws BufferUnderflowException, IllegalStateException;

    default public float readVolatileFloat(long offset) throws BufferUnderflowException, IllegalStateException {
        return Float.intBitsToFloat(this.readVolatileInt(offset));
    }

    public long readVolatileLong(long var1) throws BufferUnderflowException, IllegalStateException;

    default public double readVolatileDouble(long offset) throws BufferUnderflowException, IllegalStateException {
        return Double.longBitsToDouble(this.readVolatileLong(offset));
    }

    default public long parseLong(long offset) throws BufferUnderflowException, IllegalStateException {
        return BytesInternal.parseLong(this, offset);
    }

    public void nativeRead(long var1, long var3, long var5) throws BufferUnderflowException, IllegalStateException;

    default public int copyTo(@NotNull byte[] bytes) throws BufferUnderflowException, IllegalStateException {
        int len = (int)Math.min((long)bytes.length, this.readRemaining());
        for (int i2 = 0; i2 < len; ++i2) {
            bytes[i2] = this.readByte(this.start() + (long)i2);
        }
        return len;
    }

    default public int copyTo(@NotNull ByteBuffer bb) throws BufferUnderflowException, IllegalStateException {
        int i2;
        int pos = bb.position();
        int len = (int)Math.min((long)bb.remaining(), this.readRemaining());
        for (i2 = 0; i2 < len - 7; i2 += 8) {
            bb.putLong(pos + i2, this.readLong(this.start() + (long)i2));
        }
        while (i2 < len) {
            bb.put(pos + i2, this.readByte(this.start() + (long)i2));
            ++i2;
        }
        return len;
    }

    default public long readIncompleteLong(long offset) throws IllegalStateException {
        long l;
        long left = this.readLimit() - offset;
        try {
            if (left >= 8L) {
                return this.readLong(offset);
            }
            if (left == 4L) {
                return this.readInt(offset);
            }
            l = 0L;
            int remaining = (int)left;
            for (int i2 = 0; i2 < remaining; ++i2) {
                l |= (long)this.readUnsignedByte(offset + (long)i2) << i2 * 8;
            }
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
        return l;
    }

    @Override
    public long realCapacity();

    default public int addAndGetInt(long offset, int adding) throws BufferUnderflowException, IllegalStateException {
        return BytesInternal.addAndGetInt(this, offset, adding);
    }

    default public long addAndGetLong(long offset, long adding) throws BufferUnderflowException, IllegalStateException {
        return BytesInternal.addAndGetLong(this, offset, adding);
    }

    default public float addAndGetFloat(long offset, float adding) throws BufferUnderflowException, IllegalStateException {
        return BytesInternal.addAndGetFloat(this, offset, adding);
    }

    default public double addAndGetDouble(long offset, double adding) throws BufferUnderflowException, IllegalStateException {
        return BytesInternal.addAndGetDouble(this, offset, adding);
    }

    @NotNull
    default public BytesStore subBytes(long start, long length) throws BufferUnderflowException, IllegalStateException {
        return BytesInternal.subBytes(this, start, length);
    }

    default public long findByte(byte stopByte) throws IllegalStateException {
        return BytesInternal.findByte(this, stopByte);
    }

    default public <ACS extends Appendable & CharSequence> long readUtf8(long offset, @NotNull ACS sb) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException, ArithmeticException, IllegalStateException {
        AppendableUtil.setLength(sb, 0);
        long utfLen = this.readByte(offset++);
        if (utfLen < 0L) {
            long b;
            utfLen &= 0x7FL;
            int count = 7;
            while ((b = (long)this.readByte(offset++)) < 0L) {
                utfLen |= (b & 0x7FL) << count;
                count += 7;
            }
            if (b != 0L) {
                if (count > 56) {
                    throw new IORuntimeException("Cannot read more than 9 stop bits of positive value");
                }
                utfLen |= b << count;
            } else {
                if (count > 63) {
                    throw new IORuntimeException("Cannot read more than 10 stop bits of negative value");
                }
                utfLen ^= 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (utfLen == -1L) {
            return offset ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int len = Maths.toUInt31(utfLen);
        BytesInternal.parseUtf8(this, offset, sb, true, len);
        return offset + utfLen;
    }

    default public <ACS extends Appendable & CharSequence> long readUtf8Limited(long offset, @NotNull ACS sb, int maxUtf8Len) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException, IllegalStateException {
        AppendableUtil.setLength(sb, 0);
        long utfLen = this.readByte(offset++);
        if (utfLen < 0L) {
            long b;
            utfLen &= 0x7FL;
            int count = 7;
            while ((b = (long)this.readByte(offset++)) < 0L) {
                utfLen |= (b & 0x7FL) << count;
                count += 7;
            }
            if (b != 0L) {
                if (count > 56) {
                    throw new IORuntimeException("Cannot read more than 9 stop bits of positive value");
                }
                utfLen |= b << count;
            } else {
                if (count > 63) {
                    throw new IORuntimeException("Cannot read more than 10 stop bits of negative value");
                }
                utfLen ^= 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (utfLen == -1L) {
            return offset ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (utfLen > (long)maxUtf8Len) {
            throw new IllegalStateException("Attempted to read a char sequence of utf8 size " + utfLen + ", when only " + maxUtf8Len + " allowed");
        }
        BytesInternal.parseUtf8(this, offset, sb, true, (int)utfLen);
        return offset + utfLen;
    }

    @Nullable
    default public String readUtf8Limited(long offset, int maxUtf8Len) throws BufferUnderflowException, IORuntimeException, IllegalArgumentException, IllegalStateException {
        return BytesInternal.readUtf8(this, offset, maxUtf8Len);
    }

    default public boolean compareUtf8(long offset, @Nullable CharSequence other) throws IORuntimeException, BufferUnderflowException, IllegalStateException {
        return BytesInternal.compareUtf8(this, offset, other);
    }

    @NotNull
    default public byte[] toByteArray() throws IllegalStateException {
        return BytesInternal.toByteArray(this);
    }

    default public long read(long offsetInRDI, byte[] bytes, int offset, int length) throws IllegalStateException {
        try {
            int len = (int)Math.min((long)length, this.readLimit() - offsetInRDI);
            for (int i2 = 0; i2 < len; ++i2) {
                bytes[offset + i2] = this.readByte(offsetInRDI + (long)i2);
            }
            return len;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public ByteBuffer toTemporaryDirectByteBuffer() throws IllegalArgumentException, ArithmeticException, IllegalStateException {
        int len = Maths.toUInt31(this.readRemaining());
        try {
            ByteBuffer bb = ByteBuffer.allocateDirect(len);
            this.copyTo(bb);
            bb.clear();
            return bb;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public int fastHash(long offset, int length) throws BufferUnderflowException, IllegalStateException {
        long hash = 0L;
        int i2 = 0;
        if (length >= 4) {
            hash = this.readInt(offset + (long)i2);
            i2 += 4;
        }
        while (i2 < length - 3) {
            hash *= 1829709757L;
            hash += (long)this.readInt(offset + (long)i2);
            i2 += 4;
        }
        if (i2 < length - 1) {
            hash *= 1829709757L;
            hash += (long)this.readShort(offset + (long)i2);
            i2 += 2;
        }
        if (i2 < length) {
            hash += (long)this.readByte(offset + (long)i2);
        }
        return (int)((hash *= -2057448229L) ^ hash >> 32);
    }

    default public boolean canReadDirect(long length) {
        return this.isDirectMemory() && this.readRemaining() >= length;
    }
}

