/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.openhft.chronicle.bytes.FieldGroup;
import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.UnsafeMemory;

public class BytesFieldInfo {
    private static final ClassLocal<BytesFieldInfo> CACHE = ClassLocal.withInitial(BytesFieldInfo::init);
    static final Field $END$;
    private final Map<String, BFIEntry> groups = new LinkedHashMap<String, BFIEntry>();
    private final Class<?> aClass;
    private final int description;

    BytesFieldInfo(Class<?> aClass) {
        this.aClass = aClass;
        List<Field> fields = BytesFieldInfo.fields(aClass);
        String prefix0 = "";
        BFIEntry entry = null;
        int longs = 0;
        int ints = 0;
        int shorts = 0;
        int bytes = 0;
        boolean nonHeader = false;
        boolean hasHeader = false;
        for (int i2 = 0; i2 <= fields.size(); ++i2) {
            Field field = i2 == fields.size() ? $END$ : fields.get(i2);
            boolean matches = false;
            String prefix = "";
            long position = 0L;
            int size = 0;
            if (field.getType().isPrimitive()) {
                FieldGroup fieldGroup = field.getAnnotation(FieldGroup.class);
                if (fieldGroup != null) {
                    prefix = fieldGroup.value();
                    if (prefix.equals("header")) {
                        hasHeader = true;
                        if (!nonHeader) continue;
                        throw new IllegalStateException("The header FieldGroup must be at the start");
                    }
                    nonHeader = true;
                    position = UnsafeMemory.MEMORY.getFieldOffset(field);
                    matches = prefix.equals(prefix0);
                }
                size = BytesFieldInfo.sizeOf(field.getType());
                switch (size) {
                    case 1: {
                        ++bytes;
                        break;
                    }
                    case 2: {
                        assert (!hasHeader || bytes == 0);
                        ++shorts;
                        break;
                    }
                    case 4: {
                        assert (!hasHeader || shorts == 0 && bytes == 0);
                        ++ints;
                        break;
                    }
                    case 8: {
                        assert (!hasHeader || ints == 0 && shorts == 0 && bytes == 0);
                        ++longs;
                    }
                }
            }
            if (matches) {
                entry.end = position + (long)size;
                continue;
            }
            if (prefix.isEmpty()) continue;
            if (this.groups.containsKey(prefix)) {
                Jvm.warn().on(aClass, "Disjoined fields starting with " + prefix);
                prefix0 = "";
                continue;
            }
            entry = new BFIEntry();
            entry.start = position;
            entry.end = position + (long)size;
            this.groups.put(prefix, entry);
            prefix0 = prefix;
        }
        assert (longs < 256);
        assert (ints < 256);
        assert (shorts < 128);
        assert (bytes < 256);
        int description = longs << 24 | ints << 16 | shorts << 8 | bytes;
        if (Integer.bitCount(description) % 2 == 0) {
            description |= 0x8000;
        }
        this.description = description;
    }

    private static int sizeOf(Class<?> type) {
        return Memory.sizeOf(type);
    }

    public int description() {
        return this.description;
    }

    private static BytesFieldInfo init(Class<?> aClass) {
        return new BytesFieldInfo(aClass);
    }

    public static BytesFieldInfo lookup(Class<?> aClass) {
        return (BytesFieldInfo)CACHE.get(aClass);
    }

    public Set<String> groups() {
        return this.groups.keySet();
    }

    public long startOf(String groupName) {
        BFIEntry bfiEntry = this.groups.get(groupName);
        if (bfiEntry == null) {
            throw new IllegalArgumentException("No groupName " + groupName + " found in " + this.aClass);
        }
        return bfiEntry.start;
    }

    public long lengthOf(String groupName) {
        BFIEntry bfiEntry = this.groups.get(groupName);
        if (bfiEntry == null) {
            throw new IllegalArgumentException("No groupName " + groupName + " found in " + this.aClass);
        }
        return bfiEntry.end - bfiEntry.start;
    }

    public String dump() {
        StringBuilder sb = new StringBuilder().append("type: ").append(this.getClass().getSimpleName()).append(", groups: { ");
        sb.append(this.groups.entrySet().stream().map(e -> (String)e.getKey() + ": " + ((BFIEntry)e.getValue()).start + " to " + ((BFIEntry)e.getValue()).end).collect(Collectors.joining(", ")));
        return sb.append(" }").toString();
    }

    public static List<Field> fields(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null && clazz != Object.class) {
            Collections.addAll(fields, clazz.getDeclaredFields());
            clazz = clazz.getSuperclass();
        }
        fields.removeIf(field -> Modifier.isStatic(field.getModifiers()));
        fields.sort(Comparator.comparingLong(UnsafeMemory.MEMORY::objectFieldOffset));
        return fields;
    }

    static {
        try {
            $END$ = BytesFieldInfo.class.getDeclaredField("$END$");
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    static class BFIEntry {
        long start;
        long end;

        BFIEntry() {
        }
    }
}

