/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.internal.AbstractBytesStore;
import net.openhft.chronicle.bytes.internal.BytesFieldInfo;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.UnsafeMemory;
import org.jetbrains.annotations.NotNull;

public class HeapBytesStore<Underlying>
extends AbstractBytesStore<HeapBytesStore<Underlying>, Underlying> {
    @NotNull
    private final Object realUnderlyingObject;
    private final int dataOffset;
    private final long capacity;
    @NotNull
    private final Underlying underlyingObject;

    private HeapBytesStore(@NotNull ByteBuffer byteBuffer) {
        super(false);
        this.underlyingObject = byteBuffer;
        this.realUnderlyingObject = byteBuffer.array();
        this.dataOffset = Jvm.arrayByteBaseOffset() + byteBuffer.arrayOffset();
        this.capacity = byteBuffer.capacity();
    }

    private HeapBytesStore(@NotNull @NotNull byte @NotNull [] byteArray) {
        super(false);
        this.underlyingObject = (Underlying)byteArray;
        this.realUnderlyingObject = byteArray;
        this.dataOffset = Jvm.arrayByteBaseOffset();
        this.capacity = byteArray.length;
    }

    private HeapBytesStore(Object object, long start, long length) {
        super(false);
        this.underlyingObject = object;
        this.realUnderlyingObject = object;
        this.dataOffset = Math.toIntExact(start);
        this.capacity = length;
    }

    public static <T> HeapBytesStore<T> forFields(Object o, String groupName, int padding) {
        BytesFieldInfo lookup = BytesFieldInfo.lookup(o.getClass());
        long start = lookup.startOf(groupName);
        long length = lookup.lengthOf(groupName);
        return new HeapBytesStore(o, start + (long)padding, length - (long)padding);
    }

    @NotNull
    public static HeapBytesStore<byte[]> wrap(@NotNull byte[] byteArray) {
        return new HeapBytesStore<byte[]>(byteArray);
    }

    @NotNull
    public static HeapBytesStore<ByteBuffer> wrap(@NotNull ByteBuffer bb) {
        return new HeapBytesStore<ByteBuffer>(bb);
    }

    @Override
    public boolean isDirectMemory() {
        return false;
    }

    @Override
    public void move(long from, long to, long length) throws BufferUnderflowException, ArithmeticException {
        if (from < 0L || to < 0L) {
            throw new BufferUnderflowException();
        }
        UnsafeMemory.MEMORY.copyMemory(this.realUnderlyingObject, (long)this.dataOffset + from, this.realUnderlyingObject, (long)this.dataOffset + to, Maths.toUInt31(length));
    }

    @Override
    @NotNull
    public String toString() {
        return BytesInternal.toString(this);
    }

    @Override
    @NotNull
    public BytesStore<HeapBytesStore<Underlying>, Underlying> copy() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    protected void performRelease() {
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    @NotNull
    public Underlying underlyingObject() {
        return this.underlyingObject;
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int value) {
        return UnsafeMemory.MEMORY.compareAndSwapInt(this.realUnderlyingObject, (long)this.dataOffset + offset, expected, value);
    }

    @Override
    public void testAndSetInt(long offset, int expected, int value) throws IllegalStateException {
        UnsafeMemory.MEMORY.testAndSetInt(this.realUnderlyingObject, (long)this.dataOffset + offset, expected, value);
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long value) {
        return UnsafeMemory.MEMORY.compareAndSwapLong(this.realUnderlyingObject, (long)this.dataOffset + offset, expected, value);
    }

    @Override
    public byte readByte(long offset) throws BufferUnderflowException {
        return UnsafeMemory.MEMORY.readByte(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public short readShort(long offset) throws BufferUnderflowException {
        return UnsafeMemory.MEMORY.readShort(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public int readInt(long offset) throws BufferUnderflowException {
        return UnsafeMemory.MEMORY.readInt(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public long readLong(long offset) throws BufferUnderflowException {
        return UnsafeMemory.MEMORY.readLong(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public float readFloat(long offset) throws BufferUnderflowException {
        return UnsafeMemory.MEMORY.readFloat(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public double readDouble(long offset) throws BufferUnderflowException {
        return UnsafeMemory.MEMORY.readDouble(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public byte readVolatileByte(long offset) throws BufferUnderflowException {
        return UnsafeMemory.MEMORY.readVolatileByte(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public short readVolatileShort(long offset) throws BufferUnderflowException {
        return UnsafeMemory.MEMORY.readVolatileShort(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public int readVolatileInt(long offset) throws BufferUnderflowException {
        return UnsafeMemory.MEMORY.readVolatileInt(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public long readVolatileLong(long offset) throws BufferUnderflowException {
        return UnsafeMemory.MEMORY.readVolatileLong(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public long write8bit(long position, BytesStore bs) {
        int i2;
        int length0 = Math.toIntExact(bs.readRemaining());
        position = BytesUtil.writeStopBit(this, position, length0);
        for (i2 = 0; i2 < length0 - 7; i2 += 8) {
            this.writeLong(position + (long)i2, bs.readLong(i2));
        }
        while (i2 < length0) {
            this.writeByte(position + (long)i2, bs.readByte(i2));
            ++i2;
        }
        return position + (long)length0;
    }

    @Override
    public long write8bit(long position, String s, int start, int length) {
        position = BytesInternal.writeStopBit(this, position, length);
        UnsafeMemory.MEMORY.write8bit(s, start, this.realUnderlyingObject, (long)this.dataOffset + position, length);
        return position + (long)length;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeByte(long offset, byte b) throws BufferOverflowException {
        UnsafeMemory.MEMORY.writeByte(this.realUnderlyingObject, (long)this.dataOffset + offset, b);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeShort(long offset, short i16) throws BufferOverflowException {
        UnsafeMemory.MEMORY.writeShort(this.realUnderlyingObject, (long)this.dataOffset + offset, i16);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeInt(long offset, int i32) throws BufferOverflowException {
        UnsafeMemory.MEMORY.writeInt(this.realUnderlyingObject, (long)this.dataOffset + offset, i32);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeOrderedInt(long offset, int i32) throws BufferOverflowException {
        UnsafeMemory.MEMORY.writeOrderedInt(this.realUnderlyingObject, (long)this.dataOffset + offset, i32);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeLong(long offset, long i64) throws BufferOverflowException {
        UnsafeMemory.MEMORY.writeLong(this.realUnderlyingObject, (long)this.dataOffset + offset, i64);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeOrderedLong(long offset, long i2) throws BufferOverflowException {
        UnsafeMemory.MEMORY.writeOrderedLong(this.realUnderlyingObject, (long)this.dataOffset + offset, i2);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeFloat(long offset, float f) throws BufferOverflowException {
        UnsafeMemory.MEMORY.writeFloat(this.realUnderlyingObject, (long)this.dataOffset + offset, f);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeDouble(long offset, double d) throws BufferOverflowException {
        UnsafeMemory.MEMORY.writeDouble(this.realUnderlyingObject, (long)this.dataOffset + offset, d);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeVolatileByte(long offset, byte i8) throws BufferOverflowException {
        UnsafeMemory.MEMORY.writeVolatileByte(this.realUnderlyingObject, (long)this.dataOffset + offset, i8);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeVolatileShort(long offset, short i16) throws BufferOverflowException {
        UnsafeMemory.MEMORY.writeVolatileShort(this.realUnderlyingObject, (long)this.dataOffset + offset, i16);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeVolatileInt(long offset, int i32) throws BufferOverflowException {
        UnsafeMemory.MEMORY.writeVolatileInt(this.realUnderlyingObject, (long)this.dataOffset + offset, i32);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeVolatileLong(long offset, long i64) throws BufferOverflowException {
        UnsafeMemory.MEMORY.writeVolatileLong(this.realUnderlyingObject, (long)this.dataOffset + offset, i64);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> write(long offsetInRDO, byte[] bytes, int offset, int length) throws BufferOverflowException {
        UnsafeMemory.MEMORY.copyMemory(bytes, offset, this.realUnderlyingObject, (long)this.dataOffset + offsetInRDO, length);
        return this;
    }

    @Override
    public void write(long offsetInRDO, @NotNull ByteBuffer bytes, int offset, int length) throws BufferOverflowException {
        assert (this.realUnderlyingObject == null || this.dataOffset >= (Jvm.is64bit() ? 12 : 8));
        if (bytes.isDirect()) {
            UnsafeMemory.MEMORY.copyMemory(Jvm.address(bytes), this.realUnderlyingObject, (long)this.dataOffset + offsetInRDO, length);
        } else {
            UnsafeMemory.MEMORY.copyMemory(bytes.array(), offset, this.realUnderlyingObject, (long)this.dataOffset + offsetInRDO, length);
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> write(long writeOffset, @NotNull RandomDataInput bytes, long readOffset, long length) throws IllegalStateException, BufferUnderflowException, BufferOverflowException {
        if (length == (long)((int)length)) {
            int i2;
            int length0 = (int)length;
            for (i2 = 0; i2 < length0 - 7; i2 += 8) {
                long x = bytes.readLong(readOffset + (long)i2);
                this.writeLong(writeOffset + (long)i2, x);
            }
            while (i2 < length0) {
                byte x = bytes.readByte(readOffset + (long)i2);
                this.writeByte(writeOffset + (long)i2, x);
                ++i2;
            }
        } else {
            this.writeLongLength(writeOffset, bytes, readOffset, length);
        }
        return this;
    }

    private void writeLongLength(long writeOffset, @NotNull RandomDataInput bytes, long readOffset, long length) throws IllegalStateException, BufferUnderflowException, BufferOverflowException {
        long i2;
        for (i2 = 0L; i2 < length - 7L; i2 += 8L) {
            long x = bytes.readLong(readOffset + i2);
            this.writeLong(writeOffset + i2, x);
        }
        while (i2 < length) {
            byte x = bytes.readByte(readOffset + i2);
            this.writeByte(writeOffset + i2, x);
            ++i2;
        }
    }

    @Override
    public long addressForRead(long offset) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long addressForWrite(long offset) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long addressForWritePosition() throws UnsupportedOperationException, BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void nativeRead(long position, long address, long size) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void nativeWrite(long address, long position, long size) {
        throw new UnsupportedOperationException("todo");
    }

    public boolean equals(Object obj) {
        try {
            return obj instanceof BytesStore && BytesInternal.contentEqual(this, (BytesStore)obj);
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    @Override
    public boolean sharedMemory() {
        return false;
    }
}

