/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.util.Arrays;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class Maths {
    private static final double WHOLE_NUMBER = 4.503599627370496E15;
    private static final int K0 = 1829709757;
    private static final int M0 = 1539836845;
    private static final int M1 = -361396777;
    private static final int M2 = 2053402137;
    private static final int M3 = -2057448229;
    private static final long[] TENS;
    private static final long[] FIVES;
    private static final String OUT_OF_RANGE = " out of range";

    private Maths() {
    }

    public static double roundN(double d, int digits) {
        long factor = Maths.roundingFactor(digits);
        return Math.abs(d) < 4.503599627370496E15 / (double)factor ? (double)((long)(d < 0.0 ? d * (double)factor - 0.5 : d * (double)factor + 0.5)) / (double)factor : d;
    }

    public static double roundNup(double d, int digits) {
        if (d < 0.0) {
            return -Maths.roundNup(-d, digits);
        }
        long factor = Maths.roundingFactor(digits);
        if (d >= 4.503599627370496E15 / (double)factor) {
            return d;
        }
        double df = d * (double)factor;
        long ldf = (long)df;
        double residual = df - (double)ldf + Math.ulp(d) * ((double)factor * 0.983);
        if (residual >= 0.5) {
            ++ldf;
        }
        double v = (double)ldf / (double)factor;
        return v;
    }

    public static long roundingFactor(int digits) {
        return TENS[digits];
    }

    public static long roundingFactor(double digits) {
        int iDigits = (int)digits;
        long ten = TENS[iDigits];
        switch ((int)((digits - (double)iDigits) * 10.0 + 0.5)) {
            case 0: 
            case 1: 
            case 2: {
                return ten;
            }
            case 3: 
            case 4: 
            case 5: {
                return 2L * ten;
            }
            case 6: {
                return 4L * ten;
            }
            case 7: 
            case 8: {
                return 5L * ten;
            }
            case 9: {
                return 8L * ten;
            }
        }
        return 10L * ten;
    }

    public static double ceilN(double d, int digits) {
        long factor = Maths.roundingFactor(digits);
        double ulp = Math.ulp(d);
        double ulp2 = ulp * (double)factor;
        return Math.abs(d) < 9.223372036854776E18 / (double)factor && ulp2 < 1.0 ? Math.ceil((d - ulp) * (double)factor) / (double)factor : d;
    }

    public static double floorN(double d, int digits) {
        long factor = Maths.roundingFactor(digits);
        double ulp = Math.ulp(d);
        double ulp2 = ulp * (double)factor;
        return Math.abs(d) < 9.223372036854776E18 / (double)factor && ulp2 < 1.0 ? Math.floor((d + ulp) * (double)factor) / (double)factor : d;
    }

    public static double roundN(double d, double digits) {
        long factor = Maths.roundingFactor(digits);
        return Math.abs(d) < 9.223372036854776E18 / (double)factor ? (double)((long)(d < 0.0 ? d * (double)factor - 0.5 : d * (double)factor + 0.5)) / (double)factor : d;
    }

    public static double ceilN(double d, double digits) {
        long factor = Maths.roundingFactor(digits + 8.0);
        long factor2 = Maths.roundingFactor(digits);
        return Math.abs(d) < 4.503599627370496E15 / (double)factor ? Math.ceil((double)Math.round(d * (double)factor) / 1.0E8) / (double)factor2 : d;
    }

    public static double floorN(double d, double digits) {
        long factor = Maths.roundingFactor(digits + 8.0);
        long factor2 = Maths.roundingFactor(digits);
        return Math.abs(d) < 4.503599627370496E15 / (double)factor ? Math.floor((double)Math.round(d * (double)factor) / 1.0E8) / (double)factor2 : d;
    }

    public static double round1(double d) {
        if (d < 0.0) {
            return -Maths.round1(-d);
        }
        double factor = 10.0;
        if (!(d <= 4.503599627370496E14)) {
            return d;
        }
        return (double)((long)(d * 10.0 + 0.5)) / 10.0;
    }

    public static double round1up(double d) {
        return Maths.round1(d);
    }

    public static double round2(double d) {
        double factor = 100.0;
        return Math.abs(d) < 4.503599627370496E13 ? (double)((long)(d < 0.0 ? d * 100.0 - 0.5 : d * 100.0 + 0.5)) / 100.0 : d;
    }

    public static double round2up(double d) {
        if (d < 0.0) {
            return -Maths.round2(-d);
        }
        double factor = 100.0;
        if (!(d <= 4.503599627370496E13)) {
            return d;
        }
        double df = d * 100.0;
        long ldf = (long)df;
        double residual = df - (double)ldf + Math.ulp(d) * 98.3;
        if (residual >= 0.5) {
            ++ldf;
        }
        double v = (double)ldf / 100.0;
        return v;
    }

    public static double round3(double d) {
        double factor = 1000.0;
        return Math.abs(d) < 4.503599627370496E12 ? (double)((long)(d < 0.0 ? d * 1000.0 - 0.5 : d * 1000.0 + 0.5)) / 1000.0 : d;
    }

    public static double round3up(double d) {
        if (d < 0.0) {
            return -Maths.round3(-d);
        }
        double factor = 1000.0;
        if (!(d <= 4.503599627370496E12)) {
            return d;
        }
        double df = d * 1000.0;
        long ldf = (long)df;
        double residual = df - (double)ldf + Math.ulp(d) * 983.0;
        if (residual >= 0.5) {
            ++ldf;
        }
        double v = (double)ldf / 1000.0;
        return v;
    }

    public static double round4(double d) {
        double factor = 10000.0;
        return Math.abs(d) < 4.503599627370496E11 ? (double)((long)(d < 0.0 ? d * 10000.0 - 0.5 : d * 10000.0 + 0.5)) / 10000.0 : d;
    }

    public static double round4up(double d) {
        if (d < 0.0) {
            return -Maths.round4(-d);
        }
        double factor = 10000.0;
        if (!(d <= 4.503599627370496E11)) {
            return d;
        }
        double df = d * 10000.0;
        long ldf = (long)df;
        double residual = df - (double)ldf + Math.ulp(d) * 9830.0;
        if (residual >= 0.5) {
            ++ldf;
        }
        double v = (double)ldf / 10000.0;
        return v;
    }

    public static double round5(double d) {
        double factor = 100000.0;
        return Math.abs(d) < 4.503599627370496E10 ? (double)((long)(d < 0.0 ? d * 100000.0 - 0.5 : d * 100000.0 + 0.5)) / 100000.0 : d;
    }

    public static double round5up(double d) {
        if (d < 0.0) {
            return -Maths.round5(-d);
        }
        double factor = 100000.0;
        if (!(d <= 4.503599627370496E10)) {
            return d;
        }
        double df = d * 100000.0;
        long ldf = (long)df;
        double residual = df - (double)ldf + Math.ulp(d) * 98300.0;
        if (residual >= 0.5) {
            ++ldf;
        }
        double v = (double)ldf / 100000.0;
        return v;
    }

    public static double round6(double d) {
        double factor = 1000000.0;
        return Math.abs(d) < 4.503599627370496E9 ? (double)((long)(d < 0.0 ? d * 1000000.0 - 0.5 : d * 1000000.0 + 0.5)) / 1000000.0 : d;
    }

    public static double round6up(double d) {
        if (d < 0.0) {
            return -Maths.round6(-d);
        }
        double factor = 1000000.0;
        if (!(d <= 4.503599627370496E9)) {
            return d;
        }
        double df = d * 1000000.0;
        long ldf = (long)df;
        double residual = df - (double)ldf + Math.ulp(d) * 983000.0;
        if (residual >= 0.5) {
            ++ldf;
        }
        double v = (double)ldf / 1000000.0;
        return v;
    }

    public static double round7(double d) {
        double factor = 1.0E7;
        return Math.abs(d) < 4.503599627370496E8 ? (double)((long)(d < 0.0 ? d * 1.0E7 - 0.5 : d * 1.0E7 + 0.5)) / 1.0E7 : d;
    }

    public static double round7up(double d) {
        if (d < 0.0) {
            return -Maths.round7(-d);
        }
        double factor = 1.0E7;
        if (!(d <= 4.503599627370496E8)) {
            return d;
        }
        double df = d * 1.0E7;
        long ldf = (long)df;
        double residual = df - (double)ldf + Math.ulp(d) * 9830000.0;
        if (residual >= 0.5) {
            ++ldf;
        }
        double v = (double)ldf / 1.0E7;
        return v;
    }

    public static double round8(double d) {
        double factor = 1.0E8;
        return Math.abs(d) < 4.503599627370496E7 ? (double)((long)(d < 0.0 ? d * 1.0E8 - 0.5 : d * 1.0E8 + 0.5)) / 1.0E8 : d;
    }

    public static double round8up(double d) {
        if (d < 0.0) {
            return -Maths.round8(-d);
        }
        double factor = 1.0E8;
        if (!(d <= 4.503599627370496E7)) {
            return d;
        }
        double df = d * 1.0E8;
        long ldf = (long)df;
        double residual = df - (double)ldf + Math.ulp(d) * 9.83E7;
        if (residual >= 0.5) {
            ++ldf;
        }
        double v = (double)ldf / 1.0E8;
        return v;
    }

    public static int nextPower2(int n, int min) throws IllegalArgumentException {
        return (int)Math.min(0x40000000L, Maths.nextPower2((long)n, (long)min));
    }

    public static long nextPower2(long n, long min) throws IllegalArgumentException {
        if (!Maths.isPowerOf2(min)) {
            throw new IllegalArgumentException(min + " must be a power of 2");
        }
        if (n < min) {
            return min;
        }
        if (Maths.isPowerOf2(n)) {
            return n;
        }
        long i2 = min;
        while (i2 < n) {
            if ((i2 *= 2L) > 0L) continue;
            return 0x4000000000000000L;
        }
        return i2;
    }

    public static boolean isPowerOf2(long n) {
        return Long.bitCount(n) == 1;
    }

    public static int hash32(@NotNull CharSequence cs) {
        long h = Maths.hash64(cs);
        h ^= h >> 32;
        return (int)h;
    }

    public static int hash32(@NotNull String s) {
        long h = Maths.hash64(s);
        h ^= h >> 32;
        return (int)h;
    }

    public static int hash32(@NotNull StringBuilder s) {
        long h = Maths.hash64(s);
        h ^= h >> 32;
        return (int)h;
    }

    public static int hash32(long l0) {
        long h = Maths.hash64(l0);
        h ^= h >> 32;
        return (int)h;
    }

    public static long hash64(@NotNull CharSequence cs) {
        if (cs instanceof String) {
            return Maths.hash64((String)cs);
        }
        try {
            long hash = 0L;
            int len = cs.length();
            for (int i2 = 0; i2 < len; ++i2) {
                hash = hash * 841248317L + (long)cs.charAt(i2);
            }
            return Maths.agitate(hash);
        }
        catch (IndexOutOfBoundsException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static long hash64(@NotNull String s) {
        long hash = 0L;
        if (Jvm.isJava9Plus()) {
            byte[] bytes = StringUtils.extractBytes(s);
            int len = s.length();
            for (int i2 = 0; i2 < len; ++i2) {
                hash = hash * 841248317L + (long)bytes[i2];
            }
        } else {
            char[] chars = StringUtils.extractChars(s);
            int len = s.length();
            for (int i3 = 0; i3 < len; ++i3) {
                hash = hash * 841248317L + (long)chars[i3];
            }
        }
        return Maths.agitate(hash);
    }

    public static long hash64(@NotNull StringBuilder s) {
        long hash = 0L;
        if (Jvm.isJava9Plus()) {
            byte[] bytes = StringUtils.extractBytes(s);
            int len = s.length();
            for (int i2 = 0; i2 < len; ++i2) {
                hash = hash * 841248317L + (long)bytes[i2];
            }
        } else {
            char[] chars = StringUtils.extractChars(s);
            int len = s.length();
            for (int i3 = 0; i3 < len; ++i3) {
                hash = hash * 841248317L + (long)chars[i3];
            }
        }
        return Maths.agitate(hash);
    }

    public static int intLog2(long num) throws IllegalArgumentException {
        if (num <= 0L) {
            throw new IllegalArgumentException("positive argument expected, " + num + " given");
        }
        return 63 - Long.numberOfLeadingZeros(num);
    }

    public static byte toInt8(long value) throws ArithmeticException {
        if ((long)((byte)value) == value) {
            return (byte)value;
        }
        throw new ArithmeticException("Byte " + value + OUT_OF_RANGE);
    }

    public static short toInt16(long value) throws ArithmeticException {
        if ((long)((short)value) == value) {
            return (short)value;
        }
        throw new ArithmeticException("Short " + value + OUT_OF_RANGE);
    }

    public static int toInt32(long value, @NotNull String msg) throws ArithmeticException {
        if ((long)((int)value) == value) {
            return (int)value;
        }
        throw new ArithmeticException(String.format(msg, value));
    }

    public static int toInt32(long value) throws ArithmeticException {
        if ((long)((int)value) == value) {
            return (int)value;
        }
        throw new ArithmeticException("Int " + value + OUT_OF_RANGE);
    }

    public static short toUInt8(long value) throws ArithmeticException {
        if ((value & 0xFFL) == value) {
            return (short)value;
        }
        throw new ArithmeticException("Unsigned Byte " + value + OUT_OF_RANGE);
    }

    public static int toUInt16(long value) throws ArithmeticException {
        if ((value & 0xFFFFL) == value) {
            return (int)value;
        }
        throw new ArithmeticException("Unsigned Short " + value + OUT_OF_RANGE);
    }

    public static int toUInt31(long value) throws ArithmeticException {
        if ((value & Integer.MAX_VALUE) == value) {
            return (int)value;
        }
        throw new ArithmeticException("Unsigned Int 31-bit " + value + OUT_OF_RANGE);
    }

    public static long toUInt32(long value) throws ArithmeticException {
        if ((value & 0xFFFFFFFFL) == value) {
            return value;
        }
        throw new ArithmeticException("Unsigned Int " + value + OUT_OF_RANGE);
    }

    public static long agitate(long l) {
        l += l >>> 22;
        l ^= Long.rotateRight(l, 17);
        return l;
    }

    public static long hash64(long l0) {
        int l0a = (int)(l0 >> 32);
        long h0 = l0 * 1539836845L + (long)(l0a * -361396777);
        return Maths.agitate(h0);
    }

    public static long hash64(long l0, long l1) {
        int l0a = (int)(l0 >> 32);
        int l1a = (int)(l1 >> 32);
        long h0 = (l0 + (long)l1a) * 1539836845L;
        long h1 = (l1 + (long)l0a) * -361396777L;
        return Maths.agitate(h0) ^ Maths.agitate(h1);
    }

    public static long divideRoundUp(long dividend, long divisor) {
        int sign = (dividend > 0L ? 1 : -1) * (divisor > 0L ? 1 : -1);
        return (long)sign * (Math.abs(dividend) + Math.abs(divisor) - 1L) / Math.abs(divisor);
    }

    public static long tens(int decimalPlaces) {
        return TENS[decimalPlaces];
    }

    public static int digits(long num) {
        int index = Arrays.binarySearch(TENS, num);
        return index < -1 ? -1 - index : (index >= 0 ? index + 1 : 1);
    }

    public static long fives(int decimalPlaces) {
        return FIVES[decimalPlaces];
    }

    public static boolean same(double a, double b) {
        return Double.isNaN(a) ? Double.isNaN(b) : a == b;
    }

    public static boolean same(float a, float b) {
        return Float.isNaN(a) ? Float.isNaN(b) : a == b;
    }

    public static int hash(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static int hash(Object o1, Object o2) {
        return Maths.hash(o1) * 1539836845 + Maths.hash(o2);
    }

    public static int hash(Object o1, Object o2, Object o3) {
        return Maths.hash(o1, o2) * 1539836845 + Maths.hash(o3);
    }

    public static int hash(Object o1, Object o2, Object o3, Object o4) {
        return Maths.hash(o1, o2, o3) * 1539836845 + Maths.hash(o4);
    }

    public static int hash(Object o1, Object o2, Object o3, Object o4, Object o5) {
        return Maths.hash(o1, o2, o3, o4) * 1539836845 + Maths.hash(o5);
    }

    static {
        int i2;
        TENS = new long[19];
        FIVES = new long[28];
        Maths.FIVES[0] = 1L;
        Maths.TENS[0] = 1L;
        for (i2 = 1; i2 < TENS.length; ++i2) {
            Maths.TENS[i2] = 10L * TENS[i2 - 1];
        }
        for (i2 = 1; i2 < FIVES.length; ++i2) {
            Maths.FIVES[i2] = 5L * FIVES[i2 - 1];
        }
    }
}

