/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.concurrent.ThreadLocalRandom;
import net.openhft.affinity.Affinity;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.values.IntArrayValues;

public class ThreadIndexAssigner {
    private final IntArrayValues values;

    public ThreadIndexAssigner(IntArrayValues values) {
        this.values = values;
    }

    public int getId() throws IllegalStateException, BufferOverflowException, BufferUnderflowException {
        int threadId = Affinity.getThreadId();
        int size = (int)this.values.getCapacity();
        this.values.setMaxUsed(size);
        for (int i2 = 0; i2 < size; ++i2) {
            int value = this.values.getVolatileValueAt(i2);
            if (value != threadId) continue;
            return i2;
        }
        int index = this.nextIndex(size);
        for (int i3 = 0; i3 < size * 2; ++i3) {
            int value = this.values.getVolatileValueAt(index);
            boolean processAlive = Jvm.isProcessAlive(value);
            if ((value == 0 || !processAlive) && this.values.compareAndSet(index, value, threadId)) {
                return index;
            }
            if (++index < size) continue;
            Thread.yield();
            index = 0;
        }
        throw new IllegalStateException("Unable to acquire an id as all ids are taken");
    }

    protected int nextIndex(int size) {
        return ThreadLocalRandom.current().nextInt(size);
    }
}

