/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.wire.LongConverter;

public class Base128LongConverter
implements LongConverter {
    public static final int MAX_LENGTH = LongConverter.maxParseLength(128);
    public static final Base128LongConverter INSTANCE = new Base128LongConverter();

    @Override
    public int maxParseLength() {
        return MAX_LENGTH;
    }

    @Override
    public long parse(CharSequence text) {
        this.lengthCheck(text);
        long v = 0L;
        for (int i2 = 0; i2 < text.length(); ++i2) {
            v = (v << 7) + (long)text.charAt(i2);
        }
        return v;
    }

    @Override
    public void append(StringBuilder text, long value) {
        int start = text.length();
        while (value != 0L) {
            text.append((char)(value & 0x7FL));
            value >>>= 7;
        }
        StringUtils.reverse(text, start);
        if (text.length() > start + this.maxParseLength()) {
            Jvm.warn().on(this.getClass(), "truncated because the value was too large");
            text.setLength(start + this.maxParseLength());
        }
    }
}

