/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.math.BigInteger;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.wire.LongConverter;

public class Base95LongConverter
implements LongConverter {
    public static final int MAX_LENGTH = LongConverter.maxParseLength(95);
    public static final Base95LongConverter INSTANCE = new Base95LongConverter();
    private static final int BASE = 95;
    private static final BigInteger BASE_BI = BigInteger.valueOf(95L);
    private static final BigInteger TWO_TO_64 = BigInteger.ONE.shiftLeft(64);

    @Override
    public int maxParseLength() {
        return MAX_LENGTH;
    }

    @Override
    public long parse(CharSequence text) {
        this.lengthCheck(text);
        long v = 0L;
        for (int i2 = 0; i2 < text.length(); ++i2) {
            v = v * 95L + (long)text.charAt(i2) - 32L + 1L;
        }
        return v;
    }

    @Override
    public void append(StringBuilder text, long value) {
        int start = text.length();
        if (value < 0L) {
            BigInteger bi = BigInteger.valueOf(value).add(TWO_TO_64);
            int v = bi.mod(BASE_BI).intValueExact();
            value = bi.divide(BASE_BI).longValueExact();
            text.append((char)(32 + v - 1));
        }
        while (value != 0L) {
            int v = (int)(value % 95L);
            value /= 95L;
            text.append((char)(32 + v - 1));
        }
        StringUtils.reverse(text, start);
        if (text.length() > start + this.maxParseLength()) {
            Jvm.warn().on(this.getClass(), "truncated because the value was too large");
            text.setLength(start + this.maxParseLength());
        }
    }
}

