/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.util.StringUtils;

public class CharSequenceObjectMap<T> {
    private static final int K0 = 1829709757;
    private static final int M0 = 1539836845;
    final String[] keys;
    final T[] values;
    final int mask;

    public CharSequenceObjectMap(int capacity) {
        int nextPower2 = Maths.nextPower2(capacity, 16);
        this.keys = new String[nextPower2];
        this.values = new Object[nextPower2];
        this.mask = nextPower2 - 1;
    }

    public void put(CharSequence name, T t) {
        int h = this.hashFor(name);
        for (int i2 = 0; i2 < this.mask; ++i2) {
            if (this.keys[i2] == null || StringUtils.isEqual(this.keys[i2], name)) {
                this.keys[i2] = name.toString();
                this.values[i2] = t;
                return;
            }
            h = h + 1 & this.mask;
        }
        throw new IllegalStateException("Map is full");
    }

    public T get(CharSequence cs) {
        int h = this.hashFor(cs);
        for (int i2 = 0; i2 < this.mask; ++i2) {
            if (this.keys[i2] == null) {
                return null;
            }
            if (StringUtils.isEqual(this.keys[i2], cs)) {
                return this.values[i2];
            }
            h = h + 1 & this.mask;
        }
        throw new IllegalStateException("Map is full");
    }

    private int hashFor(CharSequence name) {
        long h = name.length();
        for (int i2 = 0; i2 < name.length(); ++i2) {
            h = h * 1829709757L + (long)name.charAt(i2);
        }
        return (int)Maths.agitate(h) & this.mask;
    }
}

