/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.IntSupplier;
import java.util.stream.IntStream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.wire.MessageHistory;

public class MessagePathClassifier
implements IntSupplier {
    private final List<int[]> sourcePattern = new ArrayList<int[]>();
    private final List<Integer> pathIds = new ArrayList<Integer>();

    public MessagePathClassifier addPathForSourcesEnding(int pathId, int ... sources) {
        OptionalInt duplicate = IntStream.range(0, this.sourcePattern.size()).filter(s -> Arrays.equals(sources, this.sourcePattern.get(s))).findFirst();
        if (duplicate.isPresent()) {
            if (sources[duplicate.getAsInt()] == pathId) {
                Jvm.debug().on(this.getClass(), "Added pathId " + pathId + " more than once");
                return this;
            }
            throw new IllegalArgumentException("Duplicate entry for " + Arrays.toString(sources) + " for path " + duplicate.getAsInt() + " and " + pathId);
        }
        this.sourcePattern.add(sources);
        this.pathIds.add(pathId);
        return this;
    }

    @Override
    public int getAsInt() {
        return this.pathFor(MessageHistory.get());
    }

    public int pathFor(MessageHistory messageHistory) {
        Integer pathId = null;
        int length = -1;
        for (int i2 = 0; i2 < this.sourcePattern.size(); ++i2) {
            int[] sourceIds = this.sourcePattern.get(i2);
            if (!messageHistory.sourceIdsEndsWith(sourceIds)) continue;
            Integer pathId2 = this.pathIds.get(i2);
            if (sourceIds.length <= length) continue;
            pathId = pathId2;
            length = sourceIds.length;
        }
        if (pathId == null) {
            throw new IllegalStateException("Unable to classify the pathId for " + messageHistory);
        }
        return pathId;
    }
}

