/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.internal;

import java.nio.BufferUnderflowException;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.jetbrains.annotations.NotNull;

public abstract class FromStringInterner<T> {
    protected final InternerEntry<T>[] entries;
    protected final int mask;
    protected final int shift;
    protected boolean toggle = false;

    public FromStringInterner(int capacity) throws IllegalArgumentException {
        int n = Maths.nextPower2(capacity, 128);
        this.shift = Maths.intLog2(n);
        this.entries = new InternerEntry[n];
        this.mask = n - 1;
    }

    public T intern(@NotNull String s) throws IllegalArgumentException, IORuntimeException, BufferUnderflowException {
        int hash = Maths.hash32(s);
        int h = hash & this.mask;
        InternerEntry<T> ie = this.entries[h];
        int length = s.length();
        if (ie != null && ie.key.length() == length && ie.key.equals(s)) {
            return ie.t;
        }
        int h2 = hash >> this.shift & this.mask;
        InternerEntry<T> s2 = this.entries[h2];
        if (s2 != null && s2.key.length() == length && s2.key.equals(s)) {
            return s2.t;
        }
        @NotNull T t = this.getValue(s);
        this.entries[ie == null || s2 != null && this.toggle() ? h : h2] = new InternerEntry<T>(s, t);
        return t;
    }

    @NotNull
    protected abstract T getValue(String var1) throws IORuntimeException;

    protected boolean toggle() {
        this.toggle = !this.toggle;
        return this.toggle;
    }

    static class InternerEntry<T> {
        final String key;
        final T t;

        InternerEntry(String key, T t) {
            this.key = key;
            this.t = t;
        }
    }
}

