/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.utils;

import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class SourceCodeFormatter
implements Appendable,
CharSequence {
    private final String indentSpaces;
    private final AtomicInteger indent;
    private final StringBuilder sb = new StringBuilder();
    private int lastNewlineIndex = 0;
    private boolean lastChargeWasNewLine = false;

    public SourceCodeFormatter(int indentSpaces, AtomicInteger indent) {
        this.indentSpaces = "        ".substring(0, indentSpaces);
        this.indent = indent;
    }

    public SourceCodeFormatter(int indentSpaces) {
        this(indentSpaces, new AtomicInteger(0));
    }

    public SourceCodeFormatter(int indentSpaces, int i2) {
        this(indentSpaces, new AtomicInteger(i2));
    }

    @Override
    @NotNull
    public String toString() {
        return this.sb.toString();
    }

    @Override
    public SourceCodeFormatter append(CharSequence csq) {
        this.append(csq, 0, csq.length());
        return this;
    }

    @Override
    public SourceCodeFormatter append(CharSequence csq, int start, int end) {
        for (int i2 = start; i2 < end; ++i2) {
            this.append(csq.charAt(i2));
        }
        return this;
    }

    @Override
    public SourceCodeFormatter append(char c) {
        this.sb.append(c);
        switch (c) {
            case '\n': {
                this.lastNewlineIndex = this.sb.length();
                this.lastChargeWasNewLine = true;
                this.padding(this.indent.get());
                break;
            }
            case '{': {
                this.indent.incrementAndGet();
                break;
            }
            case '}': {
                this.indent.decrementAndGet();
                if (this.lastNewlineIndex < 0) break;
                this.sb.setLength(this.lastNewlineIndex);
                this.padding(this.indent.get());
                this.sb.append(c);
                break;
            }
            case ' ': {
                if (!this.lastChargeWasNewLine) break;
                this.sb.setLength(this.sb.length() - 1);
                break;
            }
            default: {
                this.lastChargeWasNewLine = false;
            }
        }
        return this;
    }

    public void setLength(int len) {
        this.sb.setLength(len);
    }

    private void padding(int indent) {
        for (int i2 = 0; i2 < indent; ++i2) {
            this.sb.append(this.indentSpaces);
        }
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public char charAt(int index) {
        return this.sb.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.sb.subSequence(start, end);
    }

    public SourceCodeFormatter append(long i2) {
        this.sb.append(i2);
        return this;
    }

    public SourceCodeFormatter append(double d) {
        this.sb.append(d);
        return this;
    }

    public SourceCodeFormatter append(boolean flag) {
        this.sb.append(flag);
        return this;
    }

    public <Stringable> SourceCodeFormatter append(Stringable stringable) {
        this.sb.append(stringable);
        return this;
    }
}

