/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter;

import java.time.Clock;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class TimeMap<T>
implements Map<T, Long> {
    private static final Clock clock = Clock.systemUTC();
    private final Map<T, Long> map = new ConcurrentHashMap<T, Long>();

    public static <T, K> Collector<T, ?, TimeMap<K>> collectMillis(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends Long> timeMapper) {
        return Collectors.toMap(keyMapper, timeMapper, Math::max, TimeMap::new);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Long get(Object key) {
        return this.map.get(key);
    }

    public Long get(Object key, TimeUnit timeUnit) {
        Long sourceDuration = this.get(key);
        return sourceDuration == null ? null : Long.valueOf(timeUnit.convert(sourceDuration, TimeUnit.MILLISECONDS));
    }

    public long putRemaining(T key, long value, TimeUnit timeUnit) {
        long absoluteValue = clock.instant().plusMillis(TimeUnit.MILLISECONDS.convert(value, timeUnit)).toEpochMilli();
        return this.compute(key, (item, oldValue) -> oldValue == null ? absoluteValue : Math.max(oldValue, absoluteValue));
    }

    public Long getRemaining(Object key, TimeUnit timeUnit) {
        Long get = this.get(key);
        if (get == null) {
            return null;
        }
        long remainingMillis = get - this.now();
        return remainingMillis <= 0L ? null : Long.valueOf(timeUnit.convert(remainingMillis, TimeUnit.MILLISECONDS));
    }

    @Override
    public Long put(T key, Long value) {
        return this.map.put(key, value);
    }

    public long put(T key, long value, TimeUnit timeUnit) {
        return this.put(key, TimeUnit.MILLISECONDS.convert(value, timeUnit));
    }

    @Override
    public Long remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends T, ? extends Long> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<T> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Long> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<T, Long>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof TimeMap) {
            TimeMap other = (TimeMap)o;
            return this.map.equals(other.map);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public long now() {
        return clock.millis();
    }
}

