/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter.cachesketch;

import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import orestes.bloomfilter.TimeMap;
import orestes.bloomfilter.cachesketch.ExpirationQueue;

public class ExpirationQueueMemory<T>
implements ExpirationQueue<T> {
    private volatile Future<?> future;
    private volatile boolean isEnabled;
    private final DelayQueue<ExpirationQueue.ExpiringItem<T>> delayedQueue;
    private final Consumer<ExpirationQueue.ExpiringItem<T>> handler;
    private final ExecutorService delayedQueueExecutorService = Executors.newSingleThreadExecutor();

    public ExpirationQueueMemory(Consumer<ExpirationQueue.ExpiringItem<T>> handler) {
        this.delayedQueue = new DelayQueue();
        this.handler = handler;
        this.enable();
    }

    @Override
    public synchronized boolean enable() {
        if (this.isEnabled) {
            return false;
        }
        this.isEnabled = true;
        this.future = this.delayedQueueExecutorService.submit(() -> {
            try {
                while (this.isEnabled) {
                    ExpirationQueue.ExpiringItem e = (ExpirationQueue.ExpiringItem)this.delayedQueue.take();
                    if (e.getItem() == null) continue;
                    this.handler.accept(e);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        return true;
    }

    @Override
    public synchronized boolean disable() {
        if (!this.isEnabled) {
            return false;
        }
        this.isEnabled = false;
        this.delayedQueue.add(new ExpirationQueue.ExpiringItem<Object>(null, 0L, TimeUnit.NANOSECONDS));
        try {
            this.future.get();
            return true;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        return this.delayedQueue.size();
    }

    @Override
    public boolean add(ExpirationQueue.ExpiringItem<T> item) {
        return this.delayedQueue.add(item);
    }

    @Override
    public Queue<ExpirationQueue.ExpiringItem<T>> getNonExpired() {
        return this.delayedQueue;
    }

    @Override
    public void clear() {
        this.delayedQueue.clear();
    }

    @Override
    public boolean contains(T item) {
        return this.delayedQueue.stream().anyMatch(it -> it.getItem().equals(item));
    }

    @Override
    public boolean remove(T item) {
        Optional<ExpirationQueue.ExpiringItem> found = this.delayedQueue.stream().filter(it -> it.getItem().equals(item)).findFirst();
        return found.filter(this.delayedQueue::remove).isPresent();
    }

    @Override
    public TimeMap<T> getExpirationMap() {
        return this.delayedQueue.stream().filter(item -> item.getItem() != null).collect(TimeMap::new, (timeMap, item) -> timeMap.put(item.getItem(), item.getExpiration(TimeUnit.MILLISECONDS)), TimeMap::putAll);
    }

    @Override
    public void setExpirationMap(TimeMap<T> map) {
        map.forEach((? super K item, ? super V ttl) -> this.addExpiration(item, (long)ttl, TimeUnit.MILLISECONDS));
    }
}

