/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter.cachesketch;

import java.util.concurrent.TimeUnit;
import orestes.bloomfilter.BloomFilter;
import orestes.bloomfilter.FilterBuilder;
import orestes.bloomfilter.TimeMap;
import orestes.bloomfilter.cachesketch.AbstractExpiringBloomFilterRedis;
import orestes.bloomfilter.cachesketch.ExpirationQueue;
import orestes.bloomfilter.cachesketch.ExpirationQueueMemory;
import redis.clients.jedis.Jedis;

public class ExpiringBloomFilterRedis<T>
extends AbstractExpiringBloomFilterRedis<T> {
    private final ExpirationQueue<T> queue = new ExpirationQueueMemory(this::onExpire);

    public ExpiringBloomFilterRedis(FilterBuilder builder) {
        super(builder);
    }

    @Override
    protected void addToQueue(T element, long remaining, TimeUnit timeUnit) {
        this.queue.addExpiration(element, this.now() + remaining, timeUnit);
    }

    @Override
    public void clear() {
        try (Jedis jedis = this.pool.getResource();){
            jedis.del(new String[]{this.keys.COUNTS_KEY, this.keys.BITS_KEY, this.keys.TTL_KEY});
            this.clearExpirationQueue();
        }
    }

    @Override
    public void softClear() {
        try (Jedis jedis = this.pool.getResource();){
            jedis.del(new String[]{this.keys.COUNTS_KEY, this.keys.BITS_KEY});
            this.clearExpirationQueue();
        }
    }

    private void clearExpirationQueue() {
        if (this.queue != null) {
            this.queue.clear();
        }
    }

    @Override
    public BloomFilter<T> getClonedBloomFilter() {
        return this.toMemoryFilter();
    }

    @Override
    public boolean setExpirationEnabled(boolean enabled) {
        return this.queue.setEnabled(enabled);
    }

    @Override
    public TimeMap<T> getExpirationMap() {
        return this.queue.getExpirationMap();
    }

    @Override
    public void setExpirationMap(TimeMap<T> map) {
        this.queue.setExpirationMap(map);
    }

    private void onExpire(ExpirationQueue.ExpiringItem<T> entry) {
        this.removeAndEstimateCount(entry.getItem());
    }
}

