/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter.memory;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import orestes.bloomfilter.FilterBuilder;
import orestes.bloomfilter.memory.BloomFilterMemory;
import orestes.bloomfilter.memory.CountingBloomFilterMemory;

public class CountingBloomFilter64<T>
extends CountingBloomFilterMemory<T> {
    private long[] counters;
    private static final long MAX = Long.MAX_VALUE;

    public CountingBloomFilter64(FilterBuilder config) {
        config.countingBits(64).complete();
        this.config = config;
        this.filter = new BloomFilterMemory(config.clone());
        this.counters = new long[config.size()];
    }

    @Override
    protected long increment(int index) {
        if (this.counters[index] == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        int n = index;
        long l = this.counters[n] + 1L;
        this.counters[n] = l;
        return l;
    }

    @Override
    protected long decrement(int index) {
        if (this.counters[index] == 0L) {
            return 0L;
        }
        int n = index;
        long l = this.counters[n] - 1L;
        this.counters[n] = l;
        return l;
    }

    @Override
    protected long count(int index) {
        return this.counters[index];
    }

    @Override
    protected void set(int index, long newValue) {
        this.counters[index] = newValue;
    }

    @Override
    public Map<Integer, Long> getCountMap() {
        HashMap<Integer, Long> result = new HashMap<Integer, Long>();
        for (int i2 = 0; i2 < this.counters.length; ++i2) {
            long count = this.counters[i2];
            if (count <= 0L) continue;
            result.put(i2, count);
        }
        return result;
    }

    @Override
    public void clear() {
        this.filter.clear();
        this.counters = new long[this.counters.length];
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CountingBloomFilter64)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CountingBloomFilter64 that = (CountingBloomFilter64)o;
        return Objects.equals(this.counters, that.counters);
    }
}

