/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter.redis;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.msgpack.MessagePack;
import org.msgpack.type.MapValue;
import org.msgpack.type.Value;

public class MessagePackEncoder {
    public static final int HASH_LENGTH = 8;
    private final MessagePack messagePack = new MessagePack();

    public byte[] encodeItem(String item, int[] positions) {
        String hash = this.createRandomHash();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", item);
        map.put("hash", hash);
        map.put("positions", positions);
        try {
            return this.messagePack.write(map);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String decodeItem(byte[] bytes) {
        MapValue map;
        try {
            map = this.messagePack.read(bytes).asMapValue();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!((Value)entry.getKey()).asRawValue().getString().equals("name")) continue;
            return ((Value)entry.getValue()).asRawValue().getString();
        }
        throw new RuntimeException("Name is missing in message pack");
    }

    private String createRandomHash() {
        return UUID.randomUUID().toString().substring(0, 8);
    }
}

