/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MissingProjectException;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.TopologicalSorter;
import org.codehaus.plexus.util.dag.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectSorter {
    private final DAG dag = new DAG();
    private final Map projectMap = new HashMap();
    private final List<MavenProject> sortedProjects;
    private MavenProject topLevelProject;

    public ProjectSorter(List projects) throws CycleDetectedException, DuplicateProjectException, MissingProjectException {
        this(projects, null, null, false, false);
    }

    public ProjectSorter(List projects, List selectedProjectNames, String resumeFrom, boolean make, boolean makeDependents) throws CycleDetectedException, DuplicateProjectException, MissingProjectException {
        String id2;
        for (MavenProject project : projects) {
            id2 = ArtifactUtils.versionlessKey(project.getGroupId(), project.getArtifactId());
            if (this.dag.getVertex(id2) != null) {
                throw new DuplicateProjectException("Project '" + id2 + "' is duplicated in the reactor");
            }
            this.dag.addVertex(id2);
            this.projectMap.put(id2, project);
        }
        for (MavenProject project : projects) {
            List reportPlugins;
            List buildPlugins;
            String parentId;
            id2 = ArtifactUtils.versionlessKey(project.getGroupId(), project.getArtifactId());
            for (Dependency dependency : project.getDependencies()) {
                String dependencyId = ArtifactUtils.versionlessKey(dependency.getGroupId(), dependency.getArtifactId());
                if (this.dag.getVertex(dependencyId) == null) continue;
                project.addProjectReference((MavenProject)this.projectMap.get(dependencyId));
                this.dag.addEdge(id2, dependencyId);
            }
            MavenProject parent = project.getParent();
            if (parent != null && this.dag.getVertex(parentId = ArtifactUtils.versionlessKey(parent.getGroupId(), parent.getArtifactId())) != null) {
                if (this.dag.hasEdge(parentId, id2)) {
                    this.dag.removeEdge(parentId, id2);
                }
                this.dag.addEdge(id2, parentId);
            }
            if ((buildPlugins = project.getBuildPlugins()) != null) {
                for (Plugin plugin : buildPlugins) {
                    String pluginId = ArtifactUtils.versionlessKey(plugin.getGroupId(), plugin.getArtifactId());
                    if (this.dag.getVertex(pluginId) != null && !pluginId.equals(id2)) {
                        this.addEdgeWithParentCheck(this.projectMap, pluginId, project, id2);
                    }
                    if (pluginId.equals(id2)) continue;
                    for (Dependency dependency : plugin.getDependencies()) {
                        String dependencyId = ArtifactUtils.versionlessKey(dependency.getGroupId(), dependency.getArtifactId());
                        if (this.dag.getVertex(dependencyId) == null || id2.equals(dependencyId)) continue;
                        project.addProjectReference((MavenProject)this.projectMap.get(dependencyId));
                        this.addEdgeWithParentCheck(this.projectMap, dependencyId, project, id2);
                    }
                }
            }
            if ((reportPlugins = project.getReportPlugins()) != null) {
                for (ReportPlugin plugin : reportPlugins) {
                    String pluginId = ArtifactUtils.versionlessKey(plugin.getGroupId(), plugin.getArtifactId());
                    if (this.dag.getVertex(pluginId) == null || pluginId.equals(id2)) continue;
                    this.addEdgeWithParentCheck(this.projectMap, pluginId, project, id2);
                }
            }
            for (Extension extension : project.getBuildExtensions()) {
                String extensionId = ArtifactUtils.versionlessKey(extension.getGroupId(), extension.getArtifactId());
                if (this.dag.getVertex(extensionId) == null) continue;
                this.addEdgeWithParentCheck(this.projectMap, extensionId, project, id2);
            }
        }
        List<Object> sortedProjects = new ArrayList();
        for (String id2 : TopologicalSorter.sort(this.dag)) {
            sortedProjects.add(this.projectMap.get(id2));
        }
        Iterator<String> i2 = sortedProjects.iterator();
        while (i2.hasNext() && this.topLevelProject == null) {
            MavenProject project = (MavenProject)((Object)i2.next());
            if (!project.isExecutionRoot()) continue;
            this.topLevelProject = project;
        }
        sortedProjects = ProjectSorter.applyMakeFilter(sortedProjects, this.dag, this.projectMap, this.topLevelProject, selectedProjectNames, make, makeDependents);
        ProjectSorter.resumeFrom(resumeFrom, sortedProjects, this.projectMap, this.topLevelProject);
        this.sortedProjects = Collections.unmodifiableList(sortedProjects);
    }

    private static List applyMakeFilter(List sortedProjects, DAG dag, Map projectMap, MavenProject topLevelProject, List selectedProjectNames, boolean make, boolean makeDependents) throws MissingProjectException {
        MavenProject project;
        if (selectedProjectNames == null) {
            return sortedProjects;
        }
        MavenProject[] selectedProjects = new MavenProject[selectedProjectNames.size()];
        for (int i2 = 0; i2 < selectedProjects.length; ++i2) {
            selectedProjects[i2] = ProjectSorter.findProject((String)selectedProjectNames.get(i2), projectMap, topLevelProject);
        }
        HashSet<MavenProject> projectsToMake = new HashSet<MavenProject>(Arrays.asList(selectedProjects));
        for (int i3 = 0; i3 < selectedProjects.length; ++i3) {
            project = selectedProjects[i3];
            String id = ArtifactUtils.versionlessKey(project.getGroupId(), project.getArtifactId());
            Vertex v = dag.getVertex(id);
            if (make) {
                ProjectSorter.gatherDescendents(v, projectMap, projectsToMake, new HashSet());
            }
            if (!makeDependents) continue;
            ProjectSorter.gatherAncestors(v, projectMap, projectsToMake, new HashSet());
        }
        Iterator i4 = sortedProjects.iterator();
        while (i4.hasNext()) {
            project = (MavenProject)i4.next();
            if (projectsToMake.contains(project)) continue;
            i4.remove();
        }
        return sortedProjects;
    }

    private static void resumeFrom(String resumeFrom, List sortedProjects, Map projectMap, MavenProject topLevelProject) throws MissingProjectException {
        MavenProject project;
        if (resumeFrom == null) {
            return;
        }
        MavenProject resumeFromProject = ProjectSorter.findProject(resumeFrom, projectMap, topLevelProject);
        Iterator i2 = sortedProjects.iterator();
        while (i2.hasNext() && !resumeFromProject.equals(project = (MavenProject)i2.next())) {
            i2.remove();
        }
        if (sortedProjects.isEmpty()) {
            throw new MissingProjectException("Couldn't resume, project was not scheduled to run: " + resumeFrom);
        }
    }

    private static MavenProject findProject(String projectName, Map projectMap, MavenProject topLevelProject) throws MissingProjectException {
        MavenProject project2 = (MavenProject)projectMap.get(projectName);
        if (project2 != null) {
            return project2;
        }
        File baseDir = topLevelProject == null ? new File(System.getProperty("user.dir")) : topLevelProject.getBasedir();
        File projectDir = new File(baseDir, projectName);
        if (!projectDir.exists()) {
            throw new MissingProjectException("Couldn't find specified project dir: " + projectDir.getAbsolutePath());
        }
        if (!projectDir.isDirectory()) {
            throw new MissingProjectException("Couldn't find specified project dir (not a directory): " + projectDir.getAbsolutePath());
        }
        for (MavenProject project2 : projectMap.values()) {
            if (!projectDir.equals(project2.getFile().getParentFile())) continue;
            return project2;
        }
        throw new MissingProjectException("Couldn't find specified project in module list: " + projectDir.getAbsolutePath());
    }

    private static void gatherDescendents(Vertex v, Map projectMap, Set out, Set visited) {
        if (visited.contains(v)) {
            return;
        }
        visited.add(v);
        out.add(projectMap.get(v.getLabel()));
        for (Vertex child : v.getChildren()) {
            ProjectSorter.gatherDescendents(child, projectMap, out, visited);
        }
    }

    private static void gatherAncestors(Vertex v, Map projectMap, Set out, Set visited) {
        if (visited.contains(v)) {
            return;
        }
        visited.add(v);
        out.add(projectMap.get(v.getLabel()));
        for (Vertex parent : v.getParents()) {
            ProjectSorter.gatherAncestors(parent, projectMap, out, visited);
        }
    }

    private void addEdgeWithParentCheck(Map projectMap, String projectRefId, MavenProject project, String id) throws CycleDetectedException {
        MavenProject extProject = (MavenProject)projectMap.get(projectRefId);
        if (extProject == null) {
            return;
        }
        project.addProjectReference(extProject);
        MavenProject extParent = extProject.getParent();
        if (extParent != null) {
            String parentId = ArtifactUtils.versionlessKey(extParent.getGroupId(), extParent.getArtifactId());
            if (!this.dag.hasEdge(projectRefId, id) || !parentId.equals(id)) {
                this.dag.addEdge(id, projectRefId);
            }
        }
    }

    public MavenProject getTopLevelProject() {
        return this.topLevelProject;
    }

    public List<MavenProject> getSortedProjects() {
        return this.sortedProjects;
    }

    public boolean hasMultipleProjects() {
        return this.sortedProjects.size() > 1;
    }

    public List getDependents(String id) {
        return this.dag.getParentLabels(id);
    }

    public DAG getDAG() {
        return this.dag;
    }

    public Map getProjectMap() {
        return this.projectMap;
    }
}

