/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.artifact;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Relocation;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.ActiveProjectArtifact;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.validation.ModelValidationResult;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

public class MavenMetadataSource
extends AbstractLogEnabled
implements ArtifactMetadataSource {
    public static final String ROLE_HINT = "maven";
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactFactory artifactFactory;
    private RepositoryMetadataManager repositoryMetadataManager;
    private MavenProject superProject;
    private Set warnedPoms = new HashSet();

    public Artifact retrieveRelocatedArtifact(Artifact artifact, ArtifactRepository localRepository, List remoteRepositories) throws ArtifactMetadataRetrievalException {
        if (artifact instanceof ActiveProjectArtifact) {
            return artifact;
        }
        ProjectRelocation rel = this.retrieveRelocatedProject(artifact, localRepository, remoteRepositories);
        if (rel == null) {
            return artifact;
        }
        MavenProject project = rel.project;
        if (project == null || this.getRelocationKey(artifact).equals(this.getRelocationKey(project.getArtifact()))) {
            return artifact;
        }
        Artifact result = null;
        result = artifact.getClassifier() != null ? this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), artifact.getClassifier()) : this.artifactFactory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope(), artifact.getType());
        result.setResolved(artifact.isResolved());
        result.setFile(artifact.getFile());
        result.setScope(artifact.getScope());
        result.setArtifactHandler(artifact.getArtifactHandler());
        result.setDependencyFilter(artifact.getDependencyFilter());
        result.setDependencyTrail(artifact.getDependencyTrail());
        result.setOptional(artifact.isOptional());
        result.setRelease(artifact.isRelease());
        return result;
    }

    private String getRelocationKey(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
    }

    private ProjectRelocation retrieveRelocatedProject(Artifact artifact, ArtifactRepository localRepository, List remoteRepositories) throws ArtifactMetadataRetrievalException {
        Artifact pomArtifact;
        MavenProject project = null;
        boolean done = false;
        do {
            pomArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope());
            if ("system".equals(artifact.getScope())) {
                done = true;
                continue;
            }
            try {
                project = this.mavenProjectBuilder.buildFromRepository(pomArtifact, remoteRepositories, localRepository, true);
            }
            catch (InvalidProjectModelException e) {
                String id = pomArtifact.getId();
                if (!this.warnedPoms.contains(id)) {
                    this.warnedPoms.add(pomArtifact.getId());
                    this.getLogger().warn("POM for '" + pomArtifact + "' is invalid.\n\nIts dependencies (if any) will NOT be available to the current build.");
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Reason: " + e.getMessage());
                        ModelValidationResult validationResult = e.getValidationResult();
                        if (validationResult != null) {
                            this.getLogger().debug("\nValidation Errors:");
                            Iterator i2 = validationResult.getMessages().iterator();
                            while (i2.hasNext()) {
                                this.getLogger().debug(i2.next().toString());
                            }
                            this.getLogger().debug("\n");
                        }
                    }
                }
                project = null;
            }
            catch (ProjectBuildingException e) {
                throw new ArtifactMetadataRetrievalException("Unable to read the metadata file for artifact '" + artifact.getDependencyConflictId() + "': " + e.getMessage(), (Throwable)e, artifact);
            }
            if (project != null) {
                Relocation relocation = null;
                DistributionManagement distMgmt = project.getDistributionManagement();
                if (distMgmt != null) {
                    relocation = distMgmt.getRelocation();
                    artifact.setDownloadUrl(distMgmt.getDownloadUrl());
                    pomArtifact.setDownloadUrl(distMgmt.getDownloadUrl());
                }
                if (relocation != null) {
                    if (relocation.getGroupId() != null) {
                        artifact.setGroupId(relocation.getGroupId());
                        project.setGroupId(relocation.getGroupId());
                    }
                    if (relocation.getArtifactId() != null) {
                        artifact.setArtifactId(relocation.getArtifactId());
                        project.setArtifactId(relocation.getArtifactId());
                    }
                    if (relocation.getVersion() != null) {
                        artifact.setVersionRange(VersionRange.createFromVersion(relocation.getVersion()));
                        project.setVersion(relocation.getVersion());
                    }
                    if (artifact.getDependencyFilter() != null && !artifact.getDependencyFilter().include(artifact)) {
                        return null;
                    }
                    List<ArtifactVersion> available = artifact.getAvailableVersions();
                    if (available != null && !available.isEmpty()) {
                        artifact.setAvailableVersions(this.retrieveAvailableVersions(artifact, localRepository, remoteRepositories));
                    }
                    String message = "\n  This artifact has been relocated to " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ".\n";
                    if (relocation.getMessage() != null) {
                        message = message + "  " + relocation.getMessage() + "\n";
                    }
                    if (artifact.getDependencyTrail() != null && artifact.getDependencyTrail().size() == 1) {
                        this.getLogger().warn("While downloading " + pomArtifact.getGroupId() + ":" + pomArtifact.getArtifactId() + ":" + pomArtifact.getVersion() + message + "\n");
                        continue;
                    }
                    this.getLogger().debug("While downloading " + pomArtifact.getGroupId() + ":" + pomArtifact.getArtifactId() + ":" + pomArtifact.getVersion() + message + "\n");
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        } while (!done);
        ProjectRelocation rel = new ProjectRelocation();
        rel.project = project;
        rel.pomArtifact = pomArtifact;
        return rel;
    }

    public ResolutionGroup retrieve(Artifact artifact, ArtifactRepository localRepository, List remoteRepositories) throws ArtifactMetadataRetrievalException {
        ResolutionGroup result;
        ProjectRelocation rel = this.retrieveRelocatedProject(artifact, localRepository, remoteRepositories);
        if (rel == null) {
            return null;
        }
        MavenProject project = rel.project;
        Artifact pomArtifact = rel.pomArtifact;
        if (artifact.getDownloadUrl() == null && pomArtifact != null) {
            artifact.setDownloadUrl(pomArtifact.getDownloadUrl());
        }
        if (project == null) {
            result = new ResolutionGroup(pomArtifact, Collections.EMPTY_SET, Collections.EMPTY_LIST);
        } else {
            Set artifacts = Collections.EMPTY_SET;
            if (!artifact.getArtifactHandler().isIncludesDependencies()) {
                try {
                    artifacts = project.createArtifacts(this.artifactFactory, artifact.getScope(), artifact.getDependencyFilter());
                }
                catch (InvalidDependencyVersionException e) {
                    throw new ArtifactMetadataRetrievalException("Error in metadata for artifact '" + artifact.getDependencyConflictId() + "': " + e.getMessage(), (Throwable)e);
                }
            }
            List repositories = this.aggregateRepositoryLists(remoteRepositories, project.getRemoteArtifactRepositories());
            result = new ResolutionGroup(pomArtifact, artifacts, repositories);
        }
        return result;
    }

    private List aggregateRepositoryLists(List remoteRepositories, List remoteArtifactRepositories) throws ArtifactMetadataRetrievalException {
        if (this.superProject == null) {
            try {
                this.superProject = this.mavenProjectBuilder.buildStandaloneSuperProject(new DefaultProjectBuilderConfiguration());
            }
            catch (ProjectBuildingException e) {
                throw new ArtifactMetadataRetrievalException("Unable to parse the Maven built-in model: " + e.getMessage(), (Throwable)e);
            }
        }
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        repositories.addAll(remoteRepositories);
        for (ArtifactRepository superRepo : this.superProject.getRemoteArtifactRepositories()) {
            Iterator aggregatedIterator = repositories.iterator();
            while (aggregatedIterator.hasNext()) {
                ArtifactRepository repo = (ArtifactRepository)aggregatedIterator.next();
                if (!repo.getId().equals(superRepo.getId()) || !repo.getUrl().equals(superRepo.getUrl())) continue;
                aggregatedIterator.remove();
            }
        }
        for (ArtifactRepository repository : remoteArtifactRepositories) {
            if (repositories.contains(repository)) continue;
            repositories.add(repository);
        }
        return repositories;
    }

    public static Set createArtifacts(ArtifactFactory artifactFactory, List dependencies, String inheritedScope, ArtifactFilter dependencyFilter, MavenProject project) throws InvalidDependencyVersionException {
        LinkedHashSet<Artifact> projectArtifacts = new LinkedHashSet<Artifact>(dependencies.size());
        for (Dependency d : dependencies) {
            VersionRange versionRange;
            String scope = d.getScope();
            if (StringUtils.isEmpty(scope)) {
                scope = "compile";
                d.setScope(scope);
            }
            try {
                versionRange = VersionRange.createFromVersionSpec(d.getVersion());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new InvalidDependencyVersionException("Unable to parse version '" + d.getVersion() + "' for dependency '" + d.getManagementKey() + "': " + e.getMessage(), e);
            }
            Artifact artifact = artifactFactory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), scope, inheritedScope, d.isOptional());
            if ("system".equals(scope)) {
                artifact.setFile(new File(d.getSystemPath()));
            }
            ArtifactFilter artifactFilter = dependencyFilter;
            if (artifact == null || artifactFilter != null && !artifactFilter.include(artifact)) continue;
            if (d.getExclusions() != null && !d.getExclusions().isEmpty()) {
                ArrayList<String> exclusions = new ArrayList<String>();
                for (Exclusion e : d.getExclusions()) {
                    exclusions.add(e.getGroupId() + ":" + e.getArtifactId());
                }
                ExcludesArtifactFilter newFilter = new ExcludesArtifactFilter(exclusions);
                if (artifactFilter != null) {
                    AndArtifactFilter filter = new AndArtifactFilter();
                    filter.add(artifactFilter);
                    filter.add((ArtifactFilter)newFilter);
                    artifactFilter = filter;
                } else {
                    artifactFilter = newFilter;
                }
            }
            artifact.setDependencyFilter(artifactFilter);
            if (project != null) {
                artifact = project.replaceWithActiveArtifact(artifact);
            }
            projectArtifacts.add(artifact);
        }
        return projectArtifacts;
    }

    public List retrieveAvailableVersions(Artifact artifact, ArtifactRepository localRepository, List remoteRepositories) throws ArtifactMetadataRetrievalException {
        ArrayList<DefaultArtifactVersion> versions;
        ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(artifact);
        try {
            this.repositoryMetadataManager.resolve(metadata, remoteRepositories, localRepository);
        }
        catch (RepositoryMetadataResolutionException e) {
            throw new ArtifactMetadataRetrievalException(e.getMessage(), (Throwable)e);
        }
        Metadata repoMetadata = metadata.getMetadata();
        if (repoMetadata != null && repoMetadata.getVersioning() != null) {
            List<String> metadataVersions = repoMetadata.getVersioning().getVersions();
            versions = new ArrayList<DefaultArtifactVersion>(metadataVersions.size());
            for (String version : metadataVersions) {
                versions.add(new DefaultArtifactVersion(version));
            }
        } else {
            versions = Collections.EMPTY_LIST;
        }
        return versions;
    }

    private static final class ProjectRelocation {
        private MavenProject project;
        private Artifact pomArtifact;

        private ProjectRelocation() {
        }
    }
}

