/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.api.report;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.maven.surefire.api.report.SafeThrowable;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.util.internal.StringUtils;

public class LegacyPojoStackTraceWriter
implements StackTraceWriter {
    private final Throwable t;
    private final String testClass;
    private final String testMethod;

    public LegacyPojoStackTraceWriter(String testClass, String testMethod, Throwable t) {
        this.testClass = testClass;
        this.testMethod = testMethod;
        this.t = t;
    }

    @Override
    public String writeTraceToString() {
        if (this.t != null) {
            String exc;
            StringWriter w = new StringWriter();
            try (PrintWriter stackTrace = new PrintWriter(w);){
                this.t.printStackTrace(stackTrace);
            }
            StringBuffer builder = w.getBuffer();
            if (LegacyPojoStackTraceWriter.isMultiLineExceptionMessage(this.t) && StringUtils.startsWith(builder, exc = this.t.getClass().getName() + ": ")) {
                builder.insert(exc.length(), '\n');
            }
            return builder.toString();
        }
        return "";
    }

    @Override
    public String smartTrimmedStackTrace() {
        StringBuilder result = new StringBuilder();
        result.append(this.testClass);
        result.append("#");
        result.append(this.testMethod);
        SafeThrowable throwable = this.getThrowable();
        Throwable target = throwable.getTarget();
        if (target != null) {
            String msg;
            if (!(target instanceof AssertionError)) {
                result.append(' ').append(target.getClass().getSimpleName());
            }
            if (org.apache.maven.surefire.shared.utils.StringUtils.isNotEmpty(msg = throwable.getMessage())) {
                result.append(' ').append(msg);
            }
        }
        return result.toString();
    }

    private static boolean isMultiLineExceptionMessage(Throwable t) {
        String msg = t.getLocalizedMessage();
        if (msg != null) {
            int countNewLines = 0;
            int length = msg.length();
            for (int i2 = 0; i2 < length && (msg.charAt(i2) != '\n' || ++countNewLines != 2); ++i2) {
            }
            return countNewLines > 1 || countNewLines == 1 && !msg.trim().endsWith("\n");
        }
        return false;
    }

    @Override
    public String writeTrimmedTraceToString() {
        int i2;
        String text = this.writeTraceToString();
        String marker = "at " + this.testClass + "." + this.testMethod;
        String[] lines = StringUtils.split(text, "\n");
        int lastLine = lines.length - 1;
        int causedByLine = -1;
        for (int i3 = 1; i3 < lines.length; ++i3) {
            String line = lines[i3].trim();
            if (line.startsWith(marker)) {
                lastLine = i3;
                continue;
            }
            if (!line.startsWith("Caused by")) continue;
            causedByLine = i3;
            break;
        }
        StringBuilder trace = new StringBuilder();
        for (i2 = 0; i2 <= lastLine; ++i2) {
            trace.append(lines[i2]);
            trace.append("\n");
        }
        if (causedByLine != -1) {
            for (i2 = causedByLine; i2 < lines.length; ++i2) {
                trace.append(lines[i2]);
                trace.append("\n");
            }
        }
        return trace.toString();
    }

    @Override
    public SafeThrowable getThrowable() {
        return new SafeThrowable(this.t);
    }
}

