/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.api.stream;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import javax.annotation.Nonnull;
import org.apache.maven.surefire.api.report.RunMode;
import org.apache.maven.surefire.api.util.internal.WritableBufferedByteChannel;

public abstract class AbstractStreamEncoder<E extends Enum<E>> {
    private static final byte BOOLEAN_NON_NULL_OBJECT = -1;
    private static final byte BOOLEAN_NULL_OBJECT = 0;
    private static final byte[] INT_BINARY = new byte[]{0, 0, 0, 0};
    private final WritableByteChannel out;

    public AbstractStreamEncoder(WritableByteChannel out) {
        this.out = out;
    }

    @Nonnull
    protected abstract byte[] getEncodedMagicNumber();

    @Nonnull
    protected abstract byte[] enumToByteArray(E var1);

    @Nonnull
    protected abstract byte[] getEncodedCharsetName();

    @Nonnull
    protected abstract Charset getCharset();

    @Nonnull
    protected abstract CharsetEncoder newCharsetEncoder();

    protected void write(ByteBuffer frame, boolean sendImmediately) throws IOException {
        if (!sendImmediately && this.out instanceof WritableBufferedByteChannel) {
            ((WritableBufferedByteChannel)this.out).writeBuffered(frame);
        } else {
            this.out.write(frame);
        }
    }

    public void encodeHeader(ByteBuffer result, E operation, RunMode runMode, Long testRunId) {
        this.encodeHeader(result, operation);
        byte[] runmode = runMode == null ? new byte[]{} : runMode.getRunmodeBinary();
        result.put((byte)runmode.length);
        result.put((byte)58);
        result.put(runmode);
        result.put((byte)58);
        result.put((byte)(testRunId != null ? 1 : 0));
        if (testRunId != null) {
            result.putLong(testRunId);
        }
        result.put((byte)58);
    }

    public void encodeHeader(ByteBuffer result, E operation) {
        result.put((byte)58);
        result.put(this.getEncodedMagicNumber());
        result.put((byte)58);
        byte[] opcode = this.enumToByteArray(operation);
        result.put((byte)opcode.length);
        result.put((byte)58);
        result.put(opcode);
        result.put((byte)58);
    }

    public void encodeCharset(ByteBuffer result) {
        byte[] charsetNameBinary = this.getEncodedCharsetName();
        result.put((byte)charsetNameBinary.length);
        result.put((byte)58);
        result.put(charsetNameBinary);
        result.put((byte)58);
    }

    public void encodeString(CharsetEncoder encoder, ByteBuffer result, String string) {
        String nonNullString = AbstractStreamEncoder.nonNull(string);
        int counterPosition = result.position();
        result.put(INT_BINARY).put((byte)58);
        int msgStart = result.position();
        encoder.encode(CharBuffer.wrap(nonNullString), result, true);
        int msgEnd = result.position();
        int encodedMsgSize = msgEnd - msgStart;
        result.putInt(counterPosition, encodedMsgSize);
        ((Buffer)result).position(msgEnd);
        result.put((byte)58);
    }

    public void encodeInteger(ByteBuffer result, Integer i2) {
        if (i2 == null) {
            result.put((byte)0);
        } else {
            result.put((byte)-1).putInt(i2);
        }
        result.put((byte)58);
    }

    public void encode(CharsetEncoder encoder, ByteBuffer result, E operation, RunMode runMode, Long testRunId, String ... messages) {
        this.encodeHeader(result, operation, runMode, testRunId);
        this.encodeStringData(result, encoder, messages);
    }

    public void encode(CharsetEncoder encoder, ByteBuffer result, E operation, String ... messages) {
        this.encodeHeader(result, operation);
        this.encodeStringData(result, encoder, messages);
    }

    private void encodeStringData(ByteBuffer result, CharsetEncoder encoder, String ... messages) {
        this.encodeCharset(result);
        for (String message : messages) {
            this.encodeString(encoder, result, message);
        }
    }

    public int estimateBufferLength(int opcodeLength, RunMode runMode, CharsetEncoder encoder, int integersCounter, int longsCounter, String ... strings) {
        assert (encoder != null || strings.length == 0);
        int lengthOfMetadata = 1 + this.getEncodedMagicNumber().length + 1 + 1 + 1 + opcodeLength + 1;
        lengthOfMetadata += 2 + (runMode == null ? 0 : runMode.getRunmodeBinary().length) + 1;
        if (encoder != null) {
            lengthOfMetadata += 2 + encoder.charset().name().length() + 1;
        }
        int lengthOfData = 6 * integersCounter;
        lengthOfData += 10 * longsCounter;
        for (String string : strings) {
            String s = AbstractStreamEncoder.nonNull(string);
            lengthOfData += 5 + (int)Math.ceil(encoder.maxBytesPerChar() * (float)s.length()) + 1;
        }
        return lengthOfMetadata + lengthOfData;
    }

    private static String nonNull(String msg) {
        return msg == null ? "\u0000" : msg;
    }
}

