/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.api.util;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class RunOrder {
    public static final RunOrder ALPHABETICAL = new RunOrder("alphabetical");
    public static final RunOrder FILESYSTEM = new RunOrder("filesystem");
    public static final RunOrder HOURLY = new RunOrder("hourly");
    public static final RunOrder RANDOM = new RunOrder("random");
    public static final RunOrder REVERSE_ALPHABETICAL = new RunOrder("reversealphabetical");
    public static final RunOrder BALANCED = new RunOrder("balanced");
    public static final RunOrder FAILEDFIRST = new RunOrder("failedfirst");
    public static final RunOrder[] DEFAULT = new RunOrder[]{FILESYSTEM};
    private final String name;

    public static RunOrder[] valueOfMulti(String values) {
        ArrayList<RunOrder> result = new ArrayList<RunOrder>();
        if (values != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(values, ",");
            while (stringTokenizer.hasMoreTokens()) {
                result.add(RunOrder.valueOf(stringTokenizer.nextToken()));
            }
        }
        return result.toArray(new RunOrder[result.size()]);
    }

    public static RunOrder valueOf(String name) {
        RunOrder[] runOrders;
        if (name == null) {
            return null;
        }
        for (RunOrder runOrder : runOrders = RunOrder.values()) {
            if (!runOrder.matches(name)) continue;
            return runOrder;
        }
        String errorMessage = RunOrder.createMessageForMissingRunOrder(name);
        throw new IllegalArgumentException(errorMessage);
    }

    private static String createMessageForMissingRunOrder(String name) {
        RunOrder[] runOrders = RunOrder.values();
        StringBuilder message = new StringBuilder("There's no RunOrder with the name ");
        message.append(name);
        message.append(". Please use one of the following RunOrders: ");
        for (int i2 = 0; i2 < runOrders.length; ++i2) {
            if (i2 != 0) {
                message.append(", ");
            }
            message.append(runOrders[i2]);
        }
        message.append('.');
        return message.toString();
    }

    private static RunOrder[] values() {
        return new RunOrder[]{ALPHABETICAL, FILESYSTEM, HOURLY, RANDOM, REVERSE_ALPHABETICAL, BALANCED, FAILEDFIRST};
    }

    public static String asString(RunOrder[] runOrder) {
        StringBuilder stringBuffer = new StringBuilder();
        for (int i2 = 0; i2 < runOrder.length; ++i2) {
            stringBuffer.append(runOrder[i2].name);
            if (i2 >= runOrder.length - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private RunOrder(String name) {
        this.name = name;
    }

    private boolean matches(String anotherName) {
        return this.name.equalsIgnoreCase(anotherName);
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

