/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.classworlds.uberjar.protocol.jar;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.codehaus.classworlds.UrlUtils;

public class JarUrlConnection
extends JarURLConnection {
    private URL baseResource;
    private String[] segments;
    private InputStream in;

    JarUrlConnection(URL url) throws IOException {
        url = JarUrlConnection.normaliseURL(url);
        super(url);
        String baseText = url.getPath();
        int bangLoc = baseText.indexOf("!");
        String baseResourceText = baseText.substring(0, bangLoc);
        String extraText = "";
        if (bangLoc <= baseText.length() - 2 && baseText.charAt(bangLoc + 1) == '/') {
            extraText = bangLoc + 2 == baseText.length() ? "" : baseText.substring(bangLoc + 1);
        } else {
            throw new MalformedURLException("No !/ in url: " + url.toExternalForm());
        }
        ArrayList<String> segments = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(extraText, "!");
        while (tokens.hasMoreTokens()) {
            segments.add(tokens.nextToken());
        }
        this.segments = segments.toArray(new String[segments.size()]);
        this.baseResource = new URL(baseResourceText);
    }

    protected static URL normaliseURL(URL url) throws MalformedURLException {
        String text = UrlUtils.normalizeUrlPath(url.toString());
        if (!text.startsWith("jar:")) {
            text = "jar:" + text;
        }
        if (text.indexOf(33) < 0) {
            text = text + "!/";
        }
        return new URL(text);
    }

    protected String[] getSegments() {
        return this.segments;
    }

    protected URL getBaseResource() {
        return this.baseResource;
    }

    public void connect() throws IOException {
        if (this.segments.length == 0) {
            this.setupBaseResourceInputStream();
        } else {
            this.setupPathedInputStream();
        }
    }

    protected void setupBaseResourceInputStream() throws IOException {
        this.in = this.getBaseResource().openStream();
    }

    protected void setupPathedInputStream() throws IOException {
        InputStream curIn = this.getBaseResource().openStream();
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            curIn = this.getSegmentInputStream(curIn, this.segments[i2]);
        }
        this.in = curIn;
    }

    protected InputStream getSegmentInputStream(InputStream baseIn, String segment) throws IOException {
        JarInputStream jarIn = new JarInputStream(baseIn);
        JarEntry entry = null;
        while (jarIn.available() != 0 && (entry = jarIn.getNextJarEntry()) != null) {
            if (!("/" + entry.getName()).equals(segment)) continue;
            return jarIn;
        }
        throw new IOException("unable to locate segment: " + segment);
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.connect();
        }
        return this.in;
    }

    public JarFile getJarFile() throws IOException {
        String url = this.baseResource.toExternalForm();
        if (url.startsWith("file:/")) {
            url = url.substring(6);
        }
        return new JarFile(URLDecoder.decode(url, "UTF-8"));
    }
}

