/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.nio.ByteBuffer;
import selogger.com.fasterxml.jackson.core.JsonParser;
import selogger.com.fasterxml.jackson.databind.DeserializationContext;
import selogger.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import selogger.com.fasterxml.jackson.databind.type.LogicalType;
import selogger.com.fasterxml.jackson.databind.util.ByteBufferBackedOutputStream;

public class ByteBufferDeserializer
extends StdScalarDeserializer<ByteBuffer> {
    private static final long serialVersionUID = 1L;

    protected ByteBufferDeserializer() {
        super(ByteBuffer.class);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Binary;
    }

    @Override
    public ByteBuffer deserialize(JsonParser parser, DeserializationContext cx) throws IOException {
        byte[] b = parser.getBinaryValue();
        return ByteBuffer.wrap(b);
    }

    @Override
    public ByteBuffer deserialize(JsonParser jp, DeserializationContext ctxt, ByteBuffer intoValue) throws IOException {
        ByteBufferBackedOutputStream out = new ByteBufferBackedOutputStream(intoValue);
        jp.readBinaryValue(ctxt.getBase64Variant(), out);
        out.close();
        return intoValue;
    }
}

