/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.fasterxml.jackson.module.blackbird.deser;

import java.io.IOException;
import java.util.function.BiConsumer;
import selogger.com.fasterxml.jackson.core.JsonParser;
import selogger.com.fasterxml.jackson.core.JsonToken;
import selogger.com.fasterxml.jackson.databind.DeserializationContext;
import selogger.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import selogger.com.fasterxml.jackson.module.blackbird.deser.OptimizedSettableBeanProperty;

final class SettableStringProperty
extends OptimizedSettableBeanProperty<SettableStringProperty> {
    private static final long serialVersionUID = 1L;
    private final BiConsumer<Object, String> _optimizedSetter;

    public SettableStringProperty(SettableBeanProperty src, BiConsumer<Object, String> optimizedSetter) {
        super(src);
        this._optimizedSetter = optimizedSetter;
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableStringProperty(del, this._optimizedSetter);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean) throws IOException {
        if (!p.hasToken(JsonToken.VALUE_STRING)) {
            this.delegate.deserializeAndSet(p, ctxt, bean);
            return;
        }
        this.set(bean, p.getText());
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return this.setAndReturn(instance, p.getText());
        }
        return this.delegate.deserializeSetAndReturn(p, ctxt, instance);
    }

    @Override
    public void set(Object bean, Object value) throws IOException {
        try {
            this._optimizedSetter.accept(bean, (String)value);
        }
        catch (Throwable e) {
            this._reportProblem(bean, value, e);
        }
    }
}

