/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.fasterxml.jackson.module.blackbird.ser;

import java.util.function.ToIntFunction;
import selogger.com.fasterxml.jackson.core.JsonGenerator;
import selogger.com.fasterxml.jackson.databind.JsonSerializer;
import selogger.com.fasterxml.jackson.databind.PropertyName;
import selogger.com.fasterxml.jackson.databind.SerializerProvider;
import selogger.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import selogger.com.fasterxml.jackson.module.blackbird.ser.OptimizedBeanPropertyWriter;

final class IntPropertyWriter
extends OptimizedBeanPropertyWriter<IntPropertyWriter> {
    private static final long serialVersionUID = 1L;
    private final int _suppressableInt;
    private final boolean _suppressableIntSet;
    private final ToIntFunction<Object> _acc;

    public IntPropertyWriter(BeanPropertyWriter src, ToIntFunction<Object> acc, JsonSerializer<Object> ser) {
        super(src, ser);
        this._acc = acc;
        if (this._suppressableValue instanceof Integer) {
            this._suppressableInt = (Integer)this._suppressableValue;
            this._suppressableIntSet = true;
        } else {
            this._suppressableInt = 0;
            this._suppressableIntSet = false;
        }
    }

    protected IntPropertyWriter(IntPropertyWriter base, PropertyName name) {
        super(base, name);
        this._suppressableInt = base._suppressableInt;
        this._suppressableIntSet = base._suppressableIntSet;
        this._acc = base._acc;
    }

    @Override
    protected BeanPropertyWriter _new(PropertyName newName) {
        return new IntPropertyWriter(this, newName);
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new IntPropertyWriter(this, this._acc, ser);
    }

    @Override
    public final void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        int value;
        if (this.broken) {
            this.fallbackWriter.serializeAsField(bean, gen, prov);
            return;
        }
        try {
            value = this._acc.applyAsInt(bean);
        }
        catch (Throwable t) {
            this._handleProblem(bean, gen, prov, t, false);
            return;
        }
        if (!this._suppressableIntSet || this._suppressableInt != value) {
            gen.writeFieldName(this._fastName);
            gen.writeNumber(value);
        }
    }

    @Override
    public final void serializeAsElement(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        int value;
        if (this.broken) {
            this.fallbackWriter.serializeAsElement(bean, gen, prov);
            return;
        }
        try {
            value = this._acc.applyAsInt(bean);
        }
        catch (Throwable t) {
            this._handleProblem(bean, gen, prov, t, true);
            return;
        }
        if (!this._suppressableIntSet || this._suppressableInt != value) {
            gen.writeNumber(value);
        } else {
            this.serializeAsPlaceholder(bean, gen, prov);
        }
    }
}

