/*
 * Decompiled with CFR 0.152.
 */
package software.fitz.jackson.module.force;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;
import selogger.com.fasterxml.jackson.databind.DeserializationContext;
import selogger.com.fasterxml.jackson.databind.deser.ValueInstantiator;

class ForceValueInstantiator
extends ValueInstantiator {
    private static final Objenesis OBJENESIS = new ObjenesisStd();
    private static final ConcurrentMap<Class<?>, ForceValueInstantiator> INSTANTIATOR_CACHE = new ConcurrentHashMap();
    private Class<?> type;

    private ForceValueInstantiator(Class<?> type) {
        this.type = type;
    }

    public static ForceValueInstantiator getInstance(Class<?> type) {
        ForceValueInstantiator instantiator = INSTANTIATOR_CACHE.putIfAbsent(type, new ForceValueInstantiator(type));
        if (instantiator == null) {
            return (ForceValueInstantiator)INSTANTIATOR_CACHE.get(type);
        }
        return instantiator;
    }

    @Override
    public boolean canCreateUsingDefault() {
        return true;
    }

    @Override
    public Object createUsingDefault(DeserializationContext ctxt) throws IOException {
        return OBJENESIS.newInstance(this.type);
    }
}

