/*
 * Decompiled with CFR 0.152.
 */
package com.pano.coco.impl;

import com.pano.coco.api.IVideoFrameFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import video.pano.CapturerObserver;
import video.pano.VideoFrame;

public class CocoNativeCapturerObserver
implements CapturerObserver {
    private final long nativeSource;
    private final String deviceName;
    private static final Map<String, IVideoFrameFilter> videoFrameFilterMap = new HashMap<String, IVideoFrameFilter>();
    private static final Object filterMapLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFilter(IVideoFrameFilter frameFilter, String deviceName) {
        Object object = filterMapLock;
        synchronized (object) {
            Collection<IVideoFrameFilter> collection = videoFrameFilterMap.values();
            while (collection.contains(frameFilter)) {
                collection.remove(frameFilter);
            }
            if (deviceName != null) {
                videoFrameFilterMap.remove(deviceName);
                if (frameFilter != null) {
                    videoFrameFilterMap.put(deviceName, frameFilter);
                }
            }
        }
    }

    public CocoNativeCapturerObserver(long nativeSource) {
        this.nativeSource = nativeSource;
        this.deviceName = CocoNativeCapturerObserver.nativeGetDeviceName(nativeSource);
    }

    public void onCapturerStarted(boolean success) {
        CocoNativeCapturerObserver.nativeCapturerStarted(this.nativeSource, success);
    }

    public void onCapturerStopped() {
        CocoNativeCapturerObserver.nativeCapturerStopped(this.nativeSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameCaptured(VideoFrame frame) {
        IVideoFrameFilter filter;
        Object object = filterMapLock;
        synchronized (object) {
            filter = videoFrameFilterMap.get(this.deviceName);
        }
        if (filter != null) {
            filter.onVideoFrameFilter(frame);
        }
        CocoNativeCapturerObserver.nativeOnFrameCaptured(this.nativeSource, frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), frame.getRotation(), frame.getTimestampNs(), frame.getBuffer());
    }

    private static native void nativeCapturerStarted(long var0, boolean var2);

    private static native void nativeCapturerStopped(long var0);

    private static native void nativeOnFrameCaptured(long var0, int var2, int var3, int var4, long var5, VideoFrame.Buffer var7);

    private static native String nativeGetDeviceName(long var0);
}

