/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.api;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.ui.PlayerControlView;
import com.google.android.exoplayer2.video.VideoListener;
import video.pano.rtc.impl.PLogger;

public class PanoExoPlayerView
extends FrameLayout
implements SurfaceHolder.Callback,
VideoListener,
Player.EventListener {
    private static final String TAG = "PanoExoPlayerView";
    private long mNativeHandle;
    private String mShapeId;
    private final SurfaceView mSurfaceView;
    private final PlayerControlView mController;
    private int mVideoWidth = 0;
    private int mVideoHeight = 0;
    private int mSyncTS = 0;
    private static final int SHOW_CONTROLLER = 1;
    private static final int HIDE_CONTROLLER = 2;
    private static final int UPDATE_PROGRESS = 3;
    private Handler mHandler = new Handler(Looper.myLooper()){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (PanoExoPlayerView.this.mPlayer == null) break;
                    PanoExoPlayerView.this.updateTime();
                    if (!PanoExoPlayerView.this.mPlayer.getPlayWhenReady()) break;
                    PanoExoPlayerView.this.mHandler.sendEmptyMessageDelayed(3, 3000L);
                }
            }
        }
    };
    private SimpleExoPlayer mPlayer;
    private String mMediaUrl = "";
    private boolean mIsPlay = false;
    private static final int kDefaultPlayReseekInterval = 3000;

    public PanoExoPlayerView(Context context) {
        super(context);
        this.mSurfaceView = new SurfaceView(context);
        this.mSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)this);
        FrameLayout.LayoutParams svParams = new FrameLayout.LayoutParams(-1, -1);
        svParams.gravity = 17;
        this.addView((View)this.mSurfaceView, (ViewGroup.LayoutParams)svParams);
        this.mController = new PlayerControlView(context);
        FrameLayout.LayoutParams ctParams = new FrameLayout.LayoutParams(-1, -1);
        this.addView((View)this.mController, (ViewGroup.LayoutParams)ctParams);
        this.initPlayer(context);
    }

    public PanoExoPlayerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mSurfaceView = new SurfaceView(context, attrs);
        this.mSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)this);
        FrameLayout.LayoutParams svParams = new FrameLayout.LayoutParams(-1, -1);
        svParams.gravity = 17;
        this.addView((View)this.mSurfaceView, (ViewGroup.LayoutParams)svParams);
        this.mController = new PlayerControlView(context);
        FrameLayout.LayoutParams ctParams = new FrameLayout.LayoutParams(-1, -1);
        this.addView((View)this.mController, (ViewGroup.LayoutParams)ctParams);
        this.initPlayer(context);
    }

    private void initPlayer(Context context) {
        PLogger.i(TAG, "initPlayer " + (Object)((Object)this));
        this.mPlayer = new SimpleExoPlayer.Builder(context).build();
        this.mPlayer.setVideoScalingMode(1);
        this.mController.setPlayer((Player)this.mPlayer);
        this.mPlayer.addListener((Player.EventListener)this);
        this.mPlayer.addVideoListener((VideoListener)this);
    }

    public void close() {
        PLogger.i(TAG, "close");
        this.mNativeHandle = 0L;
        if (this.mPlayer != null) {
            this.mPlayer.stop();
            this.mPlayer.release();
            this.mPlayer = null;
        }
    }

    public void stopPlay() {
        PLogger.i(TAG, "stopPlay");
        this.mHandler.removeMessages(3);
        if (this.mPlayer != null && this.mPlayer.getPlayWhenReady()) {
            this.mPlayer.stop();
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        PLogger.i(TAG, "surfaceChanged " + w + "," + h);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        PLogger.i(TAG, "surfaceCreated");
        if (this.mPlayer != null) {
            this.mPlayer.setVideoSurfaceView(this.mSurfaceView);
        }
        this.mSurfaceView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                PLogger.i(PanoExoPlayerView.TAG, "onTouch");
                if (PanoExoPlayerView.this.mController != null) {
                    PanoExoPlayerView.this.mController.show();
                }
                return false;
            }
        });
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        PLogger.i(TAG, "surfaceDestroyed");
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mNativeHandle = 0L;
        this.stopPlay();
        if (this.mPlayer != null) {
            this.mPlayer.release();
            this.mPlayer = null;
        }
    }

    public void onTimelineChanged(Timeline timeline, int reason) {
        PLogger.i(TAG, "onTimelineChanged " + reason);
    }

    public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
        PLogger.i(TAG, "onPlayWhenReadyChanged " + playWhenReady + "," + reason);
        if (playWhenReady) {
            this.mHandler.sendEmptyMessage(3);
        }
        this.syncPlayerStatus(this.mPlayer.getCurrentPosition());
    }

    public void onPlaybackStateChanged(int state) {
        boolean p;
        PLogger.i(TAG, "onPlaybackStateChanged " + state);
        if (3 == state && (p = this.mPlayer.getPlayWhenReady()) != this.mIsPlay) {
            PLogger.i(TAG, "onPlayerStateChanged set Play");
            this.mPlayer.setPlayWhenReady(p);
        }
        if (4 == state) {
            this.mIsPlay = false;
            this.mPlayer.setPlayWhenReady(false);
            this.syncPlayerStatus(this.mPlayer.getCurrentPosition());
        }
    }

    public void onRepeatModeChanged(int i) {
        PLogger.i(TAG, "onRepeatModeChanged " + i);
    }

    public void onPlayerError(ExoPlaybackException e) {
        PLogger.i(TAG, "onPlayerError ");
        e.printStackTrace();
        PanoExoPlayerView.onPlayerError(this.mNativeHandle, this.mShapeId, this.mMediaUrl, e.getMessage());
    }

    public void onPositionDiscontinuity(int i) {
        PLogger.i(TAG, "onPositionDiscontinuity " + i);
    }

    public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
        PLogger.i(TAG, "onVideoSizeChanged " + width + "," + height);
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        this.post(this::updateSurfaceViewSize);
    }

    public void onRenderedFirstFrame() {
        PLogger.i(TAG, "onRenderedFirstFrame");
    }

    public void setShapeId(String shapeId) {
        this.mShapeId = shapeId;
    }

    public String getShapeId() {
        return this.mShapeId;
    }

    public void setNativeHandle(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public void setMediaUrl(String url) {
        this.mMediaUrl = url;
        MediaItem mediaItem = MediaItem.fromUri((String)this.mMediaUrl);
        this.mPlayer.setMediaItem(mediaItem);
        this.mPlayer.prepare();
    }

    private void updateTime() {
        this.syncPlayerStatus(this.mPlayer.getCurrentPosition());
    }

    public void updatePlayerStatus(boolean isPlay, float playTS, boolean isRepeat) {
        PLogger.i(TAG, "updatePlayerStatus " + isPlay + ", ts:" + playTS + ", " + isRepeat);
        this.mIsPlay = isPlay;
        if (!this.mPlayer.getPlayWhenReady() && this.mIsPlay) {
            this.mPlayer.setPlayWhenReady(true);
            PLogger.i(TAG, "updatePlayerStatus start play");
        }
        if (this.mPlayer.getPlayWhenReady() && !this.mIsPlay) {
            this.mPlayer.setPlayWhenReady(false);
            PLogger.i(TAG, "updatePlayerStatus stop play");
        }
        this.mSyncTS = (int)(playTS * 1000.0f);
        if (this.needSeekToTS(this.mSyncTS, isPlay)) {
            this.mPlayer.seekTo((long)this.mSyncTS);
        }
        this.mPlayer.setRepeatMode(isRepeat ? 1 : 0);
    }

    public void updateSize() {
        this.updateSurfaceViewSize();
    }

    private boolean needSeekToTS(int playTS, boolean isPlay) {
        long curTS = this.mPlayer.getCurrentPosition();
        if (isPlay) {
            return curTS < (long)(playTS - 3000) || curTS > (long)(playTS + 3000);
        }
        return true;
    }

    private void syncPlayerStatus(long playTS) {
        if (!this.mPlayer.getPlayWhenReady() && !this.mIsPlay) {
            return;
        }
        this.mIsPlay = this.mPlayer.getPlayWhenReady();
        if (this.mNativeHandle != 0L) {
            PanoExoPlayerView.onSyncPlayerStatus(this.mNativeHandle, this.mShapeId, this.mIsPlay, (float)playTS / 1000.0f, this.mPlayer.getRepeatMode() == 1);
        }
    }

    private void updateSurfaceViewSize() {
        if (this.mVideoWidth == 0 || this.mVideoHeight == 0) {
            return;
        }
        int viewWidth = this.getWidth();
        int viewHeight = this.getHeight();
        if (this.mVideoWidth * viewHeight > this.mVideoHeight * viewWidth) {
            viewHeight = this.mVideoHeight * viewWidth / this.mVideoWidth;
        } else {
            viewWidth = this.mVideoWidth * viewHeight / this.mVideoHeight;
        }
        ViewGroup.LayoutParams params = this.mSurfaceView.getLayoutParams();
        if (params instanceof FrameLayout.LayoutParams) {
            params.width = viewWidth;
            params.height = viewHeight;
        }
        this.mSurfaceView.setLayoutParams(params);
    }

    public static native void onSyncPlayerStatus(long var0, String var2, boolean var3, float var4, boolean var5);

    public static native void onPlayerError(long var0, String var2, String var3, String var4);
}

