/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.api;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.view.View;
import com.pano.rtc.R;
import java.util.Map;
import video.pano.rtc.impl.GlobalRef;

public class PanoLabelView
extends View {
    private static final String TAG = "PanoLabelView";
    private static final int kLabelOffset = -32;
    private static final int kRoundRadius = 2;
    private static final int kLabelTextSize = 24;
    private Drawable selectDrawable;
    private Drawable eraseDrawable;
    private Drawable pencilDrawable;
    private Drawable plusDrawable;
    private Drawable textDrawable;
    private final Paint paint = new Paint();
    private final RectF rect = new RectF();
    private ArrayMap<String, CursorInfo> mCursorMap = new ArrayMap();

    public PanoLabelView(Context context) {
        this(context, null);
    }

    public PanoLabelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.loadDrawable();
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setTextSize(24.0f);
    }

    public void addCursor(String labelId, String name) {
        CursorInfo info = (CursorInfo)this.mCursorMap.get((Object)labelId);
        if (info == null) {
            CursorInfo cursor = new CursorInfo();
            cursor.name = name;
            this.mCursorMap.put((Object)labelId, (Object)cursor);
        }
    }

    public void removeCursor(String labelId) {
        this.mCursorMap.remove((Object)labelId);
        this.invalidate();
    }

    public void updateCursor(String labelId, float x, float y, int color, int type) {
        CursorInfo info = (CursorInfo)this.mCursorMap.get((Object)labelId);
        if (info != null) {
            info.x = x;
            info.y = y;
            info.color = color;
            info.type = type;
            this.mCursorMap.put((Object)labelId, (Object)info);
            this.invalidate();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (Map.Entry entry : this.mCursorMap.entrySet()) {
            CursorInfo info = (CursorInfo)entry.getValue();
            float ty = info.y + -32.0f;
            this.drawIcon(canvas, info.type, (int)info.x, (int)info.y);
            float tw = this.paint.measureText(info.name) + 6.0f;
            this.paint.setColor(info.color);
            if (Build.VERSION.SDK_INT >= 21) {
                canvas.drawRoundRect(info.x, ty, info.x + tw, ty - 30.0f, 2.0f, 2.0f, this.paint);
            } else {
                this.rect.set(info.x, ty, info.x + tw, ty - 30.0f);
                canvas.drawRoundRect(this.rect, 2.0f, 2.0f, this.paint);
            }
            this.paint.setColor(-1);
            canvas.drawText(info.name, info.x + 3.0f, ty - 3.0f, this.paint);
        }
    }

    private void loadDrawable() {
        this.selectDrawable = GlobalRef.applicationContext.getResources().getDrawable(R.drawable.select);
        this.eraseDrawable = GlobalRef.applicationContext.getResources().getDrawable(R.drawable.eraser);
        this.pencilDrawable = GlobalRef.applicationContext.getResources().getDrawable(R.drawable.pencil);
        this.plusDrawable = GlobalRef.applicationContext.getResources().getDrawable(R.drawable.plus);
        this.textDrawable = GlobalRef.applicationContext.getResources().getDrawable(R.drawable.text);
    }

    private void drawIcon(Canvas canvas, int type, int x, int y) {
        if (type == 0) {
            this.pencilDrawable.setBounds(x, y - 16, x + 16, y);
            this.pencilDrawable.draw(canvas);
        } else if (type == 1) {
            this.selectDrawable.setBounds(x, y, x + 16, y + 16);
            this.selectDrawable.draw(canvas);
        } else if (type == 2) {
            this.eraseDrawable.setBounds(x, y - 16, x + 16, y);
            this.eraseDrawable.draw(canvas);
        } else if (type == 3) {
            this.textDrawable.setBounds(x, y, x + 16, y + 16);
            this.textDrawable.draw(canvas);
        } else if (type == 4) {
            this.plusDrawable.setBounds(x - 8, y - 8, x + 16, y + 16);
            this.plusDrawable.draw(canvas);
        }
    }

    static class CursorInfo {
        String name;
        int type;
        int color;
        float x;
        float y;

        CursorInfo() {
        }
    }
}

