/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.api;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.pano.rtc.impl.PanoCoursePageFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import video.pano.rtc.impl.PLogger;

public class PanoWebView
extends WebView {
    private static final String TAG = "PanoWebView";
    private long mNativeHandle;
    private float mScale = 1.0f;
    private float mTranslateX = 0.0f;
    private float mTranslateY = 0.0f;
    private String mPageId;

    public PanoWebView(Context context) {
        this(context, null);
    }

    public PanoWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void init() {
        WebSettings webSettings = this.getSettings();
        webSettings.setSupportZoom(false);
        int textZoom = webSettings.getTextZoom();
        if (textZoom != 100) {
            webSettings.setTextZoom(100);
        }
        webSettings.setAllowFileAccessFromFileURLs(true);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setBuiltInZoomControls(false);
        webSettings.setPluginState(WebSettings.PluginState.ON);
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setDefaultTextEncodingName("utf-8");
        webSettings.setMediaPlaybackRequiresUserGesture(false);
        webSettings.setSavePassword(false);
        webSettings.setAllowFileAccess(true);
        webSettings.setAppCacheEnabled(false);
        webSettings.setCacheMode(2);
        webSettings.setDomStorageEnabled(true);
        webSettings.setDatabaseEnabled(false);
        this.setWebChromeClient(new WebChromeClient());
        this.setWebViewClient(new PanoWebViewClient());
        this.removeJavascriptInterface("searchBoxJavaBridge_");
        this.removeJavascriptInterface("accessibility");
        this.removeJavascriptInterface("accessibilityTraversal");
        this.addJavascriptInterface((Object)this, "android");
    }

    public void setPageId(String pageId) {
        this.mPageId = pageId;
    }

    public String getPageId() {
        return this.mPageId;
    }

    @JavascriptInterface
    public void resize(float height) {
        this.post(() -> {
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            layoutParams.height = (int)(height + 0.5f);
            this.setLayoutParams(layoutParams);
        });
    }

    public void setNativeHandle(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public void close() {
        this.clearCache(true);
        this.clearHistory();
        this.destroy();
    }

    public void scaleAtPoint(float scale, float pivotX, float pivotY) {
        this.setPivotX(0.0f);
        this.setPivotY(0.0f);
        this.setScaleX(scale);
        this.setScaleY(scale);
        this.setTranslationX(-pivotX);
        this.setTranslationY(-pivotY);
        this.mScale = scale;
        this.mTranslateX = -pivotX;
        this.mTranslateY = -pivotY;
    }

    public void move(float tx, float ty) {
        this.setTranslationX(tx);
        this.setTranslationY(ty);
        this.mTranslateX = tx;
        this.mTranslateY = ty;
    }

    public void snapshot(String filePath, boolean viewArea, int contentW, int contentH) {
        int viewWidth = this.getWidth();
        int viewHeight = this.getHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)viewWidth, (int)viewHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        this.draw(canvas);
        int cropY = 0;
        int cropX = 0;
        int cropW = viewWidth;
        int cropH = viewHeight;
        if (!viewArea) {
            if (contentW * viewHeight > contentH * viewWidth) {
                cropH = viewWidth * contentH / contentW;
                cropY = (viewHeight - cropH) / 2;
            } else {
                cropW = viewHeight * contentW / contentH;
                cropX = (viewWidth - cropW) / 2;
            }
        } else {
            cropX = (int)(-this.mTranslateX / this.mScale);
            cropY = (int)(-this.mTranslateY / this.mScale);
            cropW = (int)((float)viewWidth / this.mScale);
            cropH = (int)((float)viewHeight / this.mScale);
        }
        Bitmap ssBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)cropX, (int)cropY, (int)cropW, (int)cropH);
        try {
            File file = new File(filePath);
            ssBitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)new FileOutputStream(file));
            PanoCoursePageFactory.onSnapshotComplete(this.mNativeHandle, this.mPageId, filePath);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private class PanoWebViewClient
    extends WebViewClient {
        private PanoWebViewClient() {
        }

        public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
            try {
                String urlDecode = new String(url.getBytes(), "UTF-8");
                urlDecode = URLDecoder.decode(urlDecode, "UTF-8");
                if (PanoWebView.this.mNativeHandle != 0L) {
                    PanoCoursePageFactory.onUrlChange(PanoWebView.this.mNativeHandle, PanoWebView.this.mPageId, urlDecode);
                }
            }
            catch (UnsupportedEncodingException e) {
                PLogger.e(PanoWebView.TAG, "decode url(" + url + ") err : " + e.getMessage());
            }
            return super.shouldInterceptRequest(view, url);
        }

        public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
            return super.shouldInterceptRequest(view, request);
        }

        public void onPageFinished(WebView view, String url) {
        }
    }
}

