/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import android.view.View;
import com.pano.rtc.api.Constants;
import com.pano.rtc.api.PanoAnnotation;
import com.pano.rtc.api.RtcWbView;
import video.pano.rtc.impl.GestureHandler;
import video.pano.rtc.impl.GlobalRef;
import video.pano.rtc.impl.whiteboard.AnnoNative;
import video.pano.rtc.impl.whiteboard.PanoAnnoCallbackImpl;
import video.pano.rtc.impl.whiteboard.RtcWbDrawer;

public class PanoAnnotationImpl
implements PanoAnnotation,
PanoAnnoCallbackImpl {
    private static final String kAnnotationIdPrefix = "pano-annotation-ext-";
    private static final String kVideoAnnotationIdPrefix = "pano-annotation-video-";
    private static final String kShareAnnotationIdPrefix = "pano-annotation-share-";
    private long mNativeHandle;
    private final String mAnnoId;
    private RtcWbView mWbView;
    private RtcWbView.Callback mViewCallback;
    private PanoAnnotation.Callback mAnnoCallback;
    private final RtcWbDrawer mWbDrawer;
    private boolean mEnableDrawer;

    PanoAnnotationImpl(long nativeHandle, String annotationId) {
        this.mNativeHandle = nativeHandle;
        this.mAnnoId = annotationId;
        this.mWbDrawer = new RtcWbDrawer(this.mNativeHandle, this.mAnnoId, new RtcWbDrawer.Callback(){

            @Override
            public void onGestureHandlerAdd(GestureHandler gesHandler) {
                if (PanoAnnotationImpl.this.mWbView != null) {
                    PanoAnnotationImpl.this.mWbView.setRtcTouchListener((v, event) -> gesHandler.handleEvent(event));
                }
            }

            @Override
            public void onGestureHandlerRemove() {
                if (PanoAnnotationImpl.this.mWbView != null) {
                    PanoAnnotationImpl.this.mWbView.setRtcTouchListener(null);
                }
            }

            @Override
            public void onActionBegin() {
            }

            @Override
            public void onActionEnd() {
            }
        });
        this.mEnableDrawer = true;
    }

    @Override
    public Constants.QResult setCallback(PanoAnnotation.Callback callback) {
        this.mAnnoCallback = callback;
        AnnoNative.AnnoSetCallback(this.mNativeHandle, this.mAnnoId, this);
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult setRoleType(Constants.WBRoleType role) {
        int ret = AnnoNative.AnnoSetRoleType(this.mNativeHandle, this.mAnnoId, role.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult startAnnotation(final RtcWbView view) {
        this.mViewCallback = new RtcWbView.Callback(){

            @Override
            public void onViewReady(int w, int h) {
                AnnoNative.AnnoOpen(PanoAnnotationImpl.this.getNativeHandle(), PanoAnnotationImpl.this.mAnnoId, view.getHolder().getSurface());
            }

            @Override
            public void onViewSizeChanged(int w, int h) {
                AnnoNative.AnnoUpdateViewSize(PanoAnnotationImpl.this.getNativeHandle(), PanoAnnotationImpl.this.mAnnoId, w, h);
            }

            @Override
            public void onViewDestroyed() {
                AnnoNative.AnnoClose(PanoAnnotationImpl.this.getNativeHandle(), PanoAnnotationImpl.this.mAnnoId);
            }
        };
        view.addCallback(this.mViewCallback);
        this.mWbView = view;
        this.mWbView.setTransparent(true);
        if (this.mEnableDrawer) {
            this.mWbDrawer.start(GlobalRef.applicationContext, (View)view);
        }
        if (view.isViewReady()) {
            int ret = AnnoNative.AnnoOpen(this.mNativeHandle, this.mAnnoId, view.getHolder().getSurface());
            return Constants.QResult.valueOf(ret);
        }
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult stopAnnotation() {
        if (this.mEnableDrawer) {
            this.mWbDrawer.stop();
        }
        if (this.mWbView != null) {
            this.mWbView.removeCallback(this.mViewCallback);
            this.mViewCallback = null;
            this.mWbView = null;
        }
        if (this.mNativeHandle != 0L) {
            int ret = AnnoNative.AnnoStop(this.mNativeHandle, this.mAnnoId);
            return Constants.QResult.valueOf(ret);
        }
        return Constants.QResult.OK;
    }

    long getNativeHandle() {
        return this.mNativeHandle;
    }

    void destroy() {
        this.mNativeHandle = 0L;
    }

    @Override
    public Constants.QResult setVisible(boolean visible) {
        if (this.mWbView != null) {
            if (visible) {
                this.mWbView.setVisibility(0);
            } else {
                this.mWbView.setVisibility(4);
            }
        }
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult setToolType(Constants.WBToolType type) {
        if (this.mWbView != null) {
            this.mWbView.setPassThrough(type == Constants.WBToolType.None);
        }
        int ret = AnnoNative.AnnoSetToolType(this.mNativeHandle, this.mAnnoId, type.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setLineWidth(int size) {
        int ret = AnnoNative.AnnoSetLineWidth(this.mNativeHandle, this.mAnnoId, size);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setColor(int color) {
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >>> 24) / 255.0f;
        return this.setColor(r, g, b, a);
    }

    @Override
    public Constants.QResult setColor(float r, float g, float b, float a) {
        int ret = AnnoNative.AnnoSetColor(this.mNativeHandle, this.mAnnoId, r, g, b, a);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setFillType(Constants.WBFillType type) {
        int ret = AnnoNative.AnnoSetFillType(this.mNativeHandle, this.mAnnoId, type.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setFillColor(int color) {
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >>> 24) / 255.0f;
        int ret = AnnoNative.AnnoSetFillColor(this.mNativeHandle, this.mAnnoId, r, g, b, a);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setFontStyle(Constants.WBFontStyle style) {
        int ret = AnnoNative.AnnoSetFontStyle(this.mNativeHandle, this.mAnnoId, style.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setFontSize(int size) {
        int ret = AnnoNative.AnnoSetFontSize(this.mNativeHandle, this.mAnnoId, size);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult clearContents() {
        int ret = AnnoNative.AnnoClearContents(this.mNativeHandle, this.mAnnoId);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult clearUserContents(long userId) {
        int ret = AnnoNative.AnnoClearUserContents(this.mNativeHandle, this.mAnnoId, userId);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult undo() {
        int ret = AnnoNative.AnnoUndo(this.mNativeHandle, this.mAnnoId);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult redo() {
        int ret = AnnoNative.AnnoRedo(this.mNativeHandle, this.mAnnoId);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult snapshot(String outputDir) {
        int ret = AnnoNative.AnnoSnapshot(this.mNativeHandle, this.mAnnoId, outputDir);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.WBToolType getToolType() {
        int type = AnnoNative.AnnoGetToolType(this.mNativeHandle, this.mAnnoId);
        return Constants.WBToolType.valueOf(type);
    }

    @Override
    public Constants.QResult setAspectSize(int w, int h) {
        if (!this.mAnnoId.startsWith(kAnnotationIdPrefix)) {
            return Constants.QResult.NotSupported;
        }
        int ret = AnnoNative.AnnoSetAspectSize(this.mNativeHandle, this.mAnnoId, w, h);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setScalingMode(PanoAnnotation.AnnoScalingMode mode) {
        if (!this.mAnnoId.startsWith(kAnnotationIdPrefix)) {
            return Constants.QResult.NotSupported;
        }
        int ret = AnnoNative.AnnoSetScalingMode(this.mNativeHandle, this.mAnnoId, mode.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult enableLocalRender(boolean enable) {
        if (!this.mAnnoId.startsWith(kAnnotationIdPrefix)) {
            return Constants.QResult.NotSupported;
        }
        int ret = AnnoNative.AnnoEnableLocalRender(this.mNativeHandle, this.mAnnoId, enable);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public void onAnnoRoleChanged(int newRole) {
        if (this.mAnnoCallback != null) {
            this.mAnnoCallback.onAnnoRoleChanged(this.ToWBRoleType(newRole));
        }
    }

    @Override
    public void onSnapshotComplete(int result, String filename) {
        if (this.mAnnoCallback != null) {
            Constants.QResult qr = Constants.QResult.valueOf(result);
            this.mAnnoCallback.onSnapshotComplete(qr, filename);
        }
    }

    private Constants.WBRoleType ToWBRoleType(int type) {
        Constants.WBRoleType result = Constants.WBRoleType.Attendee;
        for (Constants.WBRoleType val : Constants.WBRoleType.values()) {
            if (val.getValue() != type) continue;
            result = val;
            break;
        }
        return result;
    }
}

