/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.pano.rtc.api.Constants;
import com.pano.rtc.api.RtcEngine;
import com.pano.rtc.api.RtcRemoteController;
import com.pano.rtc.api.RtcView;
import com.pano.rtc.impl.RtcEngineImpl;
import video.pano.rtc.base.annotation.CalledByNative;
import video.pano.rtc.impl.GlobalRef;
import video.pano.rtc.impl.PLogger;
import video.pano.rtc.remotecontrol.RemoteControlGestureHandler;

class RtcRemoteControllerImpl
implements RtcRemoteController,
RemoteControlGestureHandler.Callback {
    private static final String TAG = "[pano]";
    private long mNativeHandle;
    private RtcRemoteController.Callback mCallback;
    private RemoteControlGestureHandler mGestureHandler;
    private long mRemoteUserId;
    private int mRemoteScreenWidth;
    private int mRemoteScreenHeight;
    private int mAndroidScreenWidth;
    private int mAndroidScreenHeight;
    private RtcView mRemoteScreenView;
    boolean mControlling = false;

    RtcRemoteControllerImpl(long nativeHandle) {
        DisplayMetrics dm = new DisplayMetrics();
        Display display = ((WindowManager)GlobalRef.applicationContext.getSystemService("window")).getDefaultDisplay();
        display.getRealMetrics(dm);
        this.mAndroidScreenWidth = dm.widthPixels;
        this.mAndroidScreenHeight = dm.heightPixels;
        this.mNativeHandle = nativeHandle;
        this.mGestureHandler = new RemoteControlGestureHandler(GlobalRef.applicationContext, this);
    }

    void onUserScreenResolutionChanged(long userId, int width, int height) {
        if (this.mRemoteUserId == 0L || this.mRemoteUserId == userId) {
            this.mRemoteScreenWidth = width;
            this.mRemoteScreenHeight = height;
        }
    }

    void onRemoteScreenRenderChanged(RtcView view) {
        this.mRemoteScreenView = view;
        if (this.mControlling) {
            this.mRemoteScreenView.setRtcTouchListener((v, event) -> this.mGestureHandler.handleEvent(event));
        }
    }

    @Override
    public Constants.QResult setCallback(RtcRemoteController.Callback callback) {
        this.mCallback = callback;
        return Constants.QResult.valueOf(this.setCallback(this.mNativeHandle, this));
    }

    @Override
    public Constants.QResult requestControl(long userId) {
        PLogger.i(TAG, "requestControl, userId : " + userId);
        return Constants.QResult.valueOf(this.requestControl(this.mNativeHandle, userId));
    }

    @Override
    public Constants.QResult acceptControl(long userId) {
        return Constants.QResult.valueOf(this.acceptControl(this.mNativeHandle, userId));
    }

    @Override
    public Constants.QResult rejectControl(long userId) {
        return Constants.QResult.valueOf(this.rejectControl(this.mNativeHandle, userId));
    }

    @Override
    public Constants.QResult setModifierFlags(long userId, int flags) {
        return Constants.QResult.valueOf(this.setModifierFlags(this.mNativeHandle, userId, flags));
    }

    @Override
    public Constants.QResult cancelControl(long userId) {
        this.mControlling = false;
        return Constants.QResult.valueOf(this.cancelControl(this.mNativeHandle, userId));
    }

    @Override
    public Constants.QResult sendKeyboardEvent(long userId, int action, int keyCode) {
        return Constants.QResult.valueOf(this.sendKeyboardEvent(this.mNativeHandle, userId, action, keyCode));
    }

    @CalledByNative
    public void onRemoteControlRequest(long userId) {
        if (this.mCallback != null) {
            this.mCallback.onRemoteControlRequest(userId);
        }
    }

    @CalledByNative
    public void onRemoteControlResponse(long userId, int result) {
        PLogger.i(TAG, "onRemoteControlResponse, userId : " + userId + " result : " + result);
        if (result == Constants.QResult.OK.getValue()) {
            this.mRemoteUserId = userId;
            RtcEngineImpl engineImpl = (RtcEngineImpl)RtcEngine.getInstance();
            this.mRemoteScreenView = engineImpl.getRemoteScreenRenderView();
            if (this.mRemoteScreenView != null) {
                this.mRemoteScreenView.setRtcTouchListener((v, event) -> this.mGestureHandler.handleEvent(event));
            }
            this.mControlling = true;
        }
        if (this.mCallback != null) {
            this.mCallback.onRemoteControlResponse(userId, Constants.QResult.valueOf(result));
        }
    }

    @CalledByNative
    public void onRemoteControlCancelled(long userId, int reason) {
        RtcEngineImpl engineImpl;
        RtcView remoteScreenView;
        PLogger.i(TAG, "onRemoteControlCancelled, userId : " + userId + " reason : " + reason);
        if (this.mCallback != null) {
            this.mCallback.onRemoteControlCancelled(userId, Constants.QResult.valueOf(reason));
        }
        if ((remoteScreenView = (engineImpl = (RtcEngineImpl)RtcEngine.getInstance()).getRemoteScreenRenderView()) != null) {
            remoteScreenView.setRtcTouchListener(null);
        }
        this.mControlling = false;
    }

    @Override
    public void onBegin(float x, float y) {
    }

    @Override
    public void onClicked(float x, float y) {
        this.sendDeltaMouseEvent(this.mNativeHandle, this.mRemoteUserId, 1, 1, 0.0f, 0.0f);
    }

    @Override
    public void onRightClicked(float x, float y) {
        this.sendDeltaMouseEvent(this.mNativeHandle, this.mRemoteUserId, 1, 2, 0.0f, 0.0f);
    }

    @Override
    public void onDoubleClicked(float x, float y) {
        this.sendDeltaMouseEvent(this.mNativeHandle, this.mRemoteUserId, 2, 1, 0.0f, 0.0f);
    }

    @Override
    public void onMove(float x, float y, float dx, float dy, float vx, float vy) {
        if (dx == 0.0f && dy == 0.0f) {
            return;
        }
        this.sendDeltaMouseEvent(this.mNativeHandle, this.mRemoteUserId, 4, 0, dx / (float)this.mAndroidScreenWidth, dy / (float)this.mAndroidScreenHeight);
    }

    @Override
    public void onDrag(float x, float y, float dx, float dy, float vx, float vy) {
        this.sendDeltaMouseEvent(this.mNativeHandle, this.mRemoteUserId, 7, 1, dx / (float)this.mAndroidScreenWidth, dy / (float)this.mAndroidScreenHeight);
    }

    @Override
    public void onScroll(float x, float y, float dx, float dy, float vx, float vy) {
        this.sendDeltaMouseEvent(this.mNativeHandle, this.mRemoteUserId, 5, 4, dx, dy);
    }

    @Override
    public void onScale(float factor, float focusX, float focusY, float spanX, float spanY) {
        this.mRemoteScreenView.setScalingRatioWithFocus(factor, (int)focusX, (int)focusY);
        this.mRemoteScreenView.redrawFrame();
    }

    @Override
    public void onEnd(float x, float y) {
        this.sendDeltaMouseEvent(this.mNativeHandle, this.mRemoteUserId, 15, 0, x / (float)this.mAndroidScreenWidth, y / (float)this.mAndroidScreenHeight);
    }

    @Override
    public void onCancel() {
    }

    private native int setCallback(long var1, Object var3);

    private native int requestControl(long var1, long var3);

    private native int acceptControl(long var1, long var3);

    private native int rejectControl(long var1, long var3);

    private native int cancelControl(long var1, long var3);

    private native int setModifierFlags(long var1, long var3, int var5);

    private native int sendDeltaMouseEvent(long var1, long var3, int var5, int var6, float var7, float var8);

    private native int sendKeyboardEvent(long var1, long var3, int var5, int var6);
}

