/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.video;

import android.opengl.GLES20;
import android.opengl.Matrix;
import android.os.Handler;
import android.os.HandlerThread;
import com.pano.coco.api.IVideoFrameFilter;
import com.pano.rtc.api.Constants;
import com.pano.rtc.api.RtcVideoTextureFilter;
import com.pano.rtc.video.GPUImageExtBrightnessFilter;
import com.pano.rtc.video.GPUImageExtTransformFilter;
import com.pano.rtc.video.GPUImageInput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import video.pano.EglBase;
import video.pano.RendererCommon;
import video.pano.TextureBufferImpl;
import video.pano.ThreadUtils;
import video.pano.VideoFrame;
import video.pano.YuvHelper;
import video.pano.android.gpuimage.util.TextureRotationUtil;
import video.pano.rtc.impl.PLogger;

public class CocoCaptureFrameObserver
implements IVideoFrameFilter {
    private static final String TAG = "CocoCaptureFrameObserver";
    private GPUImageInput mFaceBeautifyFilter;
    private GPUImageExtTransformFilter mInternalTransFilter;
    private GPUImageExtTransformFilter mTransFilterInput;
    private GPUImageExtBrightnessFilter mExtBrightnessInput;
    private GPUImageExtTransformFilter mDummyFilter;
    private final FloatBuffer gLCubeBuffer;
    private final FloatBuffer gLCubeBufferTL;
    private final FloatBuffer gLTextureBuffer;
    public static final float[] CUBE = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
    public static final float[] CUBE_TL = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    private HandlerThread mHandlerThread = null;
    private Handler mEglHandler = null;
    private EglBase mEglBase = null;
    private EglBase.Context mEglSharedContext;
    private final Object mFilterLock = new Object();
    private boolean mNeedRemake = false;
    private boolean mInternalFilterEnabled = false;
    private float mBeautifyLevel = 0.5f;
    private RtcVideoTextureFilter mExternalFilter = null;
    private Constants.TextureType mExternalTextureType = Constants.TextureType.Texture2D;
    private boolean mCopyYuv = false;
    private ByteBuffer mYuvBuffer = null;
    private boolean mDoFaceBeauty = false;
    private boolean mDoBuiltinTransform = false;
    private boolean mDoBrightness = false;
    private float mBrightness = 0.0f;
    private float mdistanceNormalizationFactor = 8.0f;
    private float mXScaling = 1.0f;
    private float mYScaling = 1.0f;
    private float mXRotation = 0.0f;
    private float mYRotation = 0.0f;
    private float mZRotation = 0.0f;
    private float mXProject = 0.0f;
    private float mYProject = 0.0f;
    private float[] resultMat = new float[16];
    private float[] perspectiveMat = new float[16];
    private boolean mMirror = false;
    private float mXTopLeft = 1.0f;
    private float mYTopLeft = 0.0f;
    private float mXTopRight = 0.0f;
    private float mYTopRight = 0.0f;
    private float mXBottomLeft = 1.0f;
    private float mYBottomLeft = 1.0f;
    private float mXBottomRight = 0.0f;
    private float mYBottomRight = 1.0f;
    private float[] mOrigin = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    private boolean anchorTopLeft = false;
    private int mVideoRotation = 270;

    public CocoCaptureFrameObserver(EglBase.Context eglContext) {
        this.mEglSharedContext = eglContext;
        this.gLCubeBuffer = ByteBuffer.allocateDirect(CUBE.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.gLCubeBuffer.put(CUBE).position(0);
        this.gLCubeBufferTL = ByteBuffer.allocateDirect(CUBE_TL.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.gLCubeBufferTL.put(CUBE_TL).position(0);
        this.gLTextureBuffer = ByteBuffer.allocateDirect(TextureRotationUtil.TEXTURE_NO_ROTATION.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.gLTextureBuffer.put(TextureRotationUtil.TEXTURE_NO_ROTATION).position(0);
        Matrix.setIdentityM((float[])this.resultMat, (int)0);
        Matrix.setIdentityM((float[])this.perspectiveMat, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onVideoFrameFilter(VideoFrame videoFrame) {
        if (this.mEglHandler == null) {
            this.mHandlerThread = new HandlerThread("VideoFrameFilterThread");
            this.mHandlerThread.start();
            this.mEglHandler = new Handler(this.mHandlerThread.getLooper());
        }
        VideoFrame.Buffer buffer = videoFrame.getBuffer();
        this.mVideoRotation = videoFrame.getRotation();
        if (buffer instanceof TextureBufferImpl) {
            Object object = this.mFilterLock;
            synchronized (object) {
                byte[] yuv = null;
                if (this.mExternalFilter != null && this.mCopyYuv) {
                    VideoFrame.I420Buffer i420Buffer = buffer.toI420();
                    int uvWidth = (i420Buffer.getWidth() + 1) / 2;
                    int uvHeight = (i420Buffer.getHeight() + 1) / 2;
                    int bufferSize = i420Buffer.getWidth() * i420Buffer.getHeight() + 2 * uvWidth * uvHeight;
                    if (this.mYuvBuffer == null || this.mYuvBuffer.limit() != bufferSize) {
                        this.mYuvBuffer = ByteBuffer.allocateDirect(bufferSize);
                    }
                    YuvHelper.I420Copy((ByteBuffer)i420Buffer.getDataY(), (int)i420Buffer.getStrideY(), (ByteBuffer)i420Buffer.getDataU(), (int)i420Buffer.getStrideU(), (ByteBuffer)i420Buffer.getDataV(), (int)i420Buffer.getStrideV(), (ByteBuffer)this.mYuvBuffer, (int)i420Buffer.getWidth(), (int)i420Buffer.getHeight());
                    yuv = this.mYuvBuffer.array();
                    i420Buffer.release();
                }
                this.internalFilterProcess((TextureBufferImpl)buffer);
                this.externalFilterProcess((TextureBufferImpl)buffer, videoFrame.getRotation(), yuv);
            }
        }
        return true;
    }

    public void release() {
        if (this.mEglHandler != null) {
            this.mEglHandler.post(() -> {
                if (this.mFaceBeautifyFilter != null) {
                    this.mFaceBeautifyFilter.destroy();
                    this.mFaceBeautifyFilter = null;
                }
                if (this.mExternalFilter != null) {
                    this.mExternalFilter.releaseOnGlThread();
                    this.mExternalFilter = null;
                }
                if (this.mExtBrightnessInput != null) {
                    this.mExtBrightnessInput.destroy();
                    this.mExtBrightnessInput = null;
                }
                if (this.mEglBase != null) {
                    this.mEglBase.release();
                    this.mEglBase = null;
                }
                this.mHandlerThread.quit();
            });
            this.mEglHandler = null;
        }
    }

    public void setDoFaceBeauty(boolean enable) {
        this.mDoFaceBeauty = enable;
    }

    public void setDoExtBrightness(boolean enable) {
        this.mDoBrightness = enable;
    }

    public void setDoBuiltinTransform(boolean enable) {
        this.mDoBuiltinTransform = enable;
        if (!this.mDoBuiltinTransform) {
            this.mXScaling = 1.0f;
            this.mYScaling = 1.0f;
            this.mXRotation = 0.0f;
            this.mYRotation = 0.0f;
            this.mZRotation = 0.0f;
            this.mXProject = 0.0f;
            this.mYProject = 0.0f;
            this.mXTopLeft = 1.0f;
            this.mYTopLeft = 0.0f;
            this.mXTopRight = 0.0f;
            this.mYTopRight = 0.0f;
            this.mXBottomLeft = 1.0f;
            this.mYBottomLeft = 1.0f;
            this.mXBottomRight = 0.0f;
            this.mYBottomRight = 1.0f;
        }
        this.calcMatRectToQuad(this.perspectiveMat, this.mOrigin, this.mXTopLeft, this.mYTopLeft, this.mXBottomLeft, this.mYBottomLeft, this.mXTopRight, this.mYTopRight, this.mXBottomRight, this.mYBottomRight);
    }

    public void setBeautifyIntensity(float intensity) {
        float f = intensity > 1.0f ? 1.0f : (this.mBeautifyLevel = intensity < 0.0f ? 0.0f : intensity);
        if (this.mEglHandler != null) {
            this.mEglHandler.post(() -> {
                if (this.mFaceBeautifyFilter != null) {
                    this.mFaceBeautifyFilter.setBeautyLevel(this.mBeautifyLevel);
                }
            });
        }
    }

    public void setBrightness(float brightness) {
        float f = brightness > 1.0f ? 1.0f : (this.mBrightness = brightness < -1.0f ? -1.0f : brightness);
        if (this.mEglHandler != null) {
            this.mEglHandler.post(() -> {
                if (this.mExtBrightnessInput != null) {
                    this.mExtBrightnessInput.setBrightness(this.mBrightness);
                }
            });
        }
    }

    public void setSmoothness(float smoothness) {
        this.mdistanceNormalizationFactor = 1.0f - smoothness;
        if (this.mEglHandler != null) {
            this.mEglHandler.post(() -> {
                if (this.mExtBrightnessInput != null) {
                    this.mExtBrightnessInput.setDistanceNormalizationFactor(this.mdistanceNormalizationFactor);
                }
            });
        }
    }

    public void setBuiltinTransformParameters(boolean reset, float xScaling, float yScaling, float xRot, float yRot, float zRot, float xDepth, float yDepth) {
        if (reset) {
            this.mXScaling = 1.0f;
            this.mYScaling = 1.0f;
            this.mXRotation = 0.0f;
            this.mYRotation = 0.0f;
            this.mZRotation = 0.0f;
            this.mXProject = 0.0f;
            this.mYProject = 0.0f;
        }
        if (xScaling != 0.0f) {
            this.mXScaling *= xScaling;
        }
        if (yScaling != 0.0f) {
            this.mYScaling *= yScaling;
        }
        this.mXRotation += xRot;
        this.mYRotation += yRot;
        this.mZRotation += zRot;
        this.mXProject += xDepth;
        this.mYProject += yDepth;
        this.anchorTopLeft = false;
        if (this.mDoBuiltinTransform) {
            float[] transform = new float[16];
            Matrix.setIdentityM((float[])transform, (int)0);
            Matrix.rotateM((float[])transform, (int)0, (float)(this.mXRotation + 180.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            Matrix.rotateM((float[])transform, (int)0, (float)this.mYRotation, (float)0.0f, (float)1.0f, (float)0.0f);
            Matrix.rotateM((float[])transform, (int)0, (float)this.mZRotation, (float)0.0f, (float)0.0f, (float)1.0f);
            Matrix.scaleM((float[])transform, (int)0, (float)this.mYScaling, (float)this.mXScaling, (float)1.0f);
            float[] perspectiveMat = new float[16];
            Matrix.setIdentityM((float[])perspectiveMat, (int)0);
            perspectiveMat[3] = this.mYProject;
            perspectiveMat[7] = this.mXProject;
            Matrix.multiplyMM((float[])this.resultMat, (int)0, (float[])transform, (int)0, (float[])perspectiveMat, (int)0);
        }
    }

    public void setBuiltinTransformParameters(boolean reset, boolean mirror, float xTopLeft, float yTopLeft, float xTopRight, float yTopRight, float xBottomLeft, float yBottomLeft, float xBottomRight, float yBottomRight) {
        if (reset) {
            this.mXTopLeft = 1.0f;
            this.mYTopLeft = 0.0f;
            this.mXTopRight = 0.0f;
            this.mYTopRight = 0.0f;
            this.mXBottomLeft = 1.0f;
            this.mYBottomLeft = 1.0f;
            this.mXBottomRight = 0.0f;
            this.mYBottomRight = 1.0f;
        }
        this.mMirror = mirror;
        this.anchorTopLeft = true;
        this.changeQuadVertex(xTopLeft, yTopLeft, xTopRight, yTopRight, xBottomLeft, yBottomLeft, xBottomRight, yBottomRight);
        this.calcMatRectToQuad(this.perspectiveMat, this.mOrigin, this.mXTopLeft, this.mYTopLeft, this.mXBottomLeft, this.mYBottomLeft, this.mXTopRight, this.mYTopRight, this.mXBottomRight, this.mYBottomRight);
        if (this.mDoBuiltinTransform) {
            float[] transform = new float[16];
            Matrix.setIdentityM((float[])transform, (int)0);
            Matrix.multiplyMM((float[])this.resultMat, (int)0, (float[])transform, (int)0, (float[])this.perspectiveMat, (int)0);
        }
    }

    private void changeQuadVertex(float xTopLeft, float yTopLeft, float xTopRight, float yTopRight, float xBottomLeft, float yBottomLeft, float xBottomRight, float yBottomRight) {
        switch (this.mVideoRotation) {
            case 0: {
                if (!this.mMirror) {
                    this.mYTopRight += xTopLeft;
                    this.mXTopRight += yTopLeft;
                    this.mYBottomRight += xTopRight;
                    this.mXBottomRight += yTopRight;
                    this.mYBottomLeft += xBottomRight;
                    this.mXBottomLeft += yBottomRight;
                    this.mYTopLeft += xBottomLeft;
                    this.mXTopLeft += yBottomLeft;
                    break;
                }
                this.mYBottomRight -= xTopLeft;
                this.mXBottomRight += yTopLeft;
                this.mYTopRight -= xTopRight;
                this.mXTopRight += yTopRight;
                this.mYTopLeft -= xBottomRight;
                this.mXTopLeft += yBottomRight;
                this.mYBottomLeft -= xBottomLeft;
                this.mXBottomLeft += yBottomLeft;
                break;
            }
            case 90: {
                if (!this.mMirror) {
                    this.mXTopLeft -= xTopLeft;
                    this.mYTopLeft += yTopLeft;
                    this.mXTopRight -= xTopRight;
                    this.mYTopRight += yTopRight;
                    this.mXBottomRight -= xBottomRight;
                    this.mYBottomRight += yBottomRight;
                    this.mXBottomLeft -= xBottomLeft;
                    this.mYBottomLeft += yBottomLeft;
                    break;
                }
                this.mXTopRight += xTopLeft;
                this.mYTopRight += yTopLeft;
                this.mXTopLeft += xTopRight;
                this.mYTopLeft += yTopRight;
                this.mXBottomLeft += xBottomRight;
                this.mYBottomLeft += yBottomRight;
                this.mXBottomRight += xBottomLeft;
                this.mYBottomRight += yBottomLeft;
                break;
            }
            case 180: {
                if (!this.mMirror) {
                    this.mYBottomLeft -= xTopLeft;
                    this.mXBottomLeft -= yTopLeft;
                    this.mYTopLeft -= xTopRight;
                    this.mXTopLeft -= yTopRight;
                    this.mYTopRight -= xBottomRight;
                    this.mXTopRight -= yBottomRight;
                    this.mYBottomRight -= xBottomLeft;
                    this.mXBottomRight -= yBottomLeft;
                    break;
                }
                this.mYTopLeft += xTopLeft;
                this.mXTopLeft -= yTopLeft;
                this.mYBottomLeft += xTopRight;
                this.mXBottomLeft -= yTopRight;
                this.mYBottomRight += xBottomRight;
                this.mXBottomRight -= yBottomRight;
                this.mYTopRight += xBottomLeft;
                this.mXTopRight -= yBottomLeft;
                break;
            }
            case 270: {
                if (!this.mMirror) {
                    this.mXBottomRight += xTopLeft;
                    this.mYBottomRight -= yTopLeft;
                    this.mXBottomLeft += xTopRight;
                    this.mYBottomLeft -= yTopRight;
                    this.mXTopLeft += xBottomRight;
                    this.mYTopLeft -= yBottomRight;
                    this.mXTopRight += xBottomLeft;
                    this.mYTopRight -= yBottomLeft;
                    break;
                }
                this.mXBottomLeft -= xTopLeft;
                this.mYBottomLeft -= yTopLeft;
                this.mXBottomRight -= xTopRight;
                this.mYBottomRight -= yTopRight;
                this.mXTopRight -= xBottomRight;
                this.mYTopRight -= yBottomRight;
                this.mXTopLeft -= xBottomLeft;
                this.mYTopLeft -= yBottomLeft;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constants.QResult enableInternalFilter(boolean enabled) {
        Object object = this.mFilterLock;
        synchronized (object) {
            if (enabled && this.mExternalFilter != null && this.mExternalTextureType == Constants.TextureType.TextureOES) {
                PLogger.e(TAG, "Face beautify open failed. The external video filter is using OES texture");
                return Constants.QResult.InvalidState;
            }
            this.mInternalFilterEnabled = enabled;
            this.mNeedRemake = true;
            return Constants.QResult.OK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constants.QResult setExternalFilter(RtcVideoTextureFilter filter, Constants.TextureType type, boolean withYuv) {
        Object object = this.mFilterLock;
        synchronized (object) {
            if (filter != null && type == Constants.TextureType.TextureOES && this.mInternalFilterEnabled) {
                PLogger.e(TAG, "External video filter set failed. The OES texture is occupied by internal filter.");
                return Constants.QResult.InvalidState;
            }
            if (this.mExternalFilter != null && this.mExternalFilter != filter && this.mEglHandler != null) {
                ThreadUtils.invokeAtFrontUninterruptibly((Handler)this.mEglHandler, () -> {
                    this.mExternalFilter.releaseOnGlThread();
                    this.mExternalFilter = null;
                });
            }
            this.mExternalFilter = filter;
            this.mExternalTextureType = type;
            this.mCopyYuv = withYuv;
            this.mNeedRemake = true;
            return Constants.QResult.OK;
        }
    }

    private void internalFilterProcess(TextureBufferImpl buffer) {
        if (this.mInternalFilterEnabled) {
            ThreadUtils.invokeAtFrontUninterruptibly((Handler)this.mEglHandler, () -> {
                if (this.mEglBase == null) {
                    this.mEglBase = EglBase.create((EglBase.Context)this.mEglSharedContext, (int[])EglBase.CONFIG_PIXEL_BUFFER);
                    this.mEglBase.createDummyPbufferSurface();
                    this.mEglBase.makeCurrent();
                }
                if (this.mNeedRemake) {
                    this.mEglBase.makeCurrent();
                    this.mNeedRemake = false;
                }
                if (this.mDoFaceBeauty) {
                    if (this.mFaceBeautifyFilter == null) {
                        this.mFaceBeautifyFilter = new GPUImageInput(this.LoadVertexShader(), this.LoadFragmentShader(), true);
                        this.mFaceBeautifyFilter.onInit();
                        this.mFaceBeautifyFilter.setBeautyLevel(this.mBeautifyLevel);
                    }
                    this.mFaceBeautifyFilter.onInputSizeChanged(buffer.getWidth(), buffer.getHeight());
                    android.graphics.Matrix finalMatrix = new android.graphics.Matrix(buffer.getTransformMatrix());
                    float[] floatMatrix = RendererCommon.convertMatrixFromAndroidGraphicsMatrix((android.graphics.Matrix)finalMatrix);
                    this.mFaceBeautifyFilter.initGPUImageInputFrameBuffer(buffer.getWidth(), buffer.getHeight());
                    this.mFaceBeautifyFilter.setTextureTransformMatrix(floatMatrix);
                    int textureId = this.mFaceBeautifyFilter.onDrawToTexture(buffer.getTextureId(), this.gLCubeBuffer, this.gLTextureBuffer);
                    if (this.mDoBuiltinTransform) {
                        if (this.mInternalTransFilter == null) {
                            this.mInternalTransFilter = new GPUImageExtTransformFilter(this.LoadTransformVertexShader(), this.LoadTransformFragmentShader());
                            this.mInternalTransFilter.onInit();
                            this.mInternalTransFilter.setIgnoreAspectRatio(this.anchorTopLeft);
                            this.mInternalTransFilter.setAnchorTopLeft(this.anchorTopLeft);
                            this.mInternalTransFilter.initGPUImageInputFrameBuffer(buffer.getWidth(), buffer.getHeight());
                            this.mInternalTransFilter.onOutputSizeChanged(buffer.getWidth(), buffer.getHeight());
                        }
                        this.mInternalTransFilter.setTransform3D(this.resultMat);
                        textureId = this.mInternalTransFilter.onDrawToFBO(textureId, this.anchorTopLeft ? this.gLCubeBufferTL : this.gLCubeBuffer, this.gLTextureBuffer);
                        this.mInternalTransFilter.onOutputSizeChanged(buffer.getWidth(), buffer.getHeight());
                    }
                    buffer.setTextureId(textureId);
                    buffer.setType(VideoFrame.TextureBuffer.Type.RGB);
                } else if (this.mDoBuiltinTransform) {
                    if (this.mTransFilterInput == null) {
                        this.mTransFilterInput = new GPUImageExtTransformFilter(this.LoadTransformVertexShader(), this.LoadTransformOesFragmentShader());
                        this.mTransFilterInput.onInit();
                        this.mTransFilterInput.setIgnoreAspectRatio(this.anchorTopLeft);
                        this.mTransFilterInput.setAnchorTopLeft(this.anchorTopLeft);
                        this.mTransFilterInput.initGPUImageInputFrameBuffer(buffer.getWidth(), buffer.getHeight());
                        this.mTransFilterInput.onOutputSizeChanged(buffer.getWidth(), buffer.getHeight());
                    }
                    this.mTransFilterInput.setTransform3D(this.resultMat);
                    int textureId = this.mTransFilterInput.onDrawToTexture(buffer.getTextureId(), this.anchorTopLeft ? this.gLCubeBufferTL : this.gLCubeBuffer, this.gLTextureBuffer);
                    this.mTransFilterInput.onOutputSizeChanged(buffer.getWidth(), buffer.getHeight());
                    buffer.setTextureId(textureId);
                    buffer.setType(VideoFrame.TextureBuffer.Type.RGB);
                } else if (this.mDoBrightness) {
                    if (this.mExtBrightnessInput == null) {
                        this.mExtBrightnessInput = new GPUImageExtBrightnessFilter(this.LoadExtBrightnessVertexShader(1), this.LoadExtBrightnessOesFragmentShader(1), this.LoadExtBrightnessVertexShader(2), this.LoadExtBrightnessOesFragmentShader(2), true);
                        this.mExtBrightnessInput.onInit();
                        this.mExtBrightnessInput.setBrightness(this.mBrightness);
                        this.mExtBrightnessInput.setDistanceNormalizationFactor(this.mdistanceNormalizationFactor);
                    }
                    android.graphics.Matrix finalMatrix = new android.graphics.Matrix(buffer.getTransformMatrix());
                    float[] floatMatrix = RendererCommon.convertMatrixFromAndroidGraphicsMatrix((android.graphics.Matrix)finalMatrix);
                    this.mExtBrightnessInput.initGPUImageInputFrameBuffer(buffer.getWidth(), buffer.getHeight());
                    this.mExtBrightnessInput.setTextureTransformMatrix(floatMatrix);
                    this.mExtBrightnessInput.onOutputSizeChanged(buffer.getWidth(), buffer.getHeight());
                    int textureId = this.mExtBrightnessInput.onDrawToTexture(buffer.getTextureId(), this.gLCubeBuffer, this.gLTextureBuffer);
                    buffer.setTextureId(textureId);
                    buffer.setType(VideoFrame.TextureBuffer.Type.RGB);
                }
                this.mEglBase.swapBuffers();
            });
        }
    }

    private void externalFilterProcess(TextureBufferImpl buffer, int rotation, byte[] yuv) {
        if (this.mExternalFilter != null) {
            ThreadUtils.invokeAtFrontUninterruptibly((Handler)this.mEglHandler, () -> {
                if (this.mEglBase == null) {
                    this.mEglBase = EglBase.create((EglBase.Context)this.mEglSharedContext, (int[])EglBase.CONFIG_PIXEL_BUFFER);
                    this.mEglBase.createDummyPbufferSurface();
                    this.mEglBase.makeCurrent();
                }
                if (this.mNeedRemake) {
                    this.mEglBase.makeCurrent();
                    this.mNeedRemake = false;
                }
                if (buffer.getType() != VideoFrame.TextureBuffer.Type.RGB && this.mExternalTextureType == Constants.TextureType.Texture2D) {
                    if (this.mDummyFilter == null) {
                        this.mDummyFilter = new GPUImageExtTransformFilter(this.LoadTransformVertexShader(), this.LoadTransformOesFragmentShader());
                        this.mDummyFilter.onInit();
                        this.mDummyFilter.setIgnoreAspectRatio(false);
                        this.mDummyFilter.setAnchorTopLeft(false);
                        this.mDummyFilter.initGPUImageInputFrameBuffer(buffer.getWidth(), buffer.getHeight());
                        float[] transform = new float[16];
                        Matrix.setIdentityM((float[])transform, (int)0);
                        Matrix.rotateM((float[])transform, (int)0, (float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        float[] perspectiveMat = new float[16];
                        Matrix.setIdentityM((float[])perspectiveMat, (int)0);
                        Matrix.multiplyMM((float[])this.resultMat, (int)0, (float[])transform, (int)0, (float[])perspectiveMat, (int)0);
                        this.mDummyFilter.setTransform3D(this.resultMat);
                    }
                    this.mDummyFilter.onOutputSizeChanged(buffer.getWidth(), buffer.getHeight());
                    int textureId = this.mDummyFilter.onDrawToTexture(buffer.getTextureId(), this.gLCubeBuffer, this.gLTextureBuffer);
                    buffer.setTextureId(textureId);
                    buffer.setType(VideoFrame.TextureBuffer.Type.RGB);
                }
                int id = this.mExternalFilter.onVideoFrame(buffer.getTextureId(), buffer.getWidth(), buffer.getHeight(), rotation, yuv);
                GLES20.glFinish();
                if (id != -1 && id != buffer.getTextureId()) {
                    buffer.setTextureId(id);
                    buffer.setType(VideoFrame.TextureBuffer.Type.RGB);
                }
            });
        }
    }

    private void calcMatRectToQuad(float[] transform, float[] rect, float xTopLeft, float yTopLeft, float xBottomLeft, float yBottomLeft, float xTopRight, float yTopRight, float xBottomRight, float yBottomRight) {
        float xOrigin = rect[0];
        float yOrigin = rect[1];
        float rectWidth = rect[2];
        float rectHeight = rect[3];
        float xBlTl = xBottomLeft - xTopLeft;
        float xTrBl = xTopRight - xBottomLeft;
        float xBrTr = xBottomRight - xTopRight;
        float xTlBr = xTopLeft - xBottomRight;
        float xTrTl = xTopRight - xTopLeft;
        float xBrBl = xBottomRight - xBottomLeft;
        float xScale = -rectHeight * (yBottomLeft * yTopRight * xTlBr + yBottomLeft * yBottomRight * xTrTl - yTopLeft * yBottomRight * xTrBl + yTopLeft * yTopRight * xBrBl);
        float rot21 = rectWidth * (yBottomLeft * yTopRight * xTlBr + yTopRight * yBottomRight * xBlTl + yTopLeft * yBottomRight * xTrBl + yTopLeft * yBottomLeft * xBrTr);
        float xTranslate = rectHeight * xOrigin * (yBottomLeft * yTopRight * xTlBr + yBottomLeft * yBottomRight * xTrTl - yTopLeft * yBottomRight * xTrBl + yTopLeft * yTopRight * xBrBl) - rectHeight * rectWidth * yTopLeft * (yBottomRight * xTrBl - yTopRight * xBrBl + yBottomLeft * xBrTr) - rectWidth * yOrigin * (yBottomLeft * yTopRight * xTlBr + yTopRight * yBottomRight * xBlTl + yTopLeft * yBottomRight * xTrBl + yTopLeft * yBottomLeft * xBrTr);
        float rot12 = rectHeight * (-yBottomRight * xBlTl * xTopRight + yBottomLeft * xTopLeft * xBrTr - yTopLeft * xBottomLeft * xBrTr - yTopRight * xTopLeft * xBottomRight + yTopRight * xBottomLeft * xBottomRight);
        float yScale = rectWidth * (yBottomRight * xBottomLeft * xTrTl - yTopRight * xTopLeft * xBrBl - yBottomLeft * xTrTl * xBottomRight + yTopLeft * xTopRight * xBrBl);
        float yTranslate = -(rectWidth * (yBottomRight * (yOrigin * xBottomLeft * xTrTl + rectHeight * xTopLeft * xTrBl) - yTopRight * (rectHeight + yOrigin) * xTopLeft * xBrBl + rectHeight * yBottomLeft * xTopLeft * xBrTr + yBottomLeft * yOrigin * (xTopLeft - xTopRight) * xBottomRight + yTopLeft * yOrigin * xTopRight * (-xBottomLeft + xBottomRight)) - rectHeight * xOrigin * (yBottomRight * xBlTl * xTopRight - yBottomLeft * xTopLeft * xBrTr + yTopRight * (xTopLeft - xBottomLeft) * xBottomRight + yTopLeft * xBottomLeft * (-xTopRight + xBottomRight)));
        float yProject = rectHeight * (yTopRight * xBlTl - yBottomRight * xBlTl + (-yTopLeft + yBottomLeft) * xBrTr);
        float xProject = rectWidth * (-yBottomLeft * xTrTl + yBottomRight * xTrTl + (yTopLeft - yTopRight) * xBrBl);
        float norm = rectWidth * yOrigin * (yBottomLeft * xTrTl - yBottomRight * xTrTl - yTopLeft * xBrBl + yTopRight * xBrBl) + rectHeight * (xOrigin * (-(yTopRight * xBlTl) + yBottomRight * xBlTl + yTopLeft * xBrTr - yBottomLeft * xBrTr) + rectWidth * (-(yTopRight * xBottomLeft) + yBottomRight * xBottomLeft + yBottomLeft * xTopRight - yBottomRight * xTopRight - yBottomLeft * xBottomRight + yTopRight * xBottomRight));
        float kEpsilon = 1.0E-4f;
        if (Math.abs(norm) < kEpsilon) {
            norm = kEpsilon * (norm > 0.0f ? 1.0f : -1.0f);
        }
        transform[0] = xScale / norm;
        transform[1] = rot12 / norm;
        transform[2] = 0.0f;
        transform[3] = yProject / norm;
        transform[4] = rot21 / norm;
        transform[5] = yScale / norm;
        transform[6] = 0.0f;
        transform[7] = xProject / norm;
        transform[8] = 0.0f;
        transform[9] = 0.0f;
        transform[10] = 1.0f;
        transform[11] = 0.0f;
        transform[12] = xTranslate / norm;
        transform[13] = yTranslate / norm;
        transform[14] = 0.0f;
        transform[15] = 1.0f;
    }

    private native String LoadVertexShader();

    private native String LoadFragmentShader();

    private native String LoadTransformVertexShader();

    private native String LoadTransformOesFragmentShader();

    private native String LoadTransformFragmentShader();

    private native String LoadExtBrightnessOesFragmentShader(int var1);

    private native String LoadExtBrightnessVertexShader(int var1);
}

