/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.video;

import com.pano.rtc.video.GPUImageExtBrightnessSubFilter;
import java.nio.FloatBuffer;

public class GPUImageExtBrightnessFilter {
    private static final String TAG = "GPUImageExtBrightnessFilter";
    private final GPUImageExtBrightnessSubFilter mSubFilterRound1;
    private final GPUImageExtBrightnessSubFilter mSubFilterRound2;

    public GPUImageExtBrightnessFilter(String vertexRound1, String fragmentRound1, String vertexRound2, String fragmentRound2, boolean isOESInput) {
        this.mSubFilterRound1 = new GPUImageExtBrightnessSubFilter(vertexRound1, fragmentRound1, isOESInput);
        this.mSubFilterRound2 = new GPUImageExtBrightnessSubFilter(vertexRound2, fragmentRound2, false);
    }

    public void setBrightness(float brightness) {
        this.mSubFilterRound1.setBrightness(0.0f);
        this.mSubFilterRound2.setBrightness(brightness);
    }

    public void setDistanceNormalizationFactor(float newValue) {
        this.mSubFilterRound1.setDistanceNormalizationFactor(newValue);
        this.mSubFilterRound2.setDistanceNormalizationFactor(newValue);
    }

    public void onInit() {
        this.mSubFilterRound1.onInit();
        this.mSubFilterRound2.onInit();
    }

    public final void destroy() {
        this.mSubFilterRound1.destroy();
        this.mSubFilterRound2.destroy();
    }

    public void onOutputSizeChanged(int width, int height) {
        this.mSubFilterRound1.setTexelSize(width, 0);
        this.mSubFilterRound1.onOutputSizeChanged(width, height);
        this.mSubFilterRound2.setTexelSize(0, height);
        this.mSubFilterRound2.onOutputSizeChanged(width, height);
    }

    public void initGPUImageInputFrameBuffer(int width, int height) {
        this.mSubFilterRound1.initGPUImageInputFrameBuffer(width, height);
        this.mSubFilterRound2.initGPUImageInputFrameBuffer(width, height);
    }

    public void setTextureTransformMatrix(float[] mtx) {
        this.mSubFilterRound1.setTextureTransformMatrix(mtx);
        this.mSubFilterRound2.setTextureTransformMatrix(mtx);
    }

    public int onDrawToTexture(int textureId, FloatBuffer vertexBuffer, FloatBuffer textureBuffer) {
        int temp_id = this.mSubFilterRound1.onDrawToTexture(textureId, vertexBuffer, textureBuffer);
        return this.mSubFilterRound2.onDrawToTexture(temp_id, vertexBuffer, textureBuffer);
    }
}

