/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.video;

import android.opengl.GLES20;
import com.pano.rtc.video.GPUImageInput;

public class GPUImageExtBrightnessSubFilter
extends GPUImageInput {
    private static final String TAG = "GPUImageExtBrightnessSubFilter";
    private int brightnessLocation;
    private float brightness = 0.0f;
    private float distanceNormalizationFactor = 8.0f;
    private int disFactorLocation;
    private int singleStepOffsetLocation;

    public GPUImageExtBrightnessSubFilter(String vertex, String fragment, boolean isOESInput) {
        super(vertex, fragment, isOESInput);
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
        this.setFloat(this.brightnessLocation, this.brightness);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.brightnessLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"brightness");
        this.disFactorLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"distanceNormalizationFactor");
        this.singleStepOffsetLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"singleStepOffset");
    }

    public void onInitialized() {
        super.onInitialized();
        this.setBrightness(this.brightness);
        this.setDistanceNormalizationFactor(this.distanceNormalizationFactor);
    }

    public void setDistanceNormalizationFactor(float newValue) {
        this.distanceNormalizationFactor = newValue;
        this.setFloat(this.disFactorLocation, newValue);
    }

    public void setTexelSize(int w, int h) {
        this.setFloatVec2(this.singleStepOffsetLocation, new float[]{w == 0 ? 0.0f : 1.0f / (float)w, h == 0 ? 0.0f : 1.0f / (float)h});
    }

    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
    }
}

