/*
 * Decompiled with CFR 0.152.
 */
package video.pano.rtc.base.util;

public class ArrayUtils {
    private static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final int INDEX_NOT_FOUND = -1;

    private ArrayUtils() {
    }

    public static Integer[] toObject(int[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static boolean contains(Object[] array, Object objectToFind) {
        return ArrayUtils.indexOf(array, objectToFind) != -1;
    }

    public static boolean contains(long[] array, long valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind) != -1;
    }

    public static boolean contains(int[] array, int valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind) != -1;
    }

    public static int indexOf(Object[] array, Object objectToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (objectToFind == null) {
            for (int i = startIndex; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i < array.length; ++i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(Object[] array, Object objectToFind) {
        return ArrayUtils.indexOf(array, objectToFind, 0);
    }

    public static int indexOf(long[] array, long valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long[] array, long valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(int[] array, int valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(int[] array, int valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static <T> boolean nonNullElements(T[] array) {
        int len = ArrayUtils.getLength(array);
        for (int index = 0; index < len; ++index) {
            if (array[index] != null) continue;
            return false;
        }
        return len > 0;
    }

    public static boolean isEmpty(Object[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(long[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(int[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(short[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(char[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(byte[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(double[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(float[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(boolean[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static int getLength(Object array) {
        if (array == null) {
            return 0;
        }
        if (array instanceof Object[]) {
            return ((Object[])array).length;
        }
        if (array instanceof boolean[]) {
            return ((boolean[])array).length;
        }
        if (array instanceof byte[]) {
            return ((byte[])array).length;
        }
        if (array instanceof char[]) {
            return ((char[])array).length;
        }
        if (array instanceof double[]) {
            return ((double[])array).length;
        }
        if (array instanceof float[]) {
            return ((float[])array).length;
        }
        if (array instanceof int[]) {
            return ((int[])array).length;
        }
        if (array instanceof long[]) {
            return ((long[])array).length;
        }
        if (array instanceof short[]) {
            return ((short[])array).length;
        }
        throw ArrayUtils.badArray(array);
    }

    private static RuntimeException badArray(Object array) {
        if (array == null) {
            throw new NullPointerException("array == null");
        }
        if (!array.getClass().isArray()) {
            throw ArrayUtils.notAnArray(array);
        }
        throw ArrayUtils.incompatibleType(array);
    }

    private static IllegalArgumentException notAnArray(Object o) {
        throw new IllegalArgumentException("Not an array: " + o.getClass());
    }

    private static IllegalArgumentException incompatibleType(Object o) {
        throw new IllegalArgumentException("Array has incompatible type: " + o.getClass());
    }

    public static char[] toPrimitive(Character[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].charValue();
        }
        return result;
    }

    public static long[] toPrimitive(Long[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static int[] toPrimitive(Integer[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static short[] toPrimitive(Short[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] result = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static byte[] toPrimitive(Byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static double[] toPrimitive(Double[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static float[] toPrimitive(Float[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].floatValue();
        }
        return result;
    }

    public static boolean[] toPrimitive(Boolean[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] result = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }
}

