/*
 * Decompiled with CFR 0.152.
 */
package video.pano.rtc.base.util;

import android.os.Handler;
import android.os.Looper;
import video.pano.rtc.base.util.Compatibility;

public class LooperUtils {
    public static void quit(Handler handler) {
        if (handler != null) {
            try {
                handler.post(() -> ((Looper)handler.getLooper()).quit());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void quitSafely(Handler handler) {
        if (handler != null) {
            if (Compatibility.runningOnJellyBeanMR2OrHigher()) {
                handler.getLooper().quitSafely();
            } else {
                handler.getLooper().quit();
            }
        }
    }

    public static void quitSafely(Looper looper) {
        if (looper != null) {
            if (Compatibility.runningOnJellyBeanMR2OrHigher()) {
                looper.quitSafely();
            } else {
                looper.quit();
            }
        }
    }
}

