/*
 * Decompiled with CFR 0.152.
 */
package video.pano.rtc.base.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import video.pano.rtc.base.util.NetworkChangeObserver;
import video.pano.rtc.base.util.NetworkUtils;
import video.pano.rtc.impl.PLogger;

public class NetworkChangeReceiver
extends BroadcastReceiver {
    private NetworkChangeObserver mObserver;
    private NetworkUtils.NetworkType mNetworkType;

    public NetworkChangeReceiver(Context context) {
        this.mNetworkType = NetworkUtils.getConnectivityStatus(context);
    }

    public void setNetworkChangeObserver(NetworkChangeObserver observer) {
        this.mObserver = observer;
    }

    public void onReceive(Context context, Intent intent) {
        NetworkUtils.NetworkType type = NetworkUtils.getConnectivityStatus(context);
        String status = NetworkUtils.getConnectivityStatusString(type);
        PLogger.i("network", "Network connectivity changed ==> " + status);
        if (type != this.mNetworkType) {
            this.mNetworkType = type;
            if (this.mObserver != null) {
                this.mObserver.onNetworkChanged(type);
            }
        }
    }
}

