/*
 * Decompiled with CFR 0.152.
 */
package video.pano.rtc.impl.whiteboard;

import android.content.Context;
import android.util.Log;
import android.view.View;
import video.pano.rtc.impl.GestureHandler;
import video.pano.rtc.impl.GlobalRef;
import video.pano.rtc.impl.whiteboard.WBTextDialog;
import video.pano.rtc.impl.whiteboard.WBTextFormat;
import video.pano.rtc.impl.whiteboard.WBTextObject;
import video.pano.rtc.impl.whiteboard.WBTextPopup;

public class RtcWbDrawer {
    private static final String TAG = "[pano]";
    private final long mNativeHandle;
    private final String mWbId;
    private View mWbView;
    private boolean mSkipAction = false;
    private boolean mCancelText = true;
    private WBTextPopup mTextPopup;
    private WBTextDialog mTextDialog;
    private final Callback mCallback;

    public RtcWbDrawer(long nativeHandle, String wbId, Callback cb) {
        this.mNativeHandle = nativeHandle;
        this.mWbId = wbId;
        this.mCallback = cb;
    }

    public void start(Context context, View view) {
        Log.i((String)TAG, (String)"RtcWbDrawer start");
        GestureHandler gesHandler = new GestureHandler(GlobalRef.applicationContext, new GestureHandler.Callback(){

            @Override
            public void onBegin(float x, float y) {
                RtcWbDrawer.this.mSkipAction = false;
                RtcWbDrawer.this.mCallback.onActionBegin();
                if (RtcWbDrawer.this.WBGetToolboxType(RtcWbDrawer.this.mNativeHandle, RtcWbDrawer.this.mWbId) == 7) {
                    RtcWbDrawer.this.mSkipAction = true;
                    RtcWbDrawer.this.doTextInput_d((int)x, (int)y);
                } else {
                    RtcWbDrawer.this.WBActionBegin(RtcWbDrawer.this.getNativeHandle(), RtcWbDrawer.this.mWbId, x, y);
                }
            }

            @Override
            public void onClicked(float x, float y) {
                if (!RtcWbDrawer.this.mSkipAction) {
                    RtcWbDrawer.this.WBActionClicked(RtcWbDrawer.this.getNativeHandle(), RtcWbDrawer.this.mWbId, x, y);
                }
                RtcWbDrawer.this.mCallback.onActionEnd();
            }

            @Override
            public void onRightClicked(float x, float y) {
                if (!RtcWbDrawer.this.mSkipAction) {
                    RtcWbDrawer.this.WBActionRClicked(RtcWbDrawer.this.getNativeHandle(), RtcWbDrawer.this.mWbId, x, y);
                }
                RtcWbDrawer.this.mCallback.onActionEnd();
            }

            @Override
            public void onDoubleClicked(float x, float y) {
                if (!RtcWbDrawer.this.mSkipAction) {
                    WBTextObject textObj = new WBTextObject();
                    if (RtcWbDrawer.this.WBDetectSelectText(RtcWbDrawer.this.mNativeHandle, RtcWbDrawer.this.mWbId, x, y, textObj) == 0) {
                        RtcWbDrawer.this.mSkipAction = true;
                        RtcWbDrawer.this.doTextEdit_d(textObj);
                        return;
                    }
                    RtcWbDrawer.this.WBActionDClicked(RtcWbDrawer.this.getNativeHandle(), RtcWbDrawer.this.mWbId, x, y);
                }
                RtcWbDrawer.this.mCallback.onActionEnd();
            }

            @Override
            public void onMove(float x, float y, float dx, float dy, float vx, float vy) {
                if (!RtcWbDrawer.this.mSkipAction) {
                    RtcWbDrawer.this.WBActionMove(RtcWbDrawer.this.getNativeHandle(), RtcWbDrawer.this.mWbId, x, y, -dx, -dy);
                }
            }

            @Override
            public void onDrag(float x, float y, float dx, float dy, float vx, float vy) {
                if (!RtcWbDrawer.this.mSkipAction) {
                    RtcWbDrawer.this.WBActionDrag(RtcWbDrawer.this.getNativeHandle(), RtcWbDrawer.this.mWbId, x, y, dx, dy);
                }
            }

            @Override
            public void onScroll(float x, float y, float dx, float dy, float vx, float vy) {
                if (!RtcWbDrawer.this.mSkipAction) {
                    RtcWbDrawer.this.WBActionScroll(RtcWbDrawer.this.getNativeHandle(), RtcWbDrawer.this.mWbId, x, y, dx, dy);
                }
            }

            @Override
            public void onScale(float factor, float focusX, float focusY, float spanX, float spanY) {
                if (!RtcWbDrawer.this.mSkipAction) {
                    RtcWbDrawer.this.WBActionScale(RtcWbDrawer.this.getNativeHandle(), RtcWbDrawer.this.mWbId, factor, focusX, focusY);
                }
            }

            @Override
            public void onEnd(float x, float y) {
                if (!RtcWbDrawer.this.mSkipAction) {
                    RtcWbDrawer.this.WBActionEnd(RtcWbDrawer.this.getNativeHandle(), RtcWbDrawer.this.mWbId, x, y);
                }
                RtcWbDrawer.this.mCallback.onActionEnd();
            }

            @Override
            public void onCancel() {
                if (!RtcWbDrawer.this.mSkipAction) {
                    RtcWbDrawer.this.WBActionCancel(RtcWbDrawer.this.getNativeHandle(), RtcWbDrawer.this.mWbId);
                }
            }
        });
        this.mCallback.onGestureHandlerAdd(gesHandler);
        this.mWbView = view;
        this.mCancelText = false;
    }

    private void doTextInput_p(int x, int y) {
        if (this.mWbView == null) {
            return;
        }
        if (this.mCancelText) {
            return;
        }
        if (this.mTextPopup != null && this.mTextPopup.isShowing()) {
            this.mTextPopup.dismiss();
            return;
        }
        WBTextObject textObject = new WBTextObject();
        this.WBGetTextFormat(this.mNativeHandle, this.mWbId, textObject.format);
        this.mTextPopup = new WBTextPopup(GlobalRef.applicationContext, x, y, textObject);
        this.mTextPopup.setOnDismissListener(() -> {
            if (this.mTextPopup != null && this.mWbView != null) {
                int[] loc = new int[2];
                this.mWbView.getLocationOnScreen(loc);
                WBTextObject obj = this.mTextPopup.getTextObject();
                obj.x -= (float)loc[0];
                obj.y -= (float)loc[1];
                this.mCallback.onActionBegin();
                this.WBDrawText(this.mNativeHandle, this.mWbId, obj);
                this.mCallback.onActionEnd();
                this.mTextPopup = null;
            }
        });
        this.mTextPopup.update();
        this.mTextPopup.showAsDropDown(this.mWbView, x, y, 0x800033);
    }

    void doTextEdit_p(WBTextObject textObject) {
        if (this.mWbView == null) {
            return;
        }
        if (this.mCancelText) {
            return;
        }
        if (this.mTextPopup != null && this.mTextPopup.isShowing()) {
            this.mTextPopup.dismiss();
            return;
        }
        int x = (int)textObject.x;
        int y = (int)textObject.y;
        this.mTextPopup = new WBTextPopup(GlobalRef.applicationContext, x, y, textObject);
        this.mTextPopup.setOnDismissListener(() -> {
            if (this.mTextPopup != null && this.mWbView != null) {
                int[] loc = new int[2];
                this.mWbView.getLocationOnScreen(loc);
                WBTextObject obj = this.mTextPopup.getTextObject();
                obj.x -= (float)loc[0];
                obj.y -= (float)loc[1];
                this.WBEditText(this.mNativeHandle, this.mWbId, obj);
                this.mCallback.onActionEnd();
                this.mTextPopup = null;
            }
        });
        this.mTextPopup.update();
        this.mTextPopup.showAsDropDown(this.mWbView, x, y, 0x800033);
    }

    private void doTextInput_d(int x, int y) {
        int xx;
        if (this.mWbView == null) {
            return;
        }
        if (this.mCancelText) {
            return;
        }
        if (this.mTextDialog != null && this.mTextDialog.isShowing()) {
            this.mTextDialog.dismiss();
            return;
        }
        WBTextObject textObject = new WBTextObject();
        this.WBGetTextFormat(this.mNativeHandle, this.mWbId, textObject.format);
        int[] location = new int[2];
        this.mWbView.getLocationOnScreen(location);
        int yy = y + location[1];
        if (yy < 0) {
            yy = 0;
        }
        if ((xx = x + location[0]) < 0) {
            xx = 0;
        }
        this.mTextDialog = new WBTextDialog(this.mWbView.getContext(), xx, yy, textObject);
        this.mTextDialog.setOnDismissListener(var -> {
            if (this.mTextDialog != null && this.mWbView != null) {
                int[] loc = new int[2];
                this.mWbView.getLocationOnScreen(loc);
                WBTextObject obj = this.mTextDialog.getTextObject();
                obj.x -= (float)loc[0];
                obj.y -= (float)loc[1];
                this.mCallback.onActionBegin();
                this.WBDrawText(this.mNativeHandle, this.mWbId, obj);
                this.mCallback.onActionEnd();
                this.mTextDialog = null;
            }
        });
        this.mTextDialog.show();
    }

    private void doTextEdit_d(WBTextObject textObject) {
        int xx;
        if (this.mWbView == null) {
            return;
        }
        if (this.mCancelText) {
            return;
        }
        if (this.mTextDialog != null && this.mTextDialog.isShowing()) {
            this.mTextDialog.dismiss();
            return;
        }
        int x = (int)textObject.x;
        int y = (int)textObject.y;
        int[] location = new int[2];
        this.mWbView.getLocationOnScreen(location);
        int yy = y + location[1];
        if (yy < 0) {
            yy = 0;
        }
        if ((xx = x + location[0]) < 0) {
            xx = 0;
        }
        this.mTextDialog = new WBTextDialog(this.mWbView.getContext(), xx, yy, textObject);
        this.mTextDialog.setOnDismissListener(var -> {
            if (this.mTextDialog != null && this.mWbView != null) {
                int[] loc = new int[2];
                this.mWbView.getLocationOnScreen(loc);
                WBTextObject obj = this.mTextDialog.getTextObject();
                obj.x -= (float)loc[0];
                obj.y -= (float)loc[1];
                this.WBEditText(this.mNativeHandle, this.mWbId, obj);
                this.mCallback.onActionEnd();
                this.mTextDialog = null;
            }
        });
        this.mTextDialog.show();
    }

    public void stop() {
        Log.i((String)TAG, (String)"RtcWbDrawer stop");
        this.mCancelText = true;
        try {
            if (this.mTextPopup != null && this.mTextPopup.isShowing()) {
                this.mTextPopup.dismiss();
                this.mTextPopup = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.mTextDialog != null && this.mTextDialog.isShowing()) {
                this.mTextDialog.dismiss();
                this.mTextDialog = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mCallback.onGestureHandlerRemove();
    }

    private long getNativeHandle() {
        return this.mNativeHandle;
    }

    private native int WBActionBegin(long var1, String var3, float var4, float var5);

    private native int WBActionClicked(long var1, String var3, float var4, float var5);

    private native int WBActionRClicked(long var1, String var3, float var4, float var5);

    private native int WBActionDClicked(long var1, String var3, float var4, float var5);

    private native int WBActionMove(long var1, String var3, float var4, float var5, float var6, float var7);

    private native int WBActionDrag(long var1, String var3, float var4, float var5, float var6, float var7);

    private native int WBActionScroll(long var1, String var3, float var4, float var5, float var6, float var7);

    private native int WBActionScale(long var1, String var3, float var4, float var5, float var6);

    private native int WBActionEnd(long var1, String var3, float var4, float var5);

    private native int WBActionCancel(long var1, String var3);

    private native int WBGetToolboxType(long var1, String var3);

    private native int WBGetTextFormat(long var1, String var3, WBTextFormat var4);

    private native int WBDrawText(long var1, String var3, WBTextObject var4);

    private native int WBEditText(long var1, String var3, WBTextObject var4);

    private native int WBDetectSelectText(long var1, String var3, float var4, float var5, WBTextObject var6);

    public static interface Callback {
        public void onGestureHandlerAdd(GestureHandler var1);

        public void onGestureHandlerRemove();

        public void onActionBegin();

        public void onActionEnd();
    }
}

