/*
 * Decompiled with CFR 0.152.
 */
package video.pano.rtc.remotecontrol;

import android.content.Context;
import android.graphics.PointF;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.VelocityTracker;

public class RemoteControlGestureHandler
implements ScaleGestureDetector.OnScaleGestureListener {
    private static final float MAX_CLICK_DISTANCE = 20.0f;
    private static final float MAX_DBLCLICK_DISTANCE = 50.0f;
    private static final int MAX_CLICK_INTERVAL = 300;
    private static final int MAX_DBLCLICK_INTERVAL = 400;
    private PointF downPoint_ = null;
    private PointF lastPoint_ = null;
    private float maxDistance_ = 0.0f;
    private int pointerId_ = -1;
    private PointF downPoint2_ = null;
    private int pointer2Id_ = -1;
    private float downPointDistance_ = 0.0f;
    private PointF clickPoint_ = null;
    private long clickTime_ = 0L;
    private ActionType action_ = ActionType.Null;
    private int pointerCount_ = 0;
    private int maxPointers_ = 0;
    private VelocityTracker velocityTracker_;
    private final ScaleGestureDetector scaleDetector_;
    private boolean scaleGesture_ = false;
    private final Callback cb_;

    public RemoteControlGestureHandler(Context ctx, Callback cb) {
        this.cb_ = cb;
        this.scaleDetector_ = new ScaleGestureDetector(ctx, (ScaleGestureDetector.OnScaleGestureListener)this);
    }

    public Boolean handleEvent(MotionEvent event) {
        this.scaleDetector_.onTouchEvent(event);
        if (this.scaleDetector_.isInProgress()) {
            return true;
        }
        return this.handleTouch(event);
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        return this.scaleGesture_;
    }

    public boolean onScale(ScaleGestureDetector detector) {
        this.cb_.onScale(detector.getScaleFactor(), detector.getFocusX(), detector.getFocusY(), detector.getCurrentSpanX(), detector.getCurrentSpanY());
        return true;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
    }

    private boolean handleTouch(MotionEvent event) {
        int maskedAction = event.getActionMasked();
        switch (maskedAction) {
            case 0: {
                int pointerIndex = event.getActionIndex();
                this.pointerId_ = event.getPointerId(pointerIndex);
                this.downPoint_ = new PointF();
                this.downPoint_.x = event.getX(pointerIndex);
                this.downPoint_.y = event.getY(pointerIndex);
                this.pointer2Id_ = -1;
                this.lastPoint_ = new PointF(this.downPoint_.x, this.downPoint_.y);
                this.maxDistance_ = 0.0f;
                this.pointerCount_ = 1;
                this.maxPointers_ = 1;
                this.scaleGesture_ = false;
                this.action_ = ActionType.Null;
                if (this.velocityTracker_ == null) {
                    this.velocityTracker_ = VelocityTracker.obtain();
                } else {
                    this.velocityTracker_.clear();
                }
                this.velocityTracker_.addMovement(event);
                this.cb_.onBegin(this.downPoint_.x, this.downPoint_.y);
                break;
            }
            case 5: {
                ++this.pointerCount_;
                if (this.pointerCount_ == 2) {
                    int pointerIndex = event.getActionIndex();
                    this.pointer2Id_ = event.getPointerId(pointerIndex);
                    this.downPoint2_ = new PointF();
                    this.downPoint2_.x = event.getX(pointerIndex);
                    this.downPoint2_.y = event.getY(pointerIndex);
                    float dx = this.downPoint2_.x - this.downPoint_.x;
                    float dy = this.downPoint2_.y - this.downPoint_.y;
                    this.downPointDistance_ = (float)Math.sqrt(dx * dx + dy * dy);
                }
                ++this.maxPointers_;
                this.cb_.onCancel();
                break;
            }
            case 2: {
                int pointerIndex;
                if (this.lastPoint_ == null || this.downPoint_ == null || -1 == (pointerIndex = event.findPointerIndex(this.pointerId_))) break;
                this.velocityTracker_.addMovement(event);
                float x = event.getX(pointerIndex);
                float y = event.getY(pointerIndex);
                float dx = x - this.downPoint_.x;
                float dy = y - this.downPoint_.y;
                ActionType action = this.action_;
                if (this.action_ == ActionType.Null) {
                    float y2;
                    float dy2;
                    float x2;
                    float dx2;
                    float distance;
                    int pointerIndex2 = event.findPointerIndex(this.pointer2Id_);
                    if (-1 != pointerIndex2 && Math.abs((distance = (float)Math.sqrt((dx2 = (x2 = event.getX(pointerIndex2)) - x) * dx2 + (dy2 = (y2 = event.getY(pointerIndex2)) - y) * dy2)) - this.downPointDistance_) >= 20.0f) {
                        this.scaleGesture_ = true;
                        break;
                    }
                    float d = (float)Math.sqrt(dx * dx + dy * dy);
                    if (d > this.maxDistance_) {
                        this.maxDistance_ = d;
                    }
                    long downTime = event.getDownTime();
                    if (this.maxDistance_ >= 20.0f) {
                        this.action_ = this.pointerCount_ == 2 ? ActionType.Scroll : (this.clickPoint_ != null && downTime - this.clickTime_ < 400L ? ActionType.Drag : ActionType.Move);
                        action = this.action_;
                    } else {
                        action = ActionType.Move;
                    }
                }
                this.velocityTracker_.computeCurrentVelocity(1000);
                float vx = this.velocityTracker_.getXVelocity(this.pointerId_);
                float vy = this.velocityTracker_.getYVelocity(this.pointerId_);
                dx = x - this.lastPoint_.x;
                dy = y - this.lastPoint_.y;
                this.lastPoint_.x = x;
                this.lastPoint_.y = y;
                if (action == ActionType.Drag) {
                    this.cb_.onDrag(x, y, dx, dy, vx, vy);
                    break;
                }
                if (action == ActionType.Scroll) {
                    this.cb_.onScroll(x, y, dx, dy, vx, vy);
                    break;
                }
                this.cb_.onMove(x, y, dx, dy, vx, vy);
                break;
            }
            case 1: {
                if (this.downPoint_ == null) break;
                int pointerIndex = event.getActionIndex();
                float x = event.getX(pointerIndex);
                float y = event.getY(pointerIndex);
                ActionType action = ActionType.End;
                long downTime = event.getDownTime();
                long upTime = event.getEventTime();
                if (this.maxDistance_ < 20.0f && upTime - downTime < 300L) {
                    float dy;
                    float dx;
                    float d;
                    action = ActionType.Click;
                    if (this.maxPointers_ == 2) {
                        action = ActionType.RightClick;
                    } else if (this.clickPoint_ != null && downTime - this.clickTime_ < 400L && (d = (float)Math.sqrt((dx = this.downPoint_.x - this.clickPoint_.x) * dx + (dy = this.downPoint_.y - this.clickPoint_.y) * dy)) < 50.0f) {
                        action = ActionType.DoubleClick;
                    }
                    if (action == ActionType.Click) {
                        this.clickPoint_ = new PointF(x, y);
                        this.clickTime_ = upTime;
                    } else {
                        this.clickPoint_ = null;
                        this.clickTime_ = 0L;
                    }
                } else {
                    this.clickPoint_ = null;
                    this.clickTime_ = 0L;
                }
                if (action == ActionType.RightClick) {
                    this.cb_.onRightClicked(x, y);
                } else if (action == ActionType.DoubleClick) {
                    this.cb_.onDoubleClicked(x, y);
                } else if (action == ActionType.Click) {
                    this.cb_.onClicked(x, y);
                } else {
                    this.cb_.onEnd(x, y);
                }
                this.clearMouseAction();
                break;
            }
            case 6: {
                int newPointerIndex;
                --this.pointerCount_;
                int pointerIndex = event.getActionIndex();
                int pointerId = event.getPointerId(pointerIndex);
                if (this.pointerCount_ == 1) {
                    this.downPoint2_ = null;
                    this.pointer2Id_ = -1;
                }
                int pointerCount = event.getPointerCount();
                if (pointerId == this.pointerId_) {
                    newPointerIndex = pointerIndex == 0 ? 1 : 0;
                    newPointerIndex = Math.min(newPointerIndex, pointerCount - 1);
                    this.lastPoint_ = new PointF(event.getX(newPointerIndex), event.getY(newPointerIndex));
                    this.pointerId_ = event.getPointerId(newPointerIndex);
                    if (this.pointerCount_ >= 2) {
                        newPointerIndex = pointerIndex == 0 ? 2 : 1;
                        newPointerIndex = Math.min(newPointerIndex, pointerCount - 1);
                        this.downPoint2_ = new PointF(event.getX(newPointerIndex), event.getY(newPointerIndex));
                        this.pointer2Id_ = event.getPointerId(newPointerIndex);
                    }
                }
                if (pointerId != this.pointer2Id_ || this.pointerCount_ < 2) break;
                newPointerIndex = pointerIndex == 1 ? 2 : 1;
                newPointerIndex = Math.min(newPointerIndex, pointerCount - 1);
                this.downPoint2_ = new PointF(event.getX(newPointerIndex), event.getY(newPointerIndex));
                this.pointer2Id_ = event.getPointerId(newPointerIndex);
                break;
            }
            case 3: {
                this.cb_.onEnd(this.lastPoint_.x, this.lastPoint_.y);
                break;
            }
        }
        return true;
    }

    private void clearMouseAction() {
        this.downPoint_ = null;
        this.lastPoint_ = null;
        this.pointerId_ = -1;
        this.downPoint2_ = null;
        this.pointer2Id_ = -1;
        this.downPointDistance_ = 0.0f;
        this.maxDistance_ = 0.0f;
        this.action_ = ActionType.Null;
        this.pointerCount_ = 0;
        this.maxPointers_ = 0;
        this.scaleGesture_ = false;
        if (this.velocityTracker_ != null) {
            this.velocityTracker_.recycle();
            this.velocityTracker_ = null;
        }
    }

    public static interface Callback {
        default public void onBegin(float x, float y) {
        }

        default public void onClicked(float x, float y) {
        }

        default public void onRightClicked(float x, float y) {
        }

        default public void onDoubleClicked(float x, float y) {
        }

        default public void onMove(float x, float y, float dx, float dy, float vx, float vy) {
        }

        default public void onDrag(float x, float y, float dx, float dy, float vx, float vy) {
        }

        default public void onScroll(float x, float y, float dx, float dy, float vx, float vy) {
        }

        default public void onScale(float factor, float focusX, float focusY, float spanX, float spanY) {
        }

        default public void onEnd(float x, float y) {
        }

        default public void onCancel() {
        }
    }

    public static enum ActionType {
        Drag,
        Scroll,
        Move,
        Click,
        RightClick,
        DoubleClick,
        End,
        Null;

    }
}

