/*
 * Decompiled with CFR 0.152.
 */
package video.pano.android.gpuimage;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLDebugHelper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.TextureView;
import android.view.View;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;

public class GLTextureView
extends TextureView
implements TextureView.SurfaceTextureListener,
View.OnLayoutChangeListener {
    private static final String TAG = GLTextureView.class.getSimpleName();
    private static final boolean LOG_ATTACH_DETACH = false;
    private static final boolean LOG_THREADS = false;
    private static final boolean LOG_PAUSE_RESUME = false;
    private static final boolean LOG_SURFACE = false;
    private static final boolean LOG_RENDERER = false;
    private static final boolean LOG_RENDERER_DRAW_FRAME = false;
    private static final boolean LOG_EGL = false;
    public static final int RENDERMODE_WHEN_DIRTY = 0;
    public static final int RENDERMODE_CONTINUOUSLY = 1;
    public static final int DEBUG_CHECK_GL_ERROR = 1;
    public static final int DEBUG_LOG_GL_CALLS = 2;
    private static final GLThreadManager glThreadManager = new GLThreadManager();
    private final WeakReference<GLTextureView> mThisWeakRef = new WeakReference<GLTextureView>(this);
    private GLThread glThread;
    private Renderer renderer;
    private boolean detached;
    private EGLConfigChooser eglConfigChooser;
    private EGLContextFactory eglContextFactory;
    private EGLWindowSurfaceFactory eglWindowSurfaceFactory;
    private GLWrapper glWrapper;
    private int debugFlags;
    private int eglContextClientVersion;
    private boolean preserveEGLContextOnPause;
    private List<TextureView.SurfaceTextureListener> surfaceTextureListeners = new ArrayList<TextureView.SurfaceTextureListener>();

    public GLTextureView(Context context) {
        super(context);
        this.init();
    }

    public GLTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.glThread != null) {
                this.glThread.requestExitAndWait();
            }
        }
        finally {
            super.finalize();
        }
    }

    private void init() {
        this.setSurfaceTextureListener(this);
    }

    public void setGLWrapper(GLWrapper glWrapper) {
        this.glWrapper = glWrapper;
    }

    public void setDebugFlags(int debugFlags) {
        this.debugFlags = debugFlags;
    }

    public int getDebugFlags() {
        return this.debugFlags;
    }

    public void setPreserveEGLContextOnPause(boolean preserveOnPause) {
        this.preserveEGLContextOnPause = preserveOnPause;
    }

    public boolean getPreserveEGLContextOnPause() {
        return this.preserveEGLContextOnPause;
    }

    public void setRenderer(Renderer renderer) {
        this.checkRenderThreadState();
        if (this.eglConfigChooser == null) {
            this.eglConfigChooser = new SimpleEGLConfigChooser(true);
        }
        if (this.eglContextFactory == null) {
            this.eglContextFactory = new DefaultContextFactory();
        }
        if (this.eglWindowSurfaceFactory == null) {
            this.eglWindowSurfaceFactory = new DefaultWindowSurfaceFactory();
        }
        this.renderer = renderer;
        this.glThread = new GLThread(this.mThisWeakRef);
        this.glThread.start();
    }

    public void setEGLContextFactory(EGLContextFactory factory) {
        this.checkRenderThreadState();
        this.eglContextFactory = factory;
    }

    public void setEGLWindowSurfaceFactory(EGLWindowSurfaceFactory factory) {
        this.checkRenderThreadState();
        this.eglWindowSurfaceFactory = factory;
    }

    public void setEGLConfigChooser(EGLConfigChooser configChooser) {
        this.checkRenderThreadState();
        this.eglConfigChooser = configChooser;
    }

    public void setEGLConfigChooser(boolean needDepth) {
        this.setEGLConfigChooser(new SimpleEGLConfigChooser(needDepth));
    }

    public void setEGLConfigChooser(int redSize, int greenSize, int blueSize, int alphaSize, int depthSize, int stencilSize) {
        this.setEGLConfigChooser(new ComponentSizeChooser(redSize, greenSize, blueSize, alphaSize, depthSize, stencilSize));
    }

    public void setEGLContextClientVersion(int version) {
        this.checkRenderThreadState();
        this.eglContextClientVersion = version;
    }

    public void setRenderMode(int renderMode) {
        this.glThread.setRenderMode(renderMode);
    }

    public int getRenderMode() {
        return this.glThread.getRenderMode();
    }

    public void requestRender() {
        this.glThread.requestRender();
    }

    public void surfaceCreated(SurfaceTexture texture) {
        this.glThread.surfaceCreated();
    }

    public void surfaceDestroyed(SurfaceTexture texture) {
        this.glThread.surfaceDestroyed();
    }

    public void surfaceChanged(SurfaceTexture texture, int format, int w, int h) {
        this.glThread.onWindowResize(w, h);
    }

    public void onPause() {
        this.glThread.onPause();
    }

    public void onResume() {
        this.glThread.onResume();
    }

    public void queueEvent(Runnable r) {
        this.glThread.queueEvent(r);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.detached && this.renderer != null) {
            int renderMode = 1;
            if (this.glThread != null) {
                renderMode = this.glThread.getRenderMode();
            }
            this.glThread = new GLThread(this.mThisWeakRef);
            if (renderMode != 1) {
                this.glThread.setRenderMode(renderMode);
            }
            this.glThread.start();
        }
        this.detached = false;
    }

    protected void onDetachedFromWindow() {
        if (this.glThread != null) {
            this.glThread.requestExitAndWait();
        }
        this.detached = true;
        super.onDetachedFromWindow();
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        this.surfaceChanged(this.getSurfaceTexture(), 0, right - left, bottom - top);
    }

    public void addSurfaceTextureListener(TextureView.SurfaceTextureListener listener) {
        this.surfaceTextureListeners.add(listener);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.surfaceCreated(surface);
        this.surfaceChanged(surface, 0, width, height);
        for (TextureView.SurfaceTextureListener l : this.surfaceTextureListeners) {
            l.onSurfaceTextureAvailable(surface, width, height);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        this.surfaceChanged(surface, 0, width, height);
        for (TextureView.SurfaceTextureListener l : this.surfaceTextureListeners) {
            l.onSurfaceTextureSizeChanged(surface, width, height);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.surfaceDestroyed(surface);
        for (TextureView.SurfaceTextureListener l : this.surfaceTextureListeners) {
            l.onSurfaceTextureDestroyed(surface);
        }
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        this.requestRender();
        for (TextureView.SurfaceTextureListener l : this.surfaceTextureListeners) {
            l.onSurfaceTextureUpdated(surface);
        }
    }

    private void checkRenderThreadState() {
        if (this.glThread != null) {
            throw new IllegalStateException("setRenderer has already been called for this instance.");
        }
    }

    static /* synthetic */ boolean access$1000(GLTextureView x0) {
        return x0.preserveEGLContextOnPause;
    }

    static /* synthetic */ Renderer access$1100(GLTextureView x0) {
        return x0.renderer;
    }

    private static class GLThreadManager {
        private static String TAG = "GLThreadManager";
        private boolean glesVersionCheckComplete;
        private int glesVersion;
        private boolean glesDriverCheckComplete;
        private boolean multipleGLESContextsAllowed;
        private boolean limitedGLESContexts;
        private static final int kGLES_20 = 131072;
        private static final String kMSM7K_RENDERER_PREFIX = "Q3Dimension MSM7500 ";
        private GLThread eglOwner;

        private GLThreadManager() {
        }

        public synchronized void threadExiting(GLThread thread) {
            thread.exited = true;
            if (this.eglOwner == thread) {
                this.eglOwner = null;
            }
            this.notifyAll();
        }

        public boolean tryAcquireEglContextLocked(GLThread thread) {
            if (this.eglOwner == thread || this.eglOwner == null) {
                this.eglOwner = thread;
                this.notifyAll();
                return true;
            }
            this.checkGLESVersion();
            if (this.multipleGLESContextsAllowed) {
                return true;
            }
            if (this.eglOwner != null) {
                this.eglOwner.requestReleaseEglContextLocked();
            }
            return false;
        }

        public void releaseEglContextLocked(GLThread thread) {
            if (this.eglOwner == thread) {
                this.eglOwner = null;
            }
            this.notifyAll();
        }

        public synchronized boolean shouldReleaseEGLContextWhenPausing() {
            return this.limitedGLESContexts;
        }

        public synchronized boolean shouldTerminateEGLWhenPausing() {
            this.checkGLESVersion();
            return !this.multipleGLESContextsAllowed;
        }

        public synchronized void checkGLDriver(GL10 gl) {
            if (!this.glesDriverCheckComplete) {
                this.checkGLESVersion();
                String renderer = gl.glGetString(7937);
                if (this.glesVersion < 131072) {
                    this.multipleGLESContextsAllowed = !renderer.startsWith(kMSM7K_RENDERER_PREFIX);
                    this.notifyAll();
                }
                this.limitedGLESContexts = !this.multipleGLESContextsAllowed;
                this.glesDriverCheckComplete = true;
            }
        }

        private void checkGLESVersion() {
            if (!this.glesVersionCheckComplete) {
                this.glesVersionCheckComplete = true;
            }
        }
    }

    static class LogWriter
    extends Writer {
        private StringBuilder builder = new StringBuilder();

        LogWriter() {
        }

        @Override
        public void close() {
            this.flushBuilder();
        }

        @Override
        public void flush() {
            this.flushBuilder();
        }

        @Override
        public void write(char[] buf, int offset, int count) {
            for (int i = 0; i < count; ++i) {
                char c = buf[offset + i];
                if (c == '\n') {
                    this.flushBuilder();
                    continue;
                }
                this.builder.append(c);
            }
        }

        private void flushBuilder() {
            if (this.builder.length() > 0) {
                Log.v((String)"GLTextureView", (String)this.builder.toString());
                this.builder.delete(0, this.builder.length());
            }
        }
    }

    static class GLThread
    extends Thread {
        private boolean shouldExit;
        private boolean exited;
        private boolean requestPaused;
        private boolean paused;
        private boolean hasSurface;
        private boolean surfaceIsBad;
        private boolean waitingForSurface;
        private boolean haveEglContext;
        private boolean haveEglSurface;
        private boolean shouldReleaseEglContext;
        private int width = 0;
        private int height = 0;
        private int renderMode = 1;
        private boolean requestRender = true;
        private boolean renderComplete;
        private ArrayList<Runnable> eventQueue = new ArrayList();
        private boolean sizeChanged = true;
        private EglHelper eglHelper;
        private WeakReference<GLTextureView> glTextureViewWeakRef;

        GLThread(WeakReference<GLTextureView> glTextureViewWeakRef) {
            this.glTextureViewWeakRef = glTextureViewWeakRef;
        }

        @Override
        public void run() {
            this.setName("GLThread " + this.getId());
            try {
                this.guardedRun();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                glThreadManager.threadExiting(this);
            }
        }

        private void stopEglSurfaceLocked() {
            if (this.haveEglSurface) {
                this.haveEglSurface = false;
                this.eglHelper.destroySurface();
            }
        }

        private void stopEglContextLocked() {
            if (this.haveEglContext) {
                this.eglHelper.finish();
                this.haveEglContext = false;
                glThreadManager.releaseEglContextLocked(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void guardedRun() throws InterruptedException {
            this.eglHelper = new EglHelper(this.glTextureViewWeakRef);
            this.haveEglContext = false;
            this.haveEglSurface = false;
            try {
                gl = null;
                createEglContext = false;
                createEglSurface = false;
                createGlInterface = false;
                lostEglContext = false;
                sizeChanged = false;
                wantRenderNotification = false;
                doRenderNotification = false;
                askedToReleaseEglContext = false;
                w = 0;
                h = 0;
                event = null;
                while (true) {
                    var13_13 = GLTextureView.access$900();
                    synchronized (var13_13) {
                        while (true) {
                            if (this.shouldExit) {
                                return;
                            }
                            if (!this.eventQueue.isEmpty()) {
                                event = this.eventQueue.remove(0);
                                break;
                            }
                            pausing = false;
                            if (this.paused != this.requestPaused) {
                                pausing = this.requestPaused;
                                this.paused = this.requestPaused;
                                GLTextureView.access$900().notifyAll();
                            }
                            if (this.shouldReleaseEglContext) {
                                this.stopEglSurfaceLocked();
                                this.stopEglContextLocked();
                                this.shouldReleaseEglContext = false;
                                askedToReleaseEglContext = true;
                            }
                            if (lostEglContext) {
                                this.stopEglSurfaceLocked();
                                this.stopEglContextLocked();
                                lostEglContext = false;
                            }
                            if (pausing && this.haveEglSurface) {
                                this.stopEglSurfaceLocked();
                            }
                            if (pausing && this.haveEglContext) {
                                view = (GLTextureView)this.glTextureViewWeakRef.get();
                                v0 = preserveEglContextOnPause = view == null ? false : GLTextureView.access$1000(view);
                                if (!preserveEglContextOnPause || GLTextureView.access$900().shouldReleaseEGLContextWhenPausing()) {
                                    this.stopEglContextLocked();
                                }
                            }
                            if (pausing && GLTextureView.access$900().shouldTerminateEGLWhenPausing()) {
                                this.eglHelper.finish();
                            }
                            if (!this.hasSurface && !this.waitingForSurface) {
                                if (this.haveEglSurface) {
                                    this.stopEglSurfaceLocked();
                                }
                                this.waitingForSurface = true;
                                this.surfaceIsBad = false;
                                GLTextureView.access$900().notifyAll();
                            }
                            if (this.hasSurface && this.waitingForSurface) {
                                this.waitingForSurface = false;
                                GLTextureView.access$900().notifyAll();
                            }
                            if (doRenderNotification) {
                                wantRenderNotification = false;
                                doRenderNotification = false;
                                this.renderComplete = true;
                                GLTextureView.access$900().notifyAll();
                            }
                            if (this.readyToDraw()) {
                                if (!this.haveEglContext) {
                                    if (askedToReleaseEglContext) {
                                        askedToReleaseEglContext = false;
                                    } else if (GLTextureView.access$900().tryAcquireEglContextLocked(this)) {
                                        try {
                                            this.eglHelper.start();
                                        }
                                        catch (RuntimeException t) {
                                            GLTextureView.access$900().releaseEglContextLocked(this);
                                            throw t;
                                        }
                                        this.haveEglContext = true;
                                        createEglContext = true;
                                        GLTextureView.access$900().notifyAll();
                                    }
                                }
                                if (this.haveEglContext && !this.haveEglSurface) {
                                    this.haveEglSurface = true;
                                    createEglSurface = true;
                                    createGlInterface = true;
                                    sizeChanged = true;
                                }
                                if (this.haveEglSurface) {
                                    if (this.sizeChanged) {
                                        sizeChanged = true;
                                        w = this.width;
                                        h = this.height;
                                        wantRenderNotification = true;
                                        createEglSurface = true;
                                        this.sizeChanged = false;
                                    }
                                    this.requestRender = false;
                                    GLTextureView.access$900().notifyAll();
                                    break;
                                }
                            }
                            GLTextureView.access$900().wait();
                        }
                        ** if (event == null) goto lbl100
                    }
lbl-1000:
                    // 1 sources

                    {
                        event.run();
                        event = null;
                        continue;
                    }
lbl100:
                    // 1 sources

                    if (createEglSurface) {
                        if (!this.eglHelper.createSurface()) {
                            var13_13 = GLTextureView.access$900();
                            synchronized (var13_13) {
                                this.surfaceIsBad = true;
                                GLTextureView.access$900().notifyAll();
                                continue;
                            }
                        }
                        createEglSurface = false;
                    }
                    if (createGlInterface) {
                        gl = (GL10)this.eglHelper.createGL();
                        GLTextureView.access$900().checkGLDriver(gl);
                        createGlInterface = false;
                    }
                    if (createEglContext) {
                        view = (GLTextureView)this.glTextureViewWeakRef.get();
                        if (view != null) {
                            GLTextureView.access$1100(view).onSurfaceCreated(gl, this.eglHelper.eglConfig);
                        }
                        createEglContext = false;
                    }
                    if (sizeChanged) {
                        view = (GLTextureView)this.glTextureViewWeakRef.get();
                        if (view != null) {
                            GLTextureView.access$1100(view).onSurfaceChanged(gl, w, h);
                        }
                        sizeChanged = false;
                    }
                    if ((view = (GLTextureView)this.glTextureViewWeakRef.get()) != null) {
                        GLTextureView.access$1100(view).onDrawFrame(gl);
                    }
                    swapError = this.eglHelper.swap();
                    switch (swapError) {
                        case 12288: {
                            break;
                        }
                        case 12302: {
                            lostEglContext = true;
                            break;
                        }
                        default: {
                            EglHelper.logEglErrorAsWarning("GLThread", "eglSwapBuffers", swapError);
                            var14_17 = GLTextureView.access$900();
                            synchronized (var14_17) {
                                this.surfaceIsBad = true;
                                GLTextureView.access$900().notifyAll();
                                break;
                            }
                        }
                    }
                    if (!wantRenderNotification) continue;
                    doRenderNotification = true;
                }
            }
            finally {
                var14_15 = GLTextureView.access$900();
                synchronized (var14_15) {
                    this.stopEglSurfaceLocked();
                    this.stopEglContextLocked();
                }
            }
        }

        public boolean ableToDraw() {
            return this.haveEglContext && this.haveEglSurface && this.readyToDraw();
        }

        private boolean readyToDraw() {
            return !this.paused && this.hasSurface && !this.surfaceIsBad && this.width > 0 && this.height > 0 && (this.requestRender || this.renderMode == 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRenderMode(int renderMode) {
            if (0 > renderMode || renderMode > 1) {
                throw new IllegalArgumentException("renderMode");
            }
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                this.renderMode = renderMode;
                glThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRenderMode() {
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                return this.renderMode;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestRender() {
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                this.requestRender = true;
                glThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceCreated() {
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                this.hasSurface = true;
                glThreadManager.notifyAll();
                while (this.waitingForSurface && !this.exited) {
                    try {
                        glThreadManager.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceDestroyed() {
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                this.hasSurface = false;
                glThreadManager.notifyAll();
                while (!this.waitingForSurface && !this.exited) {
                    try {
                        glThreadManager.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPause() {
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                this.requestPaused = true;
                glThreadManager.notifyAll();
                while (!this.exited && !this.paused) {
                    try {
                        glThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResume() {
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                this.requestPaused = false;
                this.requestRender = true;
                this.renderComplete = false;
                glThreadManager.notifyAll();
                while (!this.exited && this.paused && !this.renderComplete) {
                    try {
                        glThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWindowResize(int w, int h) {
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                this.width = w;
                this.height = h;
                this.sizeChanged = true;
                this.requestRender = true;
                this.renderComplete = false;
                glThreadManager.notifyAll();
                while (!this.exited && !this.paused && !this.renderComplete && this.ableToDraw()) {
                    try {
                        glThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestExitAndWait() {
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                this.shouldExit = true;
                glThreadManager.notifyAll();
                while (!this.exited) {
                    try {
                        glThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        public void requestReleaseEglContextLocked() {
            this.shouldReleaseEglContext = true;
            glThreadManager.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueEvent(Runnable r) {
            if (r == null) {
                throw new IllegalArgumentException("r must not be null");
            }
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                this.eventQueue.add(r);
                glThreadManager.notifyAll();
            }
        }
    }

    private static class EglHelper {
        private WeakReference<GLTextureView> glTextureViewWeakRef;
        EGL10 egl;
        EGLDisplay eglDisplay;
        EGLSurface eglSurface;
        EGLConfig eglConfig;
        EGLContext eglContext;

        public EglHelper(WeakReference<GLTextureView> glTextureViewWeakReference) {
            this.glTextureViewWeakRef = glTextureViewWeakReference;
        }

        public void start() {
            this.egl = (EGL10)EGLContext.getEGL();
            this.eglDisplay = this.egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (this.eglDisplay == EGL10.EGL_NO_DISPLAY) {
                throw new RuntimeException("eglGetDisplay failed");
            }
            int[] version = new int[2];
            if (!this.egl.eglInitialize(this.eglDisplay, version)) {
                throw new RuntimeException("eglInitialize failed");
            }
            GLTextureView view = (GLTextureView)((Object)this.glTextureViewWeakRef.get());
            if (view == null) {
                this.eglConfig = null;
                this.eglContext = null;
            } else {
                this.eglConfig = view.eglConfigChooser.chooseConfig(this.egl, this.eglDisplay);
                this.eglContext = view.eglContextFactory.createContext(this.egl, this.eglDisplay, this.eglConfig);
            }
            if (this.eglContext == null || this.eglContext == EGL10.EGL_NO_CONTEXT) {
                this.eglContext = null;
                this.throwEglException("createContext");
            }
            this.eglSurface = null;
        }

        public boolean createSurface() {
            if (this.egl == null) {
                throw new RuntimeException("egl not initialized");
            }
            if (this.eglDisplay == null) {
                throw new RuntimeException("eglDisplay not initialized");
            }
            if (this.eglConfig == null) {
                throw new RuntimeException("eglConfig not initialized");
            }
            this.destroySurfaceImp();
            GLTextureView view = (GLTextureView)((Object)this.glTextureViewWeakRef.get());
            this.eglSurface = view != null ? view.eglWindowSurfaceFactory.createWindowSurface(this.egl, this.eglDisplay, this.eglConfig, view.getSurfaceTexture()) : null;
            if (this.eglSurface == null || this.eglSurface == EGL10.EGL_NO_SURFACE) {
                int error = this.egl.eglGetError();
                if (error == 12299) {
                    Log.e((String)"EglHelper", (String)"createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                }
                return false;
            }
            if (!this.egl.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext)) {
                EglHelper.logEglErrorAsWarning("EGLHelper", "eglMakeCurrent", this.egl.eglGetError());
                return false;
            }
            return true;
        }

        GL createGL() {
            GL gl = this.eglContext.getGL();
            GLTextureView view = (GLTextureView)((Object)this.glTextureViewWeakRef.get());
            if (view != null) {
                if (view.glWrapper != null) {
                    gl = view.glWrapper.wrap(gl);
                }
                if ((view.debugFlags & 3) != 0) {
                    int configFlags = 0;
                    LogWriter log = null;
                    if ((view.debugFlags & 1) != 0) {
                        configFlags |= 1;
                    }
                    if ((view.debugFlags & 2) != 0) {
                        log = new LogWriter();
                    }
                    gl = GLDebugHelper.wrap((GL)gl, (int)configFlags, (Writer)log);
                }
            }
            return gl;
        }

        public int swap() {
            if (!this.egl.eglSwapBuffers(this.eglDisplay, this.eglSurface)) {
                return this.egl.eglGetError();
            }
            return 12288;
        }

        public void destroySurface() {
            this.destroySurfaceImp();
        }

        private void destroySurfaceImp() {
            if (this.eglSurface != null && this.eglSurface != EGL10.EGL_NO_SURFACE) {
                this.egl.eglMakeCurrent(this.eglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                GLTextureView view = (GLTextureView)((Object)this.glTextureViewWeakRef.get());
                if (view != null) {
                    view.eglWindowSurfaceFactory.destroySurface(this.egl, this.eglDisplay, this.eglSurface);
                }
                this.eglSurface = null;
            }
        }

        public void finish() {
            if (this.eglContext != null) {
                GLTextureView view = (GLTextureView)((Object)this.glTextureViewWeakRef.get());
                if (view != null) {
                    view.eglContextFactory.destroyContext(this.egl, this.eglDisplay, this.eglContext);
                }
                this.eglContext = null;
            }
            if (this.eglDisplay != null) {
                this.egl.eglTerminate(this.eglDisplay);
                this.eglDisplay = null;
            }
        }

        private void throwEglException(String function) {
            EglHelper.throwEglException(function, this.egl.eglGetError());
        }

        public static void throwEglException(String function, int error) {
            String message = EglHelper.formatEglError(function, error);
            throw new RuntimeException(message);
        }

        public static void logEglErrorAsWarning(String tag, String function, int error) {
            Log.w((String)tag, (String)EglHelper.formatEglError(function, error));
        }

        public static String formatEglError(String function, int error) {
            return function + " failed: " + error;
        }
    }

    private class SimpleEGLConfigChooser
    extends ComponentSizeChooser {
        public SimpleEGLConfigChooser(boolean withDepthBuffer) {
            super(8, 8, 8, 0, withDepthBuffer ? 16 : 0, 0);
        }
    }

    private class ComponentSizeChooser
    extends BaseConfigChooser {
        private int[] value;
        protected int redSize;
        protected int greenSize;
        protected int blueSize;
        protected int alphaSize;
        protected int depthSize;
        protected int stencilSize;

        public ComponentSizeChooser(int redSize, int greenSize, int blueSize, int alphaSize, int depthSize, int stencilSize) {
            super(new int[]{12324, redSize, 12323, greenSize, 12322, blueSize, 12321, alphaSize, 12325, depthSize, 12326, stencilSize, 12344});
            this.value = new int[1];
            this.redSize = redSize;
            this.greenSize = greenSize;
            this.blueSize = blueSize;
            this.alphaSize = alphaSize;
            this.depthSize = depthSize;
            this.stencilSize = stencilSize;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            for (EGLConfig config : configs) {
                int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                if (d < this.depthSize || s < this.stencilSize) continue;
                int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                if (r != this.redSize || g != this.greenSize || b != this.blueSize || a != this.alphaSize) continue;
                return config;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.value)) {
                return this.value[0];
            }
            return defaultValue;
        }
    }

    private abstract class BaseConfigChooser
    implements EGLConfigChooser {
        protected int[] mConfigSpec;

        public BaseConfigChooser(int[] configSpec) {
            this.mConfigSpec = this.filterConfigSpec(configSpec);
        }

        @Override
        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] num_config = new int[1];
            if (!egl.eglChooseConfig(display, this.mConfigSpec, null, 0, num_config)) {
                throw new IllegalArgumentException("eglChooseConfig failed");
            }
            int numConfigs = num_config[0];
            if (numConfigs <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGLConfig[] configs = new EGLConfig[numConfigs];
            if (!egl.eglChooseConfig(display, this.mConfigSpec, configs, numConfigs, num_config)) {
                throw new IllegalArgumentException("eglChooseConfig#2 failed");
            }
            EGLConfig config = this.chooseConfig(egl, display, configs);
            if (config == null) {
                throw new IllegalArgumentException("No config chosen");
            }
            return config;
        }

        abstract EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2, EGLConfig[] var3);

        private int[] filterConfigSpec(int[] configSpec) {
            if (GLTextureView.this.eglContextClientVersion != 2) {
                return configSpec;
            }
            int len = configSpec.length;
            int[] newConfigSpec = new int[len + 2];
            System.arraycopy(configSpec, 0, newConfigSpec, 0, len - 1);
            newConfigSpec[len - 1] = 12352;
            newConfigSpec[len] = 4;
            newConfigSpec[len + 1] = 12344;
            return newConfigSpec;
        }
    }

    public static interface EGLConfigChooser {
        public EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2);
    }

    private static class DefaultWindowSurfaceFactory
    implements EGLWindowSurfaceFactory {
        private DefaultWindowSurfaceFactory() {
        }

        @Override
        public EGLSurface createWindowSurface(EGL10 egl, EGLDisplay display, EGLConfig config, Object nativeWindow) {
            EGLSurface result = null;
            try {
                result = egl.eglCreateWindowSurface(display, config, nativeWindow, null);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)TAG, (String)"eglCreateWindowSurface", (Throwable)e);
            }
            return result;
        }

        @Override
        public void destroySurface(EGL10 egl, EGLDisplay display, EGLSurface surface) {
            egl.eglDestroySurface(display, surface);
        }
    }

    public static interface EGLWindowSurfaceFactory {
        public EGLSurface createWindowSurface(EGL10 var1, EGLDisplay var2, EGLConfig var3, Object var4);

        public void destroySurface(EGL10 var1, EGLDisplay var2, EGLSurface var3);
    }

    private class DefaultContextFactory
    implements EGLContextFactory {
        private int EGL_CONTEXT_CLIENT_VERSION = 12440;

        private DefaultContextFactory() {
        }

        @Override
        public EGLContext createContext(EGL10 egl, EGLDisplay display, EGLConfig config) {
            int[] attrib_list = new int[]{this.EGL_CONTEXT_CLIENT_VERSION, GLTextureView.this.eglContextClientVersion, 12344};
            return egl.eglCreateContext(display, config, EGL10.EGL_NO_CONTEXT, (int[])(GLTextureView.this.eglContextClientVersion != 0 ? attrib_list : null));
        }

        @Override
        public void destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
            if (!egl.eglDestroyContext(display, context)) {
                Log.e((String)"DefaultContextFactory", (String)("display:" + display + " context: " + context));
                EglHelper.throwEglException("eglDestroyContex", egl.eglGetError());
            }
        }
    }

    public static interface EGLContextFactory {
        public EGLContext createContext(EGL10 var1, EGLDisplay var2, EGLConfig var3);

        public void destroyContext(EGL10 var1, EGLDisplay var2, EGLContext var3);
    }

    public static interface Renderer {
        public void onSurfaceCreated(GL10 var1, EGLConfig var2);

        public void onSurfaceChanged(GL10 var1, int var2, int var3);

        public void onDrawFrame(GL10 var1);
    }

    public static interface GLWrapper {
        public GL wrap(GL var1);
    }
}

