/*
 * Decompiled with CFR 0.152.
 */
package video.pano.android.gpuimage;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.opengl.GLSurfaceView;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.concurrent.Semaphore;
import video.pano.android.gpuimage.GLTextureView;
import video.pano.android.gpuimage.GPUImage;
import video.pano.android.gpuimage.GPUImageNativeLibrary;
import video.pano.android.gpuimage.R;
import video.pano.android.gpuimage.filter.GPUImageFilter;
import video.pano.android.gpuimage.util.Rotation;

public class GPUImageView
extends FrameLayout {
    private int surfaceType = 0;
    private View surfaceView;
    private GPUImage gpuImage;
    private boolean isShowLoading = true;
    private GPUImageFilter filter;
    public Size forceSize = null;
    private float ratio = 0.0f;
    public static final int RENDERMODE_WHEN_DIRTY = 0;
    public static final int RENDERMODE_CONTINUOUSLY = 1;

    public GPUImageView(Context context) {
        super(context);
        this.init(context, null);
    }

    public GPUImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.GPUImageView, 0, 0);
            try {
                this.surfaceType = a.getInt(R.styleable.GPUImageView_gpuimage_surface_type, this.surfaceType);
                this.isShowLoading = a.getBoolean(R.styleable.GPUImageView_gpuimage_show_loading, this.isShowLoading);
            }
            finally {
                a.recycle();
            }
        }
        this.gpuImage = new GPUImage(context);
        if (this.surfaceType == 1) {
            this.surfaceView = new GPUImageGLTextureView(context, attrs);
            this.gpuImage.setGLTextureView((GLTextureView)this.surfaceView);
        } else {
            this.surfaceView = new GPUImageGLSurfaceView(context, attrs);
            this.gpuImage.setGLSurfaceView((GLSurfaceView)this.surfaceView);
        }
        this.addView(this.surfaceView);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.ratio != 0.0f) {
            int newHeight;
            int newWidth;
            int height;
            int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            if ((float)width / this.ratio < (float)(height = View.MeasureSpec.getSize((int)heightMeasureSpec))) {
                newWidth = width;
                newHeight = Math.round((float)width / this.ratio);
            } else {
                newHeight = height;
                newWidth = Math.round((float)height * this.ratio);
            }
            int newWidthSpec = View.MeasureSpec.makeMeasureSpec((int)newWidth, (int)0x40000000);
            int newHeightSpec = View.MeasureSpec.makeMeasureSpec((int)newHeight, (int)0x40000000);
            super.onMeasure(newWidthSpec, newHeightSpec);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public GPUImage getGPUImage() {
        return this.gpuImage;
    }

    @Deprecated
    public void setUpCamera(Camera camera) {
        this.gpuImage.setUpCamera(camera);
    }

    @Deprecated
    public void setUpCamera(Camera camera, int degrees, boolean flipHorizontal, boolean flipVertical) {
        this.gpuImage.setUpCamera(camera, degrees, flipHorizontal, flipVertical);
    }

    public void updatePreviewFrame(byte[] data, int width, int height) {
        this.gpuImage.updatePreviewFrame(data, width, height);
    }

    public void setBackgroundColor(float red, float green, float blue) {
        this.gpuImage.setBackgroundColor(red, green, blue);
    }

    public void setRenderMode(int renderMode) {
        if (this.surfaceView instanceof GLSurfaceView) {
            ((GLSurfaceView)this.surfaceView).setRenderMode(renderMode);
        } else if (this.surfaceView instanceof GLTextureView) {
            ((GLTextureView)this.surfaceView).setRenderMode(renderMode);
        }
    }

    public void setRatio(float ratio) {
        this.ratio = ratio;
        this.surfaceView.requestLayout();
        this.gpuImage.deleteImage();
    }

    public void setScaleType(GPUImage.ScaleType scaleType) {
        this.gpuImage.setScaleType(scaleType);
    }

    public void setRotation(Rotation rotation) {
        this.gpuImage.setRotation(rotation);
        this.requestRender();
    }

    public void setFilter(GPUImageFilter filter) {
        this.filter = filter;
        this.gpuImage.setFilter(filter);
        this.requestRender();
    }

    public GPUImageFilter getFilter() {
        return this.filter;
    }

    public void setImage(Bitmap bitmap) {
        this.gpuImage.setImage(bitmap);
    }

    public void setImage(Uri uri) {
        this.gpuImage.setImage(uri);
    }

    public void setImage(File file) {
        this.gpuImage.setImage(file);
    }

    public void requestRender() {
        if (this.surfaceView instanceof GLSurfaceView) {
            ((GLSurfaceView)this.surfaceView).requestRender();
        } else if (this.surfaceView instanceof GLTextureView) {
            ((GLTextureView)this.surfaceView).requestRender();
        }
    }

    public void saveToPictures(String folderName, String fileName, OnPictureSavedListener listener) {
        new SaveTask(folderName, fileName, listener).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    public void saveToPictures(String folderName, String fileName, int width, int height, OnPictureSavedListener listener) {
        new SaveTask(folderName, fileName, width, height, listener).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    public Bitmap capture(int width, int height) throws InterruptedException {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new IllegalStateException("Do not call this method from the UI thread!");
        }
        this.forceSize = new Size(width, height);
        final Semaphore waiter = new Semaphore(0);
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    GPUImageView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    GPUImageView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                waiter.release();
            }
        });
        this.post(new Runnable(){

            @Override
            public void run() {
                if (GPUImageView.this.isShowLoading) {
                    GPUImageView.this.addView((View)new LoadingView(GPUImageView.this.getContext()));
                }
                GPUImageView.this.surfaceView.requestLayout();
            }
        });
        waiter.acquire();
        this.gpuImage.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                waiter.release();
            }
        });
        this.requestRender();
        waiter.acquire();
        Bitmap bitmap = this.capture();
        this.forceSize = null;
        this.post(new Runnable(){

            @Override
            public void run() {
                GPUImageView.this.surfaceView.requestLayout();
            }
        });
        this.requestRender();
        if (this.isShowLoading) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    GPUImageView.this.removeViewAt(1);
                }
            }, 300L);
        }
        return bitmap;
    }

    public Bitmap capture() throws InterruptedException {
        final Semaphore waiter = new Semaphore(0);
        int width = this.surfaceView.getMeasuredWidth();
        int height = this.surfaceView.getMeasuredHeight();
        final Bitmap resultBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.gpuImage.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GPUImageNativeLibrary.adjustBitmap(resultBitmap);
                waiter.release();
            }
        });
        this.requestRender();
        waiter.acquire();
        return resultBitmap;
    }

    public void onPause() {
        if (this.surfaceView instanceof GLSurfaceView) {
            ((GLSurfaceView)this.surfaceView).onPause();
        } else if (this.surfaceView instanceof GLTextureView) {
            ((GLTextureView)this.surfaceView).onPause();
        }
    }

    public void onResume() {
        if (this.surfaceView instanceof GLSurfaceView) {
            ((GLSurfaceView)this.surfaceView).onResume();
        } else if (this.surfaceView instanceof GLTextureView) {
            ((GLTextureView)this.surfaceView).onResume();
        }
    }

    public static interface OnPictureSavedListener {
        public void onPictureSaved(Uri var1);
    }

    private class SaveTask
    extends AsyncTask<Void, Void, Void> {
        private final String folderName;
        private final String fileName;
        private final int width;
        private final int height;
        private final OnPictureSavedListener listener;
        private final Handler handler;

        public SaveTask(String folderName, String fileName, OnPictureSavedListener listener) {
            this(folderName, fileName, 0, 0, listener);
        }

        public SaveTask(String folderName, String fileName, int width, int height, OnPictureSavedListener listener) {
            this.folderName = folderName;
            this.fileName = fileName;
            this.width = width;
            this.height = height;
            this.listener = listener;
            this.handler = new Handler();
        }

        protected Void doInBackground(Void ... params) {
            try {
                Bitmap result = this.width != 0 ? GPUImageView.this.capture(this.width, this.height) : GPUImageView.this.capture();
                this.saveImage(this.folderName, this.fileName, result);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return null;
        }

        private void saveImage(String folderName, String fileName, Bitmap image) {
            File path = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
            File file = new File(path, folderName + "/" + fileName);
            try {
                file.getParentFile().mkdirs();
                image.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)new FileOutputStream(file));
                MediaScannerConnection.scanFile((Context)GPUImageView.this.getContext(), (String[])new String[]{file.toString()}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

                    public void onScanCompleted(String path, final Uri uri) {
                        if (SaveTask.this.listener != null) {
                            SaveTask.this.handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    SaveTask.this.listener.onPictureSaved(uri);
                                }
                            });
                        }
                    }
                });
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private class LoadingView
    extends FrameLayout {
        public LoadingView(Context context) {
            super(context);
            this.init();
        }

        public LoadingView(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.init();
        }

        public LoadingView(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
            this.init();
        }

        private void init() {
            ProgressBar view = new ProgressBar(this.getContext());
            view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
            this.addView((View)view);
            this.setBackgroundColor(-16777216);
        }
    }

    private class GPUImageGLTextureView
    extends GLTextureView {
        public GPUImageGLTextureView(Context context) {
            super(context);
        }

        public GPUImageGLTextureView(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            if (GPUImageView.this.forceSize != null) {
                super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)GPUImageView.this.forceSize.width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)GPUImageView.this.forceSize.height, (int)0x40000000));
            } else {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        }
    }

    private class GPUImageGLSurfaceView
    extends GLSurfaceView {
        public GPUImageGLSurfaceView(Context context) {
            super(context);
        }

        public GPUImageGLSurfaceView(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            if (GPUImageView.this.forceSize != null) {
                super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)GPUImageView.this.forceSize.width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)GPUImageView.this.forceSize.height, (int)0x40000000));
            } else {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        }
    }

    public static class Size {
        int width;
        int height;

        public Size(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

