/*
 * Decompiled with CFR 0.152.
 */
package video.pano.android.gpuimage.filter;

import android.opengl.GLES20;
import video.pano.android.gpuimage.filter.GPUImageFilter;

public class GPUImageVibranceFilter
extends GPUImageFilter {
    public static final String VIBRANCE_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\nuniform lowp float vibrance;\n\nvoid main() {\n    lowp vec4 color = texture2D(inputImageTexture, textureCoordinate);\n    lowp float average = (color.r + color.g + color.b) / 3.0;\n    lowp float mx = max(color.r, max(color.g, color.b));\n    lowp float amt = (mx - average) * (-vibrance * 3.0);\n    color.rgb = mix(color.rgb, vec3(mx), amt);\n    gl_FragColor = color;\n}";
    private int vibranceLocation;
    private float vibrance;

    @Override
    public void onInit() {
        super.onInit();
        this.vibranceLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"vibrance");
    }

    public GPUImageVibranceFilter() {
        this(0.0f);
    }

    public GPUImageVibranceFilter(float vibrance) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", VIBRANCE_FRAGMENT_SHADER);
        this.vibrance = vibrance;
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setVibrance(this.vibrance);
    }

    public void setVibrance(float vibrance) {
        this.vibrance = vibrance;
        if (this.isInitialized()) {
            this.setFloat(this.vibranceLocation, vibrance);
        }
    }
}

