/*
 * Decompiled with CFR 0.152.
 */
package video.pano;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.view.WindowManager;
import java.util.ArrayList;
import java.util.List;
import video.pano.CameraVideoCapturer;
import video.pano.Logging;

public class AreaFocus {
    private String TAG = "AreaFocus";
    private Camera mCamera;
    private Context mContext;
    private Camera.AutoFocusCallback mAutoFocusCallback;
    private Rect mCurrentRect;
    private CameraVideoCapturer.AreaFocusCallback mCallback;

    AreaFocus(Context context) {
        this.mContext = context;
        this.mAutoFocusCallback = (success, camera) -> {
            Logging.d(this.TAG, "Camera AreaFocus success:" + success + " Rect: " + this.mCurrentRect);
            if (this.mCallback != null) {
                this.mCallback.focusArea(success ? this.mCurrentRect : null);
            }
            try {
                camera.cancelAutoFocus();
                camera.autoFocus(null);
                Camera.Parameters parameters = camera.getParameters();
                List focusModes = parameters.getSupportedFocusModes();
                if (focusModes != null && focusModes.contains("continuous-video")) {
                    parameters.setFocusMode("continuous-video");
                    Logging.d(this.TAG, "set focus mode continuous-video");
                }
                this.mCamera.setParameters(parameters);
            }
            catch (Exception e) {
                Logging.e(this.TAG, "Camera AreaFocus reset FOCUS_MODE_CONTINUOUS_VIDEO failed:" + e.getMessage());
            }
        };
    }

    void setCamera(Camera camera) {
        this.mCamera = camera;
    }

    void setFocusCallback(CameraVideoCapturer.AreaFocusCallback callback) {
        this.mCallback = callback;
    }

    void destory() {
        this.mContext = null;
        this.mCamera = null;
        this.mAutoFocusCallback = null;
        this.mCallback = null;
    }

    void focusArea(float x, float y, int size, boolean onlyMetering) {
        if (this.mCamera == null || this.mAutoFocusCallback == null) {
            return;
        }
        try {
            Rect meteringRect = this.calculateTapArea(x, y, 1.0f, size);
            Camera.Parameters parameters = this.mCamera.getParameters();
            if (!onlyMetering) {
                this.mCamera.cancelAutoFocus();
                Rect focusRect = this.calculateTapArea(x, y, 1.0f, size);
                parameters.setFocusMode("auto");
                if (parameters.getMaxNumFocusAreas() > 0) {
                    ArrayList<Camera.Area> focusAreas = new ArrayList<Camera.Area>();
                    focusAreas.add(new Camera.Area(focusRect, 1000));
                    parameters.setFocusAreas(focusAreas);
                } else {
                    return;
                }
            }
            if (parameters.getMaxNumMeteringAreas() > 0 && onlyMetering) {
                ArrayList<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
                meteringAreas.add(new Camera.Area(meteringRect, 1000));
                parameters.setMeteringAreas(meteringAreas);
            }
            try {
                this.mCamera.setParameters(parameters);
            }
            catch (Exception e) {
                Logging.e(this.TAG, "focusArea failed: " + e.getMessage());
            }
            if (!onlyMetering) {
                this.mCamera.autoFocus(this.mAutoFocusCallback);
            }
        }
        catch (Exception e) {
            Logging.w(this.TAG, "Camera AreaFocus failed:" + e.getMessage());
        }
    }

    private int getRotation() {
        if (this.mContext == null) {
            return 0;
        }
        return ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
    }

    private Rect calculateTapArea(float x, float y, float coefficient, int focusAreaSize) {
        if (this.mContext == null) {
            return null;
        }
        int areaSize = Float.valueOf((float)focusAreaSize * coefficient).intValue();
        int centerY = 0;
        int centerX = 0;
        int rotation = this.getRotation();
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        int screenW = wm.getDefaultDisplay().getWidth();
        int screenH = wm.getDefaultDisplay().getHeight();
        this.mCurrentRect = new Rect(Math.round(x - (float)(focusAreaSize / 2)), Math.round(y - (float)(focusAreaSize / 2)), Math.round(x + (float)(focusAreaSize / 2)), Math.round(y + (float)(focusAreaSize / 2)));
        switch (rotation) {
            case 0: 
            case 2: {
                centerY = (int)(x / (float)screenW * 2000.0f - 1000.0f);
                centerX = (int)(y / (float)screenH * 2000.0f - 1000.0f);
                break;
            }
            case 1: {
                centerY = (int)(-x / (float)screenW * 2000.0f + 1000.0f);
                centerX = (int)(-y / (float)screenH * 2000.0f + 1000.0f);
                break;
            }
            case 3: {
                centerY = (int)(-x / (float)screenW * 2000.0f + 1000.0f);
                centerX = (int)(y / (float)screenH * 2000.0f - 1000.0f);
                break;
            }
        }
        int left = this.clamp(centerX - areaSize / 2, -1000, 1000);
        int top = this.clamp(centerY - areaSize / 2, -1000, 1000);
        float right = left + areaSize;
        if (right > 1000.0f) {
            right = 1000.0f;
        } else if (right < -1000.0f) {
            right = -1000.0f;
        }
        float bottom = top + areaSize;
        if (bottom > 1000.0f) {
            bottom = 1000.0f;
        } else if (bottom < -1000.0f) {
            bottom = -1000.0f;
        }
        RectF rectF = new RectF((float)left, (float)top, right, bottom);
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    private int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }
}

