/*
 * Decompiled with CFR 0.152.
 */
package video.pano;

import java.util.ArrayList;
import java.util.HashMap;
import video.pano.LibH264Decoder;
import video.pano.LibvpxVp8Decoder;
import video.pano.LibvpxVp9Decoder;
import video.pano.VideoCodecInfo;
import video.pano.VideoDecoder;
import video.pano.VideoDecoderFactory;

public class SoftwareVideoDecoderFactory
implements VideoDecoderFactory {
    @Override
    @Deprecated
    public VideoDecoder createDecoder(String codecType) {
        return this.createDecoder(new VideoCodecInfo(codecType, new HashMap<String, String>()));
    }

    @Override
    public VideoDecoder createDecoder(VideoCodecInfo codecType) {
        if (codecType.getName().equalsIgnoreCase("VP8")) {
            return new LibvpxVp8Decoder();
        }
        if (codecType.getName().equalsIgnoreCase("VP9") && LibvpxVp9Decoder.nativeIsSupported()) {
            return new LibvpxVp9Decoder();
        }
        if (codecType.getName().equalsIgnoreCase("H264") && LibH264Decoder.nativeIsSupported()) {
            return new LibH264Decoder();
        }
        return null;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        return SoftwareVideoDecoderFactory.supportedCodecs();
    }

    static VideoCodecInfo[] supportedCodecs() {
        ArrayList<VideoCodecInfo> codecs = new ArrayList<VideoCodecInfo>();
        codecs.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
        if (LibvpxVp9Decoder.nativeIsSupported()) {
            codecs.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
        }
        if (LibH264Decoder.nativeIsSupported()) {
            codecs.add(new VideoCodecInfo("H264", new HashMap<String, String>()));
        }
        return codecs.toArray(new VideoCodecInfo[codecs.size()]);
    }
}

