/*
 * Decompiled with CFR 0.152.
 */
package com.pano.coco.api.model;

import android.app.ActivityManager;
import android.os.Build;
import android.os.Debug;
import android.os.Process;
import android.os.SystemClock;
import com.pano.coco.impl.GlobalRef;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class RTCSystemInfoHelper {
    private static long[] mPreTotalAndIdle;
    private static float mPreProcessCpuTime;
    private final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String path = pathname.getName();
            if (path.startsWith("cpu")) {
                for (int i = 3; i < path.length(); ++i) {
                    if (path.charAt(i) >= '0' && path.charAt(i) <= '9') continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };

    public static boolean isSupported() {
        return Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 26 && GlobalRef.applicationContext != null;
    }

    public static int[] getCpuRateNoSleep() {
        if (mPreTotalAndIdle == null) {
            float[] cpuRate = RTCSystemInfoHelper.getCpuRate();
            mPreTotalAndIdle = RTCSystemInfoHelper.getTotalCpuTime();
            mPreProcessCpuTime = RTCSystemInfoHelper.getAppCpuTime();
            if (cpuRate != null) {
                return new int[]{(int)cpuRate[0], (int)cpuRate[1]};
            }
            return new int[]{0, 0};
        }
        float totalCpuTime1 = mPreTotalAndIdle[0];
        float idleCpu1 = mPreTotalAndIdle[1];
        float processCpuTime1 = mPreProcessCpuTime;
        long[] totalAndIdle2 = RTCSystemInfoHelper.getTotalCpuTime();
        if (totalAndIdle2 == null) {
            return new int[]{0, 0};
        }
        float totalCpuTime2 = totalAndIdle2[0];
        float idleCpu2 = totalAndIdle2[1];
        float processCpuTime2 = RTCSystemInfoHelper.getAppCpuTime();
        float cpuAppRate = 100.0f * (processCpuTime2 - processCpuTime1) / (totalCpuTime2 - totalCpuTime1);
        float cpuTotalRate = 100.0f * (totalCpuTime2 - totalCpuTime1 - (idleCpu2 - idleCpu1)) / (totalCpuTime2 - totalCpuTime1);
        mPreTotalAndIdle = totalAndIdle2;
        mPreProcessCpuTime = processCpuTime2;
        return new int[]{(int)cpuAppRate, (int)cpuTotalRate};
    }

    public static int getAppMemorySize() {
        int pid = Process.myPid();
        ActivityManager am = (ActivityManager)GlobalRef.applicationContext.getSystemService("activity");
        int[] myMempid = new int[]{pid};
        Debug.MemoryInfo[] memoryInfo = am.getProcessMemoryInfo(myMempid);
        memoryInfo[0].getTotalSharedDirty();
        return memoryInfo[0].getTotalPss();
    }

    public static long getFreeMemorySize() {
        ActivityManager.MemoryInfo outInfo = new ActivityManager.MemoryInfo();
        ActivityManager am = (ActivityManager)GlobalRef.applicationContext.getSystemService("activity");
        am.getMemoryInfo(outInfo);
        long avaliMem = outInfo.availMem;
        return avaliMem / 1024L;
    }

    public static long getTotalMemory() {
        String memInfoPath = "/proc/meminfo";
        String readTemp = "";
        String memTotal = "";
        long memory = 0L;
        try {
            FileReader fr = new FileReader(memInfoPath);
            BufferedReader localBufferedReader = new BufferedReader(fr, 8192);
            while ((readTemp = localBufferedReader.readLine()) != null) {
                if (!readTemp.contains("MemTotal")) continue;
                String[] total = readTemp.split(":");
                memTotal = total[1].trim();
            }
            localBufferedReader.close();
            String[] memKb = memTotal.split(" ");
            memTotal = memKb[0].trim();
            memory = Long.parseLong(memTotal);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return memory;
    }

    public int getCpuNum() {
        try {
            File dir = new File("/sys/devices/system/cpu/");
            File[] files = dir.listFiles(this.CPU_FILTER);
            return files.length;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    private static float[] getCpuRate() {
        long[] totalAndIdle1 = RTCSystemInfoHelper.getTotalCpuTime();
        if (totalAndIdle1 == null) {
            return null;
        }
        float totalCpuTime1 = totalAndIdle1[0];
        float idleCpu1 = totalAndIdle1[1];
        float processCpuTime1 = RTCSystemInfoHelper.getAppCpuTime();
        SystemClock.sleep((long)360L);
        long[] totalAndIdle2 = RTCSystemInfoHelper.getTotalCpuTime();
        if (totalAndIdle2 == null) {
            return null;
        }
        float totalCpuTime2 = totalAndIdle2[0];
        float idleCpu2 = totalAndIdle2[1];
        float processCpuTime2 = RTCSystemInfoHelper.getAppCpuTime();
        float cpuAppRate = 100.0f * (processCpuTime2 - processCpuTime1) / (totalCpuTime2 - totalCpuTime1);
        float cpuTotalRate = 100.0f * (totalCpuTime2 - totalCpuTime1 - (idleCpu2 - idleCpu1)) / (totalCpuTime2 - totalCpuTime1);
        return new float[]{cpuAppRate, cpuTotalRate};
    }

    private static long[] getTotalCpuTime() {
        String[] cpuInfos = null;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/stat")), 1000);
            String load = reader.readLine();
            reader.close();
            cpuInfos = load.split(" ");
            long idleCpu = Long.parseLong(cpuInfos[5]);
            long totalCpu = Long.parseLong(cpuInfos[2]) + Long.parseLong(cpuInfos[3]) + Long.parseLong(cpuInfos[4]) + Long.parseLong(cpuInfos[6]) + Long.parseLong(cpuInfos[5]) + Long.parseLong(cpuInfos[7]) + Long.parseLong(cpuInfos[8]);
            return new long[]{totalCpu, idleCpu};
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static long getAppCpuTime() {
        String[] cpuInfos = null;
        try {
            int pid = Process.myPid();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/" + pid + "/stat")), 1000);
            String load = reader.readLine();
            reader.close();
            cpuInfos = load.split(" ");
            return Long.parseLong(cpuInfos[13]) + Long.parseLong(cpuInfos[14]) + Long.parseLong(cpuInfos[15]) + Long.parseLong(cpuInfos[16]);
        }
        catch (IOException ex) {
            return 1L;
        }
    }
}

