/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.api;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import com.pano.rtc.R;

class MouseView
extends View {
    private final Paint mPaint = new Paint();
    private Bitmap mCursorIcon;
    private float mCursorLeft;
    private float mCursorTop;

    MouseView(Context context) {
        this(context, null);
    }

    MouseView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Drawable drawable2 = context.getResources().getDrawable(R.drawable.cursor);
        this.mCursorIcon = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(this.mCursorIcon);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
    }

    void onCursorChanged(Bitmap bitmap) {
        if (bitmap != null) {
            this.mCursorIcon = bitmap;
        }
        this.invalidate();
    }

    void onMove(float x, float y) {
        this.mCursorLeft = x;
        this.mCursorTop = y;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawBitmap(this.mCursorIcon, this.mCursorLeft, this.mCursorTop, this.mPaint);
    }
}

