/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.api;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.pano.rtc.api.PanoLabelView;
import com.pano.rtc.api.RtcWbView;
import java.io.File;
import video.pano.rtc.api.PanoExoPlayerView;
import video.pano.rtc.api.PanoMediaPlayerView;
import video.pano.rtc.api.PanoPdfView;
import video.pano.rtc.api.PanoPlayerView;
import video.pano.rtc.api.PanoWebView;
import video.pano.rtc.impl.PLogger;

public class PanoCoursePageView
extends FrameLayout {
    private static final String TAG = "PanoCoursePageView";
    private final RtcWbView mRtcWbView;
    private final PanoLabelView mLabelView;
    private boolean mIsOpaque = true;
    private boolean mEnablePCUA = false;
    private boolean mEnableExo = false;
    private boolean mEnableTouch = true;
    private int mPdfWidthRatio = 0;
    private int mPdfHeightRatio = 0;

    public PanoCoursePageView(Context context) {
        this(context, null);
    }

    public PanoCoursePageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mRtcWbView = new RtcWbView(context, attrs);
        this.addView((View)this.mRtcWbView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mLabelView = new PanoLabelView(context, attrs);
        this.addView(this.mLabelView, -1, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    public RtcWbView getAttachRtcWbView() {
        return this.mRtcWbView;
    }

    public void setOpaque(boolean opaque) {
        this.post(() -> {
            PLogger.i(TAG, "setOpaque " + opaque + this.mIsOpaque);
            this.mRtcWbView.setVisibility(8);
            this.mRtcWbView.setTransparent(!opaque);
            this.mRtcWbView.setVisibility(0);
        });
    }

    public void setLimitSize(int w, int h) {
        this.mPdfWidthRatio = w;
        this.mPdfHeightRatio = h;
        PLogger.i(TAG, "setLimitSize " + w + ", " + h);
    }

    public void enablePCUAForExternalHtml(boolean enable) {
        this.mEnablePCUA = enable;
    }

    public void enableExoPlayer(boolean enable) {
        this.mEnableExo = enable;
    }

    public void enableTouchEvent(boolean enable) {
        this.mEnableTouch = enable;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            PLogger.i(TAG, "enableTouchEvent " + i + "," + childView);
            if (childView instanceof PanoWebView) {
                ((PanoWebView)childView).setEnableTouchEvent(enable);
            }
            if (!(childView instanceof PanoPdfView)) continue;
            ((PanoPdfView)childView).setEnableTouchEvent(enable);
        }
    }

    public void open(String pageId, long nativeHandle, String url) {
        this.post(() -> {
            PanoWebView panoWebView = this.getWebViewById(pageId);
            if (panoWebView != null) {
                PLogger.i(TAG, "open exists " + pageId);
                panoWebView.loadUrl(url);
                return;
            }
            panoWebView = new PanoWebView(this.getContext());
            if (this.mEnablePCUA && url.startsWith("http") && url.indexOf("pano.video") == -1 && url.indexOf("panortc.com") == -1) {
                panoWebView.enablePCUAForExternalHtml(true);
            }
            panoWebView.setEnableTouchEvent(this.mEnableTouch);
            panoWebView.setPageId(pageId);
            this.addView((View)panoWebView, 0, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            panoWebView.loadUrl(url);
            panoWebView.setNativeHandle(nativeHandle);
            PLogger.i(TAG, "open " + url + ", " + pageId);
        });
    }

    public void hide(String pageId) {
        this.post(() -> {
            PanoWebView panoWebView = this.getWebViewById(pageId);
            if (panoWebView != null) {
                panoWebView.setVisibility(8);
                PLogger.i(TAG, "hide " + pageId + "," + (Object)((Object)panoWebView));
            }
        });
    }

    public void show(String pageId) {
        this.post(() -> {
            PanoWebView panoWebView = this.getWebViewById(pageId);
            if (panoWebView != null) {
                panoWebView.setVisibility(0);
                PLogger.i(TAG, "show " + pageId + "," + (Object)((Object)panoWebView));
            }
        });
    }

    public void close(String pageId) {
        this.post(() -> {
            PanoWebView panoWebView = this.getWebViewById(pageId);
            if (panoWebView != null) {
                panoWebView.close();
                PLogger.i(TAG, "close " + pageId + "," + (Object)((Object)panoWebView));
                this.removeView((View)panoWebView);
            }
        });
    }

    public void close() {
        PLogger.i(TAG, "close");
        this.post(() -> {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View childView = this.getChildAt(i);
                PLogger.i(TAG, "closeall " + i + "," + childView);
                if (childView instanceof PanoWebView) {
                    ((PanoWebView)childView).close();
                    PLogger.i(TAG, "closeall " + (Object)((Object)((PanoWebView)childView)));
                    this.removeView(childView);
                    --childCount;
                    --i;
                }
                if (!(childView instanceof PanoPdfView)) continue;
                ((PanoPdfView)childView).close();
                PLogger.i(TAG, "closeall " + (Object)((Object)((PanoPdfView)childView)));
                this.removeView(childView);
                --childCount;
                --i;
            }
        });
    }

    public void resize(String pageId, int width, int height) {
        PLogger.i(TAG, "resize " + pageId);
        this.post(() -> {
            PanoWebView panoWebView = this.getWebViewById(pageId);
            if (panoWebView != null) {
                PLogger.i(TAG, "resize " + width + "," + height + "," + (Object)((Object)panoWebView));
                panoWebView.adjustSize();
                PLogger.i(TAG, "resize after, " + (Object)((Object)panoWebView));
            }
        });
    }

    public void evaluateJavaScript(String pageId, String javascript) {
        PLogger.i(TAG, "evaluateJavaScript");
        this.post(() -> {
            PanoWebView panoWebView = this.getWebViewById(pageId);
            if (panoWebView != null) {
                PLogger.i(TAG, "evaluateJavaScript " + javascript + ", " + (Object)((Object)panoWebView));
                panoWebView.evaluateJavascript(javascript, null);
            }
        });
    }

    public void scaleAtPoint(String pageId, float scale, float x, float y) {
        PanoWebView panoWebView = this.getWebViewById(pageId);
        if (panoWebView != null) {
            panoWebView.scaleAtPoint(scale, x, y);
        }
    }

    public void move(String pageId, float dx, float dy) {
        PanoWebView panoWebView = this.getWebViewById(pageId);
        if (panoWebView != null) {
            panoWebView.move(-dx, -dy);
        }
    }

    public void snapShot(String pageId, String filePath, boolean viewArea, int contentW, int contentH) {
        PanoWebView panoWebView = this.getWebViewById(pageId);
        if (panoWebView != null) {
            panoWebView.snapshot(filePath + File.separator + "whiteboard_snapshot_" + pageId + ".jpg", viewArea, contentW, contentH);
        }
    }

    public void refresh(String pageId) {
        PLogger.i(TAG, "refresh " + pageId);
        this.post(() -> {
            PanoWebView panoWebView = this.getWebViewById(pageId);
            if (panoWebView != null) {
                PLogger.i(TAG, "refresh reload " + (Object)((Object)panoWebView));
                panoWebView.reload();
            }
        });
    }

    public void setContentSize(String pageId, int width, int height) {
        this.post(() -> {
            PanoWebView panoWebView = this.getWebViewById(pageId);
            PLogger.i(TAG, "setContentSize " + width + "," + height + "," + (Object)((Object)panoWebView));
            if (panoWebView != null) {
                panoWebView.setContentSize(width, height);
                panoWebView.adjustSize();
                PLogger.i(TAG, "setContentSize after, " + (Object)((Object)panoWebView));
            }
        });
    }

    public void openMedia(String shapeId, long nativeHandle, String url) {
        this.post(() -> {
            PanoPlayerView panoMediaPlayerView = null;
            panoMediaPlayerView = this.mEnableExo ? new PanoExoPlayerView(this.getContext()) : new PanoMediaPlayerView(this.getContext());
            panoMediaPlayerView.setShapeId(shapeId);
            panoMediaPlayerView.setBackgroundColor(-16777216);
            this.addView((View)panoMediaPlayerView, -1, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            panoMediaPlayerView.setMediaUrl(url);
            panoMediaPlayerView.setNativeHandle(nativeHandle);
            PLogger.i(TAG, "openMedia " + shapeId);
        });
    }

    public void closeMedia(String shapeId) {
        PLogger.i(TAG, "closeMedia " + shapeId);
        this.post(() -> {
            PanoPlayerView panoMediaPlayerView = this.getPlayerViewById(shapeId);
            if (panoMediaPlayerView != null) {
                panoMediaPlayerView.close();
                this.removeView((View)panoMediaPlayerView);
                PLogger.i(TAG, "closeMedia " + shapeId);
            }
        });
    }

    public void stopMedia(String shapeId) {
        PLogger.i(TAG, "stopMedia " + shapeId);
        this.post(() -> {
            PanoPlayerView panoMediaPlayerView = this.getPlayerViewById(shapeId);
            if (panoMediaPlayerView != null) {
                panoMediaPlayerView.stopPlay();
                PLogger.i(TAG, "stopMedia " + shapeId);
            }
        });
    }

    public void updateMediaRgn(String shapeId, float left, float top, float right, float bottom) {
        this.post(() -> {
            PanoPlayerView panoMediaPlayerView = this.getPlayerViewById(shapeId);
            if (panoMediaPlayerView != null) {
                ViewGroup.LayoutParams params = panoMediaPlayerView.getLayoutParams();
                if (params instanceof FrameLayout.LayoutParams) {
                    FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)params;
                    lp.leftMargin = (int)left;
                    lp.topMargin = (int)top;
                    lp.width = (int)(right - left);
                    lp.height = (int)(bottom - top);
                    panoMediaPlayerView.setLayoutParams((ViewGroup.LayoutParams)lp);
                }
                panoMediaPlayerView.updateSize();
            }
        });
    }

    public void updateMediaStatus(String shapeId, boolean isPlay, float playTS, boolean isRepeat) {
        this.post(() -> {
            PanoPlayerView panoMediaPlayerView = this.getPlayerViewById(shapeId);
            if (panoMediaPlayerView != null) {
                panoMediaPlayerView.updatePlayerStatus(isPlay, playTS, isRepeat);
            }
        });
    }

    public void addCursor(String labelId, String name) {
        this.post(() -> this.mLabelView.addCursor(labelId, name));
    }

    public void removeCursor(String labelId) {
        this.post(() -> this.mLabelView.removeCursor(labelId));
    }

    public void updateCursor(String labelId, float x, float y, int color, int type) {
        this.post(() -> this.mLabelView.updateCursor(labelId, x, y, color, type));
    }

    public void openPdf(String shapeId, long nativeHandle, String url) {
        this.post(() -> {
            PanoPdfView panoPdfView = new PanoPdfView(this.getContext());
            panoPdfView.setEnableTouchEvent(this.mEnableTouch);
            int viewWidth = this.getWidth();
            int viewHeight = this.getHeight();
            int w = viewWidth;
            int h = viewHeight;
            if (this.mPdfWidthRatio == 0 || this.mPdfHeightRatio == 0) {
                this.addView((View)panoPdfView, 0, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            } else {
                if (viewWidth * this.mPdfHeightRatio > viewHeight * this.mPdfWidthRatio) {
                    w = viewHeight * this.mPdfWidthRatio / this.mPdfHeightRatio;
                    h = viewHeight;
                } else {
                    w = viewWidth;
                    h = viewWidth * this.mPdfHeightRatio / this.mPdfWidthRatio;
                }
                FrameLayout.LayoutParams l = new FrameLayout.LayoutParams(w, h);
                l.gravity = 17;
                this.addView((View)panoPdfView, 0, (ViewGroup.LayoutParams)l);
            }
            panoPdfView.setPdfUrl(url);
            panoPdfView.setShapeId(shapeId);
            panoPdfView.setNativeHandle(nativeHandle);
            PLogger.i(TAG, "openPdf " + shapeId);
        });
    }

    public void hidePdf(String shapeId) {
        this.post(() -> {
            PanoPdfView panoPdfView = this.getPdfViewById(shapeId);
            if (panoPdfView != null) {
                panoPdfView.setVisibility(8);
                PLogger.i(TAG, "hidePdf " + shapeId);
            }
        });
    }

    public void showPdf(String shapeId) {
        this.post(() -> {
            PanoPdfView panoPdfView = this.getPdfViewById(shapeId);
            if (panoPdfView != null) {
                panoPdfView.setVisibility(0);
                PLogger.i(TAG, "showPdf " + shapeId);
            }
        });
    }

    public void closePdf(String shapeId) {
        this.post(() -> {
            PanoPdfView panoPdfView = this.getPdfViewById(shapeId);
            if (panoPdfView != null) {
                panoPdfView.close();
                this.removeView((View)panoPdfView);
                PLogger.i(TAG, "closePdf " + shapeId);
            }
        });
    }

    public void scrollPdfTo(String shapeId, int page, float pos) {
        this.post(() -> {
            PanoPdfView panoPdfView = this.getPdfViewById(shapeId);
            if (panoPdfView != null) {
                panoPdfView.scrollTo(page, pos);
            }
        });
    }

    public void scalePdfTo(String shapeId, float scale, float x, float y) {
        this.post(() -> {
            PanoPdfView panoPdfView = this.getPdfViewById(shapeId);
            if (panoPdfView != null) {
                panoPdfView.scaleTo(scale, x, y);
            }
        });
    }

    public void snapshotPdf(String shapeId, String path) {
        this.post(() -> {
            PanoPdfView panoPdfView = this.getPdfViewById(shapeId);
            if (panoPdfView != null) {
                panoPdfView.snapshot(path + File.separator + "whiteboard_snapshot_" + shapeId + ".jpg");
                PLogger.i(TAG, "snapshot " + shapeId);
            }
        });
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mPdfWidthRatio != 0 && this.mPdfHeightRatio != 0) {
            int nw = w;
            int nh = h;
            if (w * this.mPdfHeightRatio > h * this.mPdfWidthRatio) {
                nw = h * this.mPdfWidthRatio / this.mPdfHeightRatio;
                nh = h;
            } else {
                nw = w;
                nh = w * this.mPdfHeightRatio / this.mPdfWidthRatio;
            }
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                ViewGroup.LayoutParams params;
                View childView = this.getChildAt(i);
                if (!(childView instanceof PanoPdfView) || !((params = childView.getLayoutParams()) instanceof FrameLayout.LayoutParams)) continue;
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)params;
                lp.width = nw;
                lp.height = nh;
                childView.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
        }
    }

    private PanoWebView getWebViewById(String pageId) {
        if (TextUtils.isEmpty((CharSequence)pageId)) {
            return null;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            PanoWebView panoWebView;
            View childView = this.getChildAt(i);
            if (!(childView instanceof PanoWebView) || !pageId.equals((panoWebView = (PanoWebView)childView).getPageId())) continue;
            return panoWebView;
        }
        return null;
    }

    private PanoPlayerView getPlayerViewById(String shapeId) {
        if (TextUtils.isEmpty((CharSequence)shapeId)) {
            return null;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            PanoPlayerView panoPlayerView;
            View childView = this.getChildAt(i);
            if (!(childView instanceof PanoPlayerView) || !shapeId.equals((panoPlayerView = (PanoPlayerView)childView).getShapeId())) continue;
            return panoPlayerView;
        }
        return null;
    }

    private PanoPdfView getPdfViewById(String shapeId) {
        if (TextUtils.isEmpty((CharSequence)shapeId)) {
            return null;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            PanoPdfView panoPdfView;
            View childView = this.getChildAt(i);
            if (!(childView instanceof PanoPdfView) || !shapeId.equals((panoPdfView = (PanoPdfView)childView).getShapeId())) continue;
            return panoPdfView;
        }
        return null;
    }
}

