/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.api;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.pano.rtc.api.MouseView;
import com.pano.rtc.api.RtcView;

public class RemoteControlView
extends FrameLayout {
    private final RtcView mRtcView;
    private final MouseView mMouseView;
    private int mHotspotX;
    private int mHotspotY;

    public RemoteControlView(Context context) {
        this(context, null);
    }

    public RemoteControlView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mRtcView = new RtcView(context);
        this.mMouseView = new MouseView(context);
        this.addView((View)this.mRtcView);
        this.addView(this.mMouseView, new ViewGroup.LayoutParams(-1, -1));
        this.mMouseView.setVisibility(8);
    }

    public RtcView getRtcView() {
        return this.mRtcView;
    }

    public void onFrame() {
        if (this.mRtcView.getViewPortWidth() == 0 || this.mRtcView.getViewPortHeight() == 0) {
            return;
        }
        if (this.mMouseView.getVisibility() == 8) {
            float translationX = (float)this.mRtcView.getViewPortX() + this.mRtcView.getOffsetX() - (float)this.mHotspotX;
            float translationY = (float)this.mRtcView.getViewPortY() + this.mRtcView.getOffsetY() - (float)this.mHotspotY;
            this.post(() -> {
                this.mMouseView.setVisibility(0);
                this.mMouseView.onMove(translationX, translationY);
            });
        }
    }

    public void onCursorChanged(Bitmap bitmap, int hotspotX, int hotspotY) {
        this.mHotspotX = hotspotX;
        this.mHotspotY = hotspotY;
        this.mMouseView.onCursorChanged(bitmap);
    }

    public void onMouseMove(float cursorX, float cursorY) {
        int viewPortX = this.mRtcView.getViewPortX();
        int viewPortY = this.mRtcView.getViewPortY();
        float translationX = (float)viewPortX + (float)this.mRtcView.getViewPortWidth() * cursorX + this.mRtcView.getOffsetX() - (float)this.mHotspotX;
        float translationY = (float)viewPortY + (float)this.mRtcView.getViewPortHeight() * cursorY + this.mRtcView.getOffsetY() - (float)this.mHotspotY;
        float dx = 0.0f;
        float dy = 0.0f;
        if (translationX < (float)(this.mRtcView.getLeft() - this.mHotspotX)) {
            dx = (float)(this.mRtcView.getLeft() - this.mHotspotX) - translationX;
            translationX = this.mRtcView.getLeft() - this.mHotspotX;
        } else if (translationX > (float)this.mRtcView.getRight()) {
            dx = (float)this.mRtcView.getRight() - translationX;
            translationX = this.mRtcView.getRight();
        }
        if (translationY < (float)(this.mRtcView.getTop() - this.mHotspotY)) {
            dy = (float)(this.mRtcView.getTop() - this.mHotspotY) - translationY;
            translationY = this.mRtcView.getTop() - this.mHotspotY;
        } else if (translationY > (float)this.mRtcView.getBottom()) {
            dy = (float)this.mRtcView.getBottom() - translationY;
            translationY = this.mRtcView.getBottom();
        }
        if (dx != 0.0f || dy != 0.0f) {
            this.mRtcView.setMovingDistance((int)dx, (int)dy);
            this.mRtcView.redrawFrame();
        }
        this.mMouseView.onMove(translationX, translationY);
    }
}

